/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IStringImage;
import fr.esrf.tangoatk.core.IStringImageListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.StringImageHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class StringImage
extends AAttribute
implements IStringImage {
    StringImageHelper imageHelper = new StringImageHelper(this);
    String[][] imageValue = null;

    @Override
    public String[][] getValue() {
        return this.imageValue;
    }

    @Override
    public void setValue(String[][] sImage) {
        try {
            DeviceAttribute da = new DeviceAttribute(this.getNameSansDevice());
            this.checkDimensions(sImage);
            this.imageHelper.insert(da, sImage);
            this.writeAtt(da);
            this.imageHelper.fireImageValueChanged(sImage, System.currentTimeMillis());
        }
        catch (DevFailed df) {
            this.setAttError("Couldn't set value", new AttributeSetException(df));
        }
        catch (Exception ex) {
            this.setAttError("Couldn't set value", new ATKException(ex));
        }
    }

    @Override
    public void refresh() {
        DeviceAttribute att = null;
        ++this.refreshCount;
        try {
            try {
                att = this.readValueFromNetwork();
                if (att == null) {
                    return;
                }
                this.imageValue = this.imageHelper.getStringImageValue(att);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed e) {
                this.readAttError(e.getMessage(), new AttributeReadException(e));
            }
            catch (Error err) {
                this.readAttError(err.getMessage(), new AttributeReadException(err));
            }
        }
        catch (Throwable th) {
            System.out.println("StringImage.refresh() Throwable caught ------------------------------");
            th.printStackTrace();
            System.out.println("StringImage.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute attValue) {
        ++this.refreshCount;
        try {
            try {
                if (attValue == null) {
                    return;
                }
                this.attribute = attValue;
                this.setState(attValue);
                this.timeStamp = attValue.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getStringImageValue(attValue);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed e) {
                this.dispatchError(e);
            }
        }
        catch (Exception e) {
            System.out.println("StringImage.dispatch() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("StringImage.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed e) {
        this.imageValue = null;
        this.readAttError(e.getMessage(), new AttributeReadException(e));
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(String[][] newValue) {
        this.imageHelper.fireImageValueChanged(newValue, this.timeStamp);
    }

    @Override
    public void addStringImageListener(IStringImageListener l) {
        this.imageHelper.addStringImageListener(l);
        this.addStateListener(l);
    }

    @Override
    public void removeStringImageListener(IStringImageListener l) {
        this.imageHelper.removeStringImageListener(l);
        this.removeStateListener(l);
    }

    public void periodic(TangoPeriodicEvent evt) {
        ++this.periodicCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(128, "StringImage.periodic method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(128, "StringImage.periodicEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(128, "StringImage.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "StringImage.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(128, "StringImage.periodicEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(128, "StringImage.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            System.out.println("StringImage.periodic.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("StringImage.periodic.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getStringImageValue(da);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed dfe) {
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                System.out.println("StringImage.periodic.extractString() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("StringImage.periodic.extractString()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent evt) {
        ++this.changeCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(32, "StringImage.change method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(32, "StringImage.changeEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(32, "StringImage.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "StringImage.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(32, "StringImage.changeEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(32, "StringImage.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            System.out.println("StringImage.change.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("StringImage.change.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getStringImageValue(da);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed dfe) {
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                System.out.println("StringImage.change.extractString() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("StringImage.change.extractString()------------------------------------------------");
            }
        }
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        in.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isSpectrum() {
        return false;
    }

    @Override
    public boolean isImage() {
        return true;
    }
}

