/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IRawImage;
import fr.esrf.tangoatk.core.IRawImageListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class RawImageHelper
implements Serializable {
    IAttribute attribute;
    EventSupport propChanges;
    String encFormat = null;

    public RawImageHelper(IAttribute attribute) {
        this.init(attribute);
    }

    void init(IAttribute attribute) {
        this.setAttribute(attribute);
        this.propChanges = ((AAttribute)attribute).getPropChanges();
    }

    public void setAttribute(IAttribute attribute) {
        this.attribute = attribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String name, Number value) {
        this.attribute.setProperty(name, value);
        this.attribute.storeConfig();
    }

    protected void setProperty(String name, Number value, boolean writable) {
        this.attribute.setProperty(name, value, writable);
    }

    void fireRawImageValueChanged(String encFormat, byte[] newValue, long timeStamp) {
        this.propChanges.fireRawImageEvent((IRawImage)this.attribute, encFormat, newValue, timeStamp);
    }

    byte[] getRawImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        DevEncoded e = deviceAttribute.extractDevEncoded();
        this.encFormat = e.encoded_format;
        return e.encoded_data;
    }

    String getRawImageFormat() {
        return this.encFormat;
    }

    void addRawImageListener(IRawImageListener l) {
        this.propChanges.addRawImageListener(l);
    }

    void removeRawImageListener(IRawImageListener l) {
        this.propChanges.removeRawImageListener(l);
    }

    public String getVersion() {
        return "$Id$";
    }
}

