/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IRawImage;
import fr.esrf.tangoatk.core.IRawImageListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.RawImageHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class RawImage
extends AAttribute
implements IRawImage {
    RawImageHelper imageHelper = new RawImageHelper(this);
    byte[] imageValue = null;
    String encFormat;

    @Override
    public String getType() {
        return "RawImage";
    }

    @Override
    public byte[] getValue() {
        return this.imageValue;
    }

    @Override
    public String getEncodedFormat() {
        return this.encFormat;
    }

    @Override
    public void setValue(String format, byte[] bImage) {
        this.setAttError("Couldn't set value of RawImage", new AttributeSetException("RawImage writting not supported"));
    }

    @Override
    public void refresh() {
        DeviceAttribute att = null;
        ++this.refreshCount;
        try {
            try {
                att = this.readValueFromNetwork();
                if (att == null) {
                    return;
                }
                this.imageValue = this.imageHelper.getRawImageValue(att);
                this.encFormat = this.imageHelper.getRawImageFormat();
                this.fireValueChanged(this.encFormat, this.imageValue);
            }
            catch (DevFailed e) {
                this.readAttError(e.getMessage(), new AttributeReadException(e));
            }
            catch (Error err) {
                this.readAttError(err.getMessage(), new AttributeReadException(err));
            }
        }
        catch (Throwable th) {
            System.out.println("RawImage.refresh() Throwable caught ------------------------------");
            th.printStackTrace();
            System.out.println("RawImage.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute attValue) {
        ++this.refreshCount;
        try {
            try {
                if (attValue == null) {
                    return;
                }
                this.attribute = attValue;
                this.setState(attValue);
                this.timeStamp = attValue.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getRawImageValue(attValue);
                this.encFormat = this.imageHelper.getRawImageFormat();
                this.fireValueChanged(this.encFormat, this.imageValue);
            }
            catch (DevFailed e) {
                this.dispatchError(e);
            }
        }
        catch (Exception e) {
            System.out.println("RawImage.dispatch() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("RawImage.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed e) {
        this.imageValue = null;
        this.readAttError(e.getMessage(), new AttributeReadException(e));
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(String encForamt, byte[] newValue) {
        this.imageHelper.fireRawImageValueChanged(this.encFormat, newValue, this.timeStamp);
    }

    @Override
    public void addRawImageListener(IRawImageListener l) {
        this.imageHelper.addRawImageListener(l);
        this.addStateListener(l);
    }

    @Override
    public void removeRawImageListener(IRawImageListener l) {
        this.imageHelper.removeRawImageListener(l);
        this.removeStateListener(l);
    }

    public void periodic(TangoPeriodicEvent evt) {
        ++this.periodicCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(128, "RawImage.periodic method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(128, "RawImage.periodicEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(128, "RawImage.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "RawImage.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(128, "RawImage.periodicEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(128, "RawImage.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            System.out.println("RawImage.periodic.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("RawImage.periodic.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getRawImageValue(da);
                this.encFormat = this.imageHelper.getRawImageFormat();
                this.fireValueChanged(this.encFormat, this.imageValue);
            }
            catch (DevFailed dfe) {
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                System.out.println("RawImage.periodic.extractCharArray() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("RawImage.periodic.extractCharArray()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent evt) {
        ++this.changeCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(32, "RawImage.change method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(32, "RawImage.changeEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(32, "RawImage.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "RawImage.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(32, "RawImage.changeEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(32, "RawImage.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            System.out.println("RawImage.change.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("RawImage.change.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getRawImageValue(da);
                this.encFormat = this.imageHelper.getRawImageFormat();
                this.fireValueChanged(this.encFormat, this.imageValue);
            }
            catch (DevFailed dfe) {
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                System.out.println("RawImage.change.extractCharArray() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("RawImage.change.extractCharArray()------------------------------------------------");
            }
        }
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        in.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isSpectrum() {
        return false;
    }

    @Override
    public boolean isImage() {
        return true;
    }
}

