/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.INumberSpectrumHistory;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.attribute.ANumber;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.NumberSpectrumHistory;
import java.io.IOException;
import java.io.ObjectInputStream;

public class NumberSpectrum
extends ANumber
implements INumberSpectrum {
    double[] spectrumValue;
    double[] spectrumSetPointValue;
    double[] devSpectrumValue;
    double[] devSpectrumSetPointValue;
    boolean hasXminmaxProperties = false;
    boolean hasXminmaxAttributes = false;
    String XminAttName = null;
    String XmaxAttName = null;
    double xminValue = -1.0;
    double xmaxValue = -1.0;

    public ANumberSpectrumHelper getNumberSpectrumHelper() {
        return (ANumberSpectrumHelper)this.getNumberHelper();
    }

    @Override
    public void addSpectrumListener(ISpectrumListener l) {
        this.propChanges.addSpectrumListener(l);
    }

    @Override
    public void removeSpectrumListener(ISpectrumListener l) {
        this.propChanges.removeSpectrumListener(l);
    }

    public void setValue(double[][] d) {
        this.setValue(d[0]);
    }

    public double[][] getValue() {
        double[][] val = new double[][]{this.getSpectrumValue()};
        return val;
    }

    @Override
    public void setValue(double[] d) {
        try {
            DeviceAttribute da = new DeviceAttribute(this.getNameSansDevice());
            this.insert(da, d);
            this.writeAtt(da);
            this.refresh();
        }
        catch (DevFailed df) {
            this.setAttError("Couldn't set value", new AttributeSetException(df));
        }
    }

    protected void checkDimensions(double[] o) {
        if (o.length > this.getMaxXDimension()) {
            throw new IllegalStateException("Invalid spectrum dimension " + o.length + ">" + this.getMaxXDimension());
        }
    }

    protected void insert(DeviceAttribute da, double[] d) {
        this.checkDimensions(d);
        this.getNumberSpectrumHelper().insert(da, d);
    }

    @Override
    public void refresh() {
        ++this.refreshCount;
        try {
            try {
                DeviceAttribute da = this.readValueFromNetwork();
                this.spectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplayValue(da);
                this.spectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplaySetPoint(da);
                this.devSpectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumValue(da);
                this.devSpectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumSetPoint(da);
                this.timeStamp = da.getTimeValMillisSec();
                this.getNumberSpectrumHelper().fireSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (DevFailed e) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                this.readAttError(e.getMessage(), new AttributeReadException(e));
            }
            catch (Error err) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                this.readAttError(err.getMessage(), new AttributeReadException(err));
            }
        }
        catch (Throwable th) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            this.devSpectrumValue = null;
            this.devSpectrumSetPointValue = null;
            System.out.println("NumberSpectrum.refresh() Throwable caught ------------------------------");
            th.printStackTrace();
            System.out.println("NumberSpectrum.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute attValue) {
        ++this.refreshCount;
        try {
            try {
                if (attValue == null) {
                    return;
                }
                this.attribute = attValue;
                this.setState(attValue);
                this.timeStamp = attValue.getTimeValMillisSec();
                this.spectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplayValue(attValue);
                this.spectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplaySetPoint(attValue);
                this.devSpectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumValue(attValue);
                this.devSpectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumSetPoint(attValue);
                this.getNumberSpectrumHelper().fireSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (DevFailed e) {
                this.dispatchError(e);
            }
        }
        catch (Exception e) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            this.devSpectrumValue = null;
            this.devSpectrumSetPointValue = null;
            System.out.println("NumberSpectrum.dispatch() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("NumberSpectrum.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed e) {
        this.spectrumValue = null;
        this.spectrumSetPointValue = null;
        this.devSpectrumValue = null;
        this.devSpectrumSetPointValue = null;
        this.readAttError(e.getMessage(), new AttributeReadException(e));
    }

    @Override
    public double[] getSpectrumValue() {
        return this.spectrumValue;
    }

    @Override
    public double[] getSpectrumDeviceValue() {
        return this.devSpectrumValue;
    }

    @Override
    public double[] getSpectrumStandardValue() {
        double stdUnitFactor = 1.0;
        stdUnitFactor = this.getStandardUnitFactor();
        if (stdUnitFactor <= 0.0) {
            stdUnitFactor = 1.0;
        }
        if (stdUnitFactor == 1.0) {
            return this.devSpectrumValue;
        }
        if (this.devSpectrumValue == null) {
            return null;
        }
        double[] stdVal = new double[this.devSpectrumValue.length];
        for (int i = 0; i < this.devSpectrumValue.length; ++i) {
            stdVal[i] = this.devSpectrumValue[i] * stdUnitFactor;
        }
        return stdVal;
    }

    @Override
    public double[] getSpectrumSetPoint() {
        return this.spectrumSetPointValue;
    }

    @Override
    public double[] getSpectrumDeviceSetPoint() {
        return this.devSpectrumSetPointValue;
    }

    @Override
    public double[] getSpectrumStandardSetPoint() {
        double stdUnitFactor = 1.0;
        stdUnitFactor = this.getStandardUnitFactor();
        if (stdUnitFactor <= 0.0) {
            stdUnitFactor = 1.0;
        }
        if (stdUnitFactor == 1.0) {
            return this.devSpectrumSetPointValue;
        }
        if (this.devSpectrumSetPointValue == null) {
            return null;
        }
        double[] stdVal = new double[this.devSpectrumSetPointValue.length];
        for (int i = 0; i < this.devSpectrumSetPointValue.length; ++i) {
            stdVal[i] = this.devSpectrumSetPointValue[i] * stdUnitFactor;
        }
        return stdVal;
    }

    @Override
    public INumberSpectrumHistory[] getNumberSpectrumHistory() {
        INumberSpectrumHistory[] attHist = null;
        try {
            attHist = (NumberSpectrumHistory[])this.getNumberSpectrumHelper().getSpectrumAttHistory(this.readAttHistoryFromNetwork());
        }
        catch (DevFailed e) {
            this.readAttError(e.getMessage(), new AttributeReadException(e));
            attHist = null;
        }
        catch (Exception e) {
            this.readAttError(e.getMessage(), e);
            attHist = null;
        }
        return attHist;
    }

    @Override
    public INumberSpectrumHistory[] getNumberSpectrumDeviceHistory() {
        INumberSpectrumHistory[] attHist = null;
        try {
            attHist = (NumberSpectrumHistory[])this.getNumberSpectrumHelper().getSpectrumDeviceAttHistory(this.readAttHistoryFromNetwork());
        }
        catch (DevFailed e) {
            this.readAttError(e.getMessage(), new AttributeReadException(e));
            attHist = null;
        }
        catch (Exception e) {
            this.readAttError(e.getMessage(), e);
            attHist = null;
        }
        return attHist;
    }

    public void periodic(TangoPeriodicEvent evt) {
        ++this.periodicCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(128, "NumberSpectrum.periodic method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(128, "NumberSpectrum.periodicEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(128, "NumberSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "NumberSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(128, "NumberSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(128, "NumberSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            this.devSpectrumValue = null;
            this.devSpectrumSetPointValue = null;
            System.out.println("NumberSpectrum.periodic.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("NumberSpectrum.periodic.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.spectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplayValue(da);
                this.spectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplaySetPoint(da);
                this.devSpectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumValue(da);
                this.devSpectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumSetPoint(da);
                this.getNumberSpectrumHelper().fireSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (DevFailed dfe) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                System.out.println("NumberSpectrum.periodic.getNumberSpectrumDisplayValue() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("NumberSpectrum.periodic.getNumberSpectrumDisplayValue()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent evt) {
        ++this.changeCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(32, "NumberSpectrum.change method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(32, "NumberSpectrum.changeEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(32, "NumberSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "NumberSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(32, "NumberSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(32, "NumberSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            this.devSpectrumValue = null;
            this.devSpectrumSetPointValue = null;
            System.out.println("NumberSpectrum.change.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("NumberSpectrum.change.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.spectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplayValue(da);
                this.spectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumDisplaySetPoint(da);
                this.devSpectrumValue = this.getNumberSpectrumHelper().getNumberSpectrumValue(da);
                this.devSpectrumSetPointValue = this.getNumberSpectrumHelper().getNumberSpectrumSetPoint(da);
                this.getNumberSpectrumHelper().fireSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (DevFailed dfe) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.devSpectrumValue = null;
                this.devSpectrumSetPointValue = null;
                System.out.println("NumberSpectrum.change.getNumberSpectrumDisplayValue() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("NumberSpectrum.change.getNumberSpectrumDisplayValue()------------------------------------------------");
            }
        }
    }

    @Override
    public void freeInternalData() {
        super.freeInternalData();
        this.spectrumValue = null;
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        in.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public int getYDimension() {
        return 1;
    }

    @Override
    public int getMaxYDimension() {
        return 1;
    }

    @Override
    public boolean hasMinxMaxxAttributes() {
        return this.hasXminmaxAttributes;
    }

    @Override
    public boolean hasMinxMaxxProperties() {
        return this.hasXminmaxProperties;
    }

    @Override
    public String getMinxAttName() {
        return this.XminAttName;
    }

    @Override
    public String getMaxxAttName() {
        return this.XmaxAttName;
    }

    @Override
    public double getMinx() {
        return this.xminValue;
    }

    @Override
    public double getMaxx() {
        return this.xmaxValue;
    }

    @Override
    public void loadAttProperties() {
        DbAttribute dbAtt = null;
        DbDatum propDbDatum = null;
        String xmin_att_name = null;
        String xmax_att_name = null;
        double xmin_prop_val = -1.0;
        double xmax_prop_val = -1.0;
        boolean hasXmin = false;
        boolean hasXmax = false;
        try {
            this.attPropertiesLoaded = true;
            dbAtt = this.getDevice().get_attribute_property(this.getNameSansDevice());
            if (dbAtt == null) {
                return;
            }
            if (!dbAtt.is_empty("XminAttribute") && (propDbDatum = dbAtt.datum("XminAttribute")) != null && !propDbDatum.is_empty()) {
                xmin_att_name = propDbDatum.extractString();
            }
            if (!dbAtt.is_empty("XmaxAttribute") && (propDbDatum = dbAtt.datum("XmaxAttribute")) != null && !propDbDatum.is_empty()) {
                xmax_att_name = propDbDatum.extractString();
            }
            if (xmin_att_name != null && xmax_att_name != null && xmin_att_name.length() > 0 && xmax_att_name.length() > 0) {
                this.hasXminmaxAttributes = true;
            }
            if (this.hasXminmaxAttributes) {
                this.XminAttName = xmin_att_name;
                this.XmaxAttName = xmax_att_name;
                return;
            }
            if (!dbAtt.is_empty("Xmin") && (propDbDatum = dbAtt.datum("Xmin")) != null && !propDbDatum.is_empty()) {
                hasXmin = true;
                xmin_prop_val = propDbDatum.extractDouble();
            }
            if (!dbAtt.is_empty("Xmax") && (propDbDatum = dbAtt.datum("Xmax")) != null && !propDbDatum.is_empty()) {
                hasXmax = true;
                xmax_prop_val = propDbDatum.extractDouble();
            }
            if (hasXmin && hasXmax) {
                this.hasXminmaxProperties = true;
                this.xminValue = xmin_prop_val;
                this.xmaxValue = xmax_prop_val;
            }
        }
        catch (Exception ex) {
            System.out.println("get_attribute_property(" + this.getName() + ") thrown exception");
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isSpectrum() {
        return true;
    }

    @Override
    public boolean isImage() {
        return false;
    }
}

