/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.attribute.ANumber;
import fr.esrf.tangoatk.core.attribute.ANumberImageHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class NumberImage
extends ANumber
implements INumberImage {
    double[][] imageValue;

    public ANumberImageHelper getNumberImageHelper() {
        return (ANumberImageHelper)this.getNumberHelper();
    }

    public void addNumberImageListener(IImageListener l) {
        this.getNumberImageHelper().addImageListener(l);
    }

    public void removeNumberImageListener(IImageListener l) {
        this.getNumberImageHelper().removeImageListener(l);
    }

    @Override
    public void refresh() {
        ++this.refreshCount;
        try {
            try {
                this.imageValue = this.getNumberImageHelper().getNumberImageDisplayValue(this.readValueFromNetwork());
                this.getNumberImageHelper().fireImageValueChanged(this.imageValue, this.timeStamp);
            }
            catch (DevFailed e) {
                this.imageValue = null;
                this.readAttError(e.getMessage(), new AttributeReadException(e));
            }
            catch (Error err) {
                this.imageValue = null;
                this.readAttError(err.getMessage(), new AttributeReadException(err));
            }
        }
        catch (Throwable th) {
            this.imageValue = null;
            System.out.println("NumberImage.refresh() Throwable caught ------------------------------");
            th.printStackTrace();
            System.out.println("NumberImage.refresh()------------------------------------------------");
        }
    }

    @Override
    public void addImageListener(IImageListener l) {
        this.propChanges.addImageListener(l);
    }

    @Override
    public void removeImageListener(IImageListener l) {
        this.propChanges.removeImageListener(l);
    }

    @Override
    public void dispatch(DeviceAttribute attValue) {
        ++this.refreshCount;
        try {
            try {
                if (attValue == null) {
                    return;
                }
                this.attribute = attValue;
                this.setState(attValue);
                this.timeStamp = attValue.getTimeValMillisSec();
                this.imageValue = this.getNumberImageHelper().getNumberImageDisplayValue(attValue);
                this.getNumberImageHelper().fireImageValueChanged(this.imageValue, this.timeStamp);
            }
            catch (DevFailed e) {
                this.dispatchError(e);
            }
        }
        catch (Exception e) {
            this.imageValue = null;
            System.out.println("NumberImage.dispatch() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("NumberImage.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed e) {
        this.imageValue = null;
        this.readAttError(e.getMessage(), new AttributeReadException(e));
    }

    @Override
    public void setValue(double[][] d) {
        try {
            DeviceAttribute da = new DeviceAttribute(this.getNameSansDevice());
            this.checkDimensions(d);
            this.getNumberImageHelper().insert(da, d);
            this.writeAtt(da);
            this.getNumberImageHelper().fireImageValueChanged(d, System.currentTimeMillis());
        }
        catch (DevFailed df) {
            this.setAttError("Couldn't set value", new AttributeSetException(df));
        }
    }

    public String[][] extract() throws DevFailed {
        return this.getNumberImageHelper().getImageValueAsString(this.readValueFromNetwork());
    }

    @Override
    public double[][] getValue() {
        return this.imageValue;
    }

    public void periodic(TangoPeriodicEvent evt) {
        ++this.periodicCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(128, "NumberImage.periodic method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(128, "NumberImage.periodicEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(128, "NumberImage.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "NumberImage.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.imageValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(128, "NumberImage.periodicEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.imageValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(128, "NumberImage.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            this.imageValue = null;
            System.out.println("NumberImage.periodic.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("NumberImage.periodic.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.imageValue = this.getNumberImageHelper().getNumberImageDisplayValue(da);
                this.getNumberImageHelper().fireImageValueChanged(this.imageValue, this.timeStamp);
            }
            catch (DevFailed dfe) {
                this.imageValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.imageValue = null;
                System.out.println("NumberImage.periodic.getNumberImageDisplayValue() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("NumberImage.periodic.getNumberImageDisplayValue()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent evt) {
        ++this.changeCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(32, "NumberImage.change method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(32, "NumberImage.changeEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(32, "NumberImage.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "NumberImage.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.imageValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(32, "NumberImage.changeEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.imageValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(32, "NumberImage.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            this.imageValue = null;
            System.out.println("NumberImage.change.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("NumberImage.change.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.imageValue = this.getNumberImageHelper().getNumberImageDisplayValue(da);
                this.getNumberImageHelper().fireImageValueChanged(this.imageValue, this.timeStamp);
            }
            catch (DevFailed dfe) {
                this.imageValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.imageValue = null;
                System.out.println("NumberImage.change.getNumberImageDisplayValue() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("NumberImage.change.getNumberImageDisplayValue()------------------------------------------------");
            }
        }
    }

    @Override
    public void freeInternalData() {
        super.freeInternalData();
        this.imageValue = null;
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        in.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isSpectrum() {
        return false;
    }

    @Override
    public boolean isImage() {
        return true;
    }
}

