/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberImageHelper;

class FloatImageHelper
extends ANumberImageHelper {
    public FloatImageHelper(AAttribute attribute) {
        this.init(attribute);
    }

    @Override
    protected void insert(DeviceAttribute da, double[][] d) {
        double dUnitFactor = 1.0;
        dUnitFactor = this.attribute.getDisplayUnitFactor();
        double[] flatd = FloatImageHelper.flatten(d);
        float[] tmp = new float[flatd.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = (float)(flatd[i] / dUnitFactor);
        }
        da.insert(tmp, d[0].length, d.length);
    }

    @Override
    void setMinAlarm(double d, boolean writable) {
        this.setProperty("min_alarm", new Float(d), writable);
    }

    @Override
    void setMaxAlarm(double d, boolean writable) {
        this.setProperty("max_alarm", new Float(d), writable);
    }

    @Override
    void setMinValue(double d, boolean writable) {
        this.setProperty("min_value", new Float(d), writable);
    }

    @Override
    void setMaxValue(double d, boolean writable) {
        this.setProperty("max_value", new Float(d), writable);
    }

    @Override
    void setMinWarning(double d, boolean writable) {
        this.setProperty("min_warning", new Float(d), writable);
    }

    @Override
    void setMaxWarning(double d, boolean writable) {
        this.setProperty("max_warning", new Float(d), writable);
    }

    @Override
    void setDeltaT(double d, boolean writable) {
        this.setProperty("delta_t", new Float(d), writable);
    }

    @Override
    void setDeltaVal(double d, boolean writable) {
        this.setProperty("delta_val", new Float(d), writable);
    }

    @Override
    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Float(d));
    }

    @Override
    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Float(d));
    }

    @Override
    void setMinValue(double d) {
        this.setProperty("min_value", new Float(d));
    }

    @Override
    void setMaxValue(double d) {
        this.setProperty("max_value", new Float(d));
    }

    @Override
    void setMinWarning(double d) {
        this.setProperty("min_warning", new Float(d));
    }

    @Override
    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Float(d));
    }

    @Override
    void setDeltaT(double d) {
        this.setProperty("delta_t", new Float(d));
    }

    @Override
    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Float(d));
    }

    @Override
    double[][] getNumberImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        float[] tmp = deviceAttribute.extractFloatArray();
        int ydim = deviceAttribute.getDimY();
        int xdim = deviceAttribute.getDimX();
        if (ydim != this.retval.length || xdim != this.retval[0].length) {
            this.retval = new double[ydim][xdim];
        }
        int k = 0;
        for (int y = 0; y < ydim; ++y) {
            for (int x = 0; x < xdim; ++x) {
                this.retval[y][x] = tmp[k++];
            }
        }
        return this.retval;
    }

    @Override
    double[][] getNumberImageDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        float[] tmp = deviceAttribute.extractFloatArray();
        double dUnitFactor = this.attribute.getDisplayUnitFactor();
        int ydim = deviceAttribute.getDimY();
        int xdim = deviceAttribute.getDimX();
        if (ydim != this.retval.length || xdim != this.retval[0].length) {
            this.retval = new double[ydim][xdim];
        }
        int k = 0;
        for (int y = 0; y < ydim; ++y) {
            for (int x = 0; x < xdim; ++x) {
                this.retval[y][x] = (double)tmp[k++] * dUnitFactor;
            }
        }
        return this.retval;
    }

    @Override
    String[][] getImageValueAsString(DeviceAttribute deviceAttribute) throws DevFailed {
        float[] tmp = deviceAttribute.extractFloatArray();
        int ydim = deviceAttribute.getDimY();
        int xdim = deviceAttribute.getDimX();
        String[][] retval_str = new String[ydim][xdim];
        int k = 0;
        for (int i = 0; i < ydim; ++i) {
            for (int j = 0; j < xdim; ++j) {
                retval_str[i][j] = Float.toString(tmp[k++]);
            }
        }
        return retval_str;
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }
}

