/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IEnumSpectrum;
import fr.esrf.tangoatk.core.IEnumSpectrumListener;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StringArrayProperty;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.EnumSpectrumHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;

public class EnumSpectrum
extends AAttribute
implements IEnumSpectrum,
PropertyChangeListener {
    EnumSpectrumHelper enumSpecHelper = null;
    String[] spectrumValue = null;
    String[] spectrumSetPointValue = null;
    private String[] enumLabels = null;

    public EnumSpectrum(String[] enums) {
        this.enumLabels = enums;
    }

    @Override
    protected void init(Device d, String name, AttributeInfoEx config, boolean doEvent) {
        super.init(d, name, config, doEvent);
        Property p = null;
        p = this.getProperty("enum_label");
        if (p != null) {
            p.addPresentationListener(this);
        }
    }

    @Override
    public String getType() {
        return "EnumSpectrum";
    }

    public void setEnumSpectrumHelper(EnumSpectrumHelper helper) {
        this.enumSpecHelper = helper;
    }

    @Override
    public String[] getEnumSpectrumValue() {
        return this.spectrumValue;
    }

    @Override
    public void setEnumSpectrumValue(String[] s) {
        try {
            DeviceAttribute da = new DeviceAttribute(this.getNameSansDevice());
            this.enumSpecHelper.insert(da, s);
            this.writeAtt(da);
        }
        catch (AttributeSetException attEx) {
            this.setAttError("Couldn't set value", attEx);
        }
        catch (DevFailed df) {
            this.setAttError("Couldn't set value", new AttributeSetException(df));
        }
    }

    @Override
    public String[] getEnumSpectrumSetPoint() {
        return this.spectrumSetPointValue;
    }

    public String[] getEnumScalarSetPointFromDevice() {
        try {
            this.spectrumSetPointValue = this.enumSpecHelper.getEnumSpectrumSetPoint(this.readDeviceValueFromNetwork());
        }
        catch (DevFailed e) {
            this.readAttError(e.getMessage(), new AttributeReadException(e));
            this.spectrumSetPointValue = null;
        }
        catch (Exception e) {
            this.readAttError(e.getMessage(), e);
            this.spectrumSetPointValue = null;
        }
        return this.spectrumSetPointValue;
    }

    @Override
    public void addEnumSpectrumListener(IEnumSpectrumListener l) {
        this.enumSpecHelper.addEnumSpectrumListener(l);
        this.addStateListener(l);
    }

    @Override
    public void removeEnumSpectrumListener(IEnumSpectrumListener l) {
        this.enumSpecHelper.removeEnumSpectrumListener(l);
        this.removeStateListener(l);
    }

    @Override
    public void refresh() {
        DeviceAttribute att = null;
        long t0 = System.currentTimeMillis();
        ++this.refreshCount;
        this.trace(4, "EnumSpectrum.refresh() method called for " + this.getName(), t0);
        try {
            try {
                this.attribute = att = this.readValueFromNetwork();
                if (att == null) {
                    return;
                }
                this.trace(4, "EnumSpectrum.refresh(" + this.getName() + ") readValueFromNetwork success", t0);
                this.spectrumValue = this.enumSpecHelper.getEnumSpectrumValue(att);
                this.spectrumSetPointValue = this.enumSpecHelper.getEnumSpectrumSetPoint(att);
                this.trace(4, "EnumSpectrum.refresh(" + this.getName() + ") fireValueChanged(spectrumValue) success", t0);
                this.enumSpecHelper.fireEnumSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (AttributeReadException attEx) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError("Invalid enum value read.", attEx);
            }
            catch (DevFailed e) {
                this.trace(4, "EnumSpectrum.refresh(" + this.getName() + ") failed, caught DevFailed; will call readAttError", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(e.getMessage(), new AttributeReadException(e));
            }
            catch (Error err) {
                this.trace(4, "EnumSpectrum.refresh(" + this.getName() + ") failed, caught java.lang.Error; will call readAttError", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(err.getMessage(), new AttributeReadException(err));
            }
        }
        catch (Throwable th) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            this.trace(4, "EnumSpectrum.refresh(" + this.getName() + ") Code failure, caught other Throwable", t0);
            System.out.println("EnumSpectrum.refresh() Throwable caught ------------------------------");
            th.printStackTrace();
            System.out.println("EnumSpectrum.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute attValue) {
        ++this.refreshCount;
        try {
            try {
                if (attValue == null) {
                    return;
                }
                this.attribute = attValue;
                this.setState(attValue);
                this.timeStamp = attValue.getTimeValMillisSec();
                this.spectrumValue = this.enumSpecHelper.getEnumSpectrumValue(attValue);
                this.spectrumSetPointValue = this.enumSpecHelper.getEnumSpectrumSetPoint(attValue);
                this.enumSpecHelper.fireEnumSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (AttributeReadException attEx) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError("Invalid enum value read.", attEx);
            }
            catch (DevFailed e) {
                this.dispatchError(e);
            }
        }
        catch (Exception e) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("EnumSpectrum.dispatch() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("EnumSpectrum.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed e) {
        this.spectrumValue = null;
        this.spectrumSetPointValue = null;
        this.readAttError(e.getMessage(), new AttributeReadException(e));
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    public String[] getEnumValues() {
        return this.enumLabels;
    }

    public void periodic(TangoPeriodicEvent evt) {
        ++this.periodicCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(128, "EnumSpectrum.periodic method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(128, "EnumSpectrum.periodicEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(128, "EnumSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "EnumSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(128, "EnumSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(128, "EnumSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("EnumSpectrum.periodic.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("EnumSpectrum.periodic.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.spectrumValue = this.enumSpecHelper.getEnumSpectrumValue(da);
                this.spectrumSetPointValue = this.enumSpecHelper.getEnumSpectrumSetPoint(da);
                this.enumSpecHelper.fireEnumSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (AttributeReadException attEx) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError("Invalid enum value read.", attEx);
            }
            catch (DevFailed dfe) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                System.out.println("EnumSpectrum.periodic.extractString() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("EnumSpectrum.periodic.extractString()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent evt) {
        ++this.changeCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(32, "EnumSpectrum.change method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(32, "EnumSpectrum.changeEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(32, "EnumSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "EnumSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(32, "EnumSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(32, "EnumSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("EnumSpectrum.change.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("EnumSpectrum.change.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.spectrumValue = this.enumSpecHelper.getEnumSpectrumValue(da);
                this.spectrumSetPointValue = this.enumSpecHelper.getEnumSpectrumSetPoint(da);
                this.enumSpecHelper.fireEnumSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (AttributeReadException attEx) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError("Invalid enum value read.", attEx);
            }
            catch (DevFailed dfe) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                System.out.println("EnumSpectrum.change.extractString() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("EnumSpectrum.change.extractString()------------------------------------------------");
            }
        }
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        in.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property src = (Property)evt.getSource();
        if (src == null) {
            return;
        }
        if (src.getName().equalsIgnoreCase("enum_label") && src instanceof StringArrayProperty) {
            StringArrayProperty sap = (StringArrayProperty)src;
            String[] newEnums = sap.getStringArrayValue();
            this.updateEnumLabels(newEnums);
        }
    }

    private void updateEnumLabels(String[] enums) {
        if (enums == null) {
            return;
        }
        this.enumLabels = enums;
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isSpectrum() {
        return true;
    }

    @Override
    public boolean isImage() {
        return false;
    }
}

