/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StringArrayProperty;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.EnumScalarHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;

public class EnumScalar
extends AAttribute
implements IEnumScalar,
PropertyChangeListener {
    EnumScalarHelper enumHelper = null;
    String scalarValue = null;
    String setPointValue = null;
    private String[] enumLabels = null;
    private String[] enumSetLabels = null;

    public EnumScalar(String[] enums) {
        this.enumLabels = enums;
        this.enumSetLabels = this.enumLabels;
    }

    public EnumScalar(String[] enums, String[] setEnumExclusion) {
        this.enumLabels = enums;
        if (setEnumExclusion != null && setEnumExclusion.length >= 1) {
            this.setEnumSetLabels(setEnumExclusion);
        }
        if (this.enumSetLabels == null) {
            this.enumSetLabels = this.enumLabels;
        }
    }

    @Override
    protected void init(Device d, String name, AttributeInfoEx config, boolean doEvent) {
        super.init(d, name, config, doEvent);
        Property p = null;
        p = this.getProperty("enum_label");
        if (p != null) {
            p.addPresentationListener(this);
        }
    }

    private void setEnumSetLabels(String[] enmuSetExcludeLabels) {
        int i;
        int nbSetLabs = this.enumLabels.length;
        for (i = 0; i < enmuSetExcludeLabels.length; ++i) {
            if (!EnumScalar.containsEnumLabel(this.enumLabels, enmuSetExcludeLabels[i])) continue;
            --nbSetLabs;
        }
        if (nbSetLabs <= 0) {
            return;
        }
        if (nbSetLabs == this.enumLabels.length) {
            return;
        }
        this.enumSetLabels = new String[nbSetLabs];
        int indSetLabel = 0;
        for (i = 0; i < this.enumLabels.length; ++i) {
            if (EnumScalar.containsEnumLabel(enmuSetExcludeLabels, this.enumLabels[i])) continue;
            this.enumSetLabels[indSetLabel] = new String(this.enumLabels[i]);
            ++indSetLabel;
        }
    }

    public static boolean containsEnumLabel(String[] labelList, String label) {
        if (label == null) {
            return false;
        }
        if (label.length() < 1) {
            return false;
        }
        if (labelList == null) {
            return false;
        }
        if (labelList.length < 1) {
            return false;
        }
        for (int i = 0; i < labelList.length; ++i) {
            if (!label.equals(labelList[i])) continue;
            return true;
        }
        return false;
    }

    public static String[] getNonEmptyLabels(String[] labelList) {
        int i;
        if (labelList == null) {
            return null;
        }
        if (labelList.length < 1) {
            return null;
        }
        String[] copiedList = new String[labelList.length];
        int copyIndex = 0;
        for (i = 0; i < labelList.length; ++i) {
            if (labelList[i] == null || labelList[i].length() <= 0) continue;
            copiedList[copyIndex] = labelList[i];
            ++copyIndex;
        }
        if (copyIndex == 0) {
            return null;
        }
        if (copyIndex == labelList.length) {
            return copiedList;
        }
        String[] nonEmptyList = new String[copyIndex];
        for (i = 0; i < nonEmptyList.length; ++i) {
            nonEmptyList[i] = copiedList[i];
        }
        return nonEmptyList;
    }

    @Override
    public String getType() {
        return "EnumScalar";
    }

    public void setEnumHelper(EnumScalarHelper helper) {
        this.enumHelper = helper;
    }

    @Override
    public String getEnumScalarValue() {
        return this.scalarValue;
    }

    @Override
    public void setEnumScalarValue(String s) {
        try {
            DeviceAttribute da = new DeviceAttribute(this.getNameSansDevice());
            this.enumHelper.insert(da, s);
            this.writeAtt(da);
        }
        catch (AttributeSetException attEx) {
            this.setAttError("Couldn't set value", attEx);
        }
        catch (DevFailed df) {
            this.setAttError("Couldn't set value", new AttributeSetException(df));
        }
    }

    @Override
    public String getEnumScalarSetPoint() {
        return this.setPointValue;
    }

    @Override
    public short getShortValueFromEnumScalar(String enumStr) {
        short shortValue = -1;
        try {
            shortValue = this.enumHelper.getValueForEnum(enumStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return shortValue;
    }

    @Override
    public String getEnumScalarFromShortValue(short shortValue) {
        String enumStr = null;
        try {
            enumStr = this.enumHelper.getEnumValue(shortValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return enumStr;
    }

    @Override
    public String getEnumScalarSetPointFromDevice() {
        String setPoint;
        try {
            setPoint = this.enumHelper.getEnumScalarSetPoint(this.readDeviceValueFromNetwork());
            this.setPointValue = EnumScalar.containsEnumLabel(this.enumSetLabels, setPoint) ? setPoint : null;
        }
        catch (DevFailed e) {
            this.readAttError(e.getMessage(), new AttributeReadException(e));
            setPoint = null;
            this.setPointValue = null;
        }
        catch (Exception e) {
            this.readAttError(e.getMessage(), e);
            setPoint = null;
            this.setPointValue = null;
        }
        return setPoint;
    }

    @Override
    public int getXDimension() {
        return 1;
    }

    @Override
    public int getMaxXDimension() {
        return 1;
    }

    @Override
    public void addEnumScalarListener(IEnumScalarListener l) {
        this.enumHelper.addEnumScalarListener(l);
        this.addStateListener(l);
    }

    @Override
    public void removeEnumScalarListener(IEnumScalarListener l) {
        this.enumHelper.removeEnumScalarListener(l);
        this.removeStateListener(l);
    }

    @Override
    public void refresh() {
        DeviceAttribute att = null;
        long t0 = System.currentTimeMillis();
        ++this.refreshCount;
        this.trace(4, "EnumScalar.refresh() method called for " + this.getName(), t0);
        try {
            try {
                this.attribute = att = this.readValueFromNetwork();
                if (att == null) {
                    return;
                }
                this.scalarValue = this.enumHelper.getEnumScalarValue(att);
                this.setPointValue = this.enumHelper.getEnumScalarSetPoint(att);
                if (!EnumScalar.containsEnumLabel(this.enumSetLabels, this.setPointValue)) {
                    this.setPointValue = null;
                }
                this.enumHelper.fireEnumScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (AttributeReadException attEx) {
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError("Invalid enum value read.", attEx);
            }
            catch (DevFailed e) {
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError(e.getMessage(), new AttributeReadException(e));
            }
            catch (Error err) {
                this.trace(4, "EnumScalar.refresh(" + this.getName() + ") failed, caught java.lang.Error; will call readAttError", t0);
                this.readAttError(err.getMessage(), new AttributeReadException(err));
            }
        }
        catch (Throwable th) {
            this.scalarValue = null;
            this.setPointValue = null;
            this.trace(4, "EnumScalar.refresh(" + this.getName() + ") Code failure, caught other Throwable", t0);
            System.out.println("EnumScalar.refresh() Throwable caught ------------------------------");
            th.printStackTrace();
            System.out.println("EnumScalar.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute attValue) {
        ++this.refreshCount;
        try {
            try {
                if (attValue == null) {
                    return;
                }
                this.attribute = attValue;
                this.setState(attValue);
                this.timeStamp = attValue.getTimeValMillisSec();
                this.scalarValue = this.enumHelper.getEnumScalarValue(attValue);
                this.setPointValue = this.enumHelper.getEnumScalarSetPoint(attValue);
                if (!EnumScalar.containsEnumLabel(this.enumSetLabels, this.setPointValue)) {
                    this.setPointValue = null;
                }
                this.enumHelper.fireEnumScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (AttributeReadException attEx) {
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError("Invalid enum value read.", attEx);
            }
            catch (DevFailed e) {
                this.dispatchError(e);
            }
        }
        catch (Exception e) {
            this.scalarValue = null;
            this.setPointValue = null;
            System.out.println("EnumScalar.dispatch() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("EnumScalar.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed e) {
        this.scalarValue = null;
        this.setPointValue = null;
        this.readAttError(e.getMessage(), new AttributeReadException(e));
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    @Override
    public String[] getEnumValues() {
        return this.enumLabels;
    }

    @Override
    public String[] getSetEnumValues() {
        return this.enumSetLabels;
    }

    public void periodic(TangoPeriodicEvent evt) {
        ++this.periodicCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(128, "EnumScalar.periodic method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(128, "EnumScalar.periodicEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(128, "EnumScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "EnumScalar.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(128, "EnumScalar.periodicEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(128, "EnumScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            this.scalarValue = null;
            this.setPointValue = null;
            System.out.println("EnumScalar.periodic.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("EnumScalar.periodic.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.scalarValue = this.enumHelper.getEnumScalarValue(da);
                this.setPointValue = this.enumHelper.getEnumScalarSetPoint(da);
                if (!EnumScalar.containsEnumLabel(this.enumSetLabels, this.setPointValue)) {
                    this.setPointValue = null;
                }
                this.enumHelper.fireEnumScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (AttributeReadException attEx) {
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError("Invalid enum value read.", attEx);
            }
            catch (DevFailed dfe) {
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.scalarValue = null;
                this.setPointValue = null;
                System.out.println("EnumScalar.periodic.extractString() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("EnumScalar.periodic.extractString()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent evt) {
        ++this.changeCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(32, "EnumScalar.change method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(32, "EnumScalar.changeEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(32, "EnumScalar.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "EnumScalar.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(32, "EnumScalar.changeEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(32, "EnumScalar.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            this.scalarValue = null;
            this.setPointValue = null;
            System.out.println("EnumScalar.change.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("EnumScalar.change.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.scalarValue = this.enumHelper.getEnumScalarValue(da);
                this.setPointValue = this.enumHelper.getEnumScalarSetPoint(da);
                if (!EnumScalar.containsEnumLabel(this.enumSetLabels, this.setPointValue)) {
                    this.setPointValue = null;
                }
                this.enumHelper.fireEnumScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (AttributeReadException attEx) {
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError("Invalid enum value read.", attEx);
            }
            catch (DevFailed dfe) {
                this.scalarValue = null;
                this.setPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.scalarValue = null;
                this.setPointValue = null;
                System.out.println("EnumScalar.change.extractString() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("EnumScalar.change.extractString()------------------------------------------------");
            }
        }
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        in.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property src = (Property)evt.getSource();
        if (src == null) {
            return;
        }
        if (src.getName().equalsIgnoreCase("enum_label") && src instanceof StringArrayProperty) {
            StringArrayProperty sap = (StringArrayProperty)src;
            String[] newEnums = sap.getStringArrayValue();
            this.updateEnumLabels(newEnums);
        }
    }

    private void updateEnumLabels(String[] enums) {
        if (enums == null) {
            return;
        }
        this.enumLabels = enums;
        this.enumSetLabels = enums;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isSpectrum() {
        return false;
    }

    @Override
    public boolean isImage() {
        return false;
    }
}

