/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IDevStateSpectrum;
import fr.esrf.tangoatk.core.IDevStateSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class DevStateSpectrumHelper
implements Serializable {
    AAttribute attribute;
    EventSupport propChanges;

    public DevStateSpectrumHelper(AAttribute attribute) {
        this.init(attribute);
    }

    void init(AAttribute attribute) {
        this.setAttribute(attribute);
        this.propChanges = attribute.getPropChanges();
    }

    public void setAttribute(AAttribute attribute) {
        this.attribute = attribute;
    }

    public AAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String name, Number value) {
        this.attribute.setProperty(name, value);
        this.attribute.storeConfig();
    }

    protected void setProperty(String name, Number value, boolean writable) {
        this.attribute.setProperty(name, value, writable);
    }

    void fireDevStateSpectrumValueChanged(String[] newValue, long timeStamp) {
        this.propChanges.fireDevStateSpectrumEvent((IDevStateSpectrum)((Object)this.attribute), newValue, timeStamp);
    }

    void insert(String[] stateSpect) {
        DevState[] devStatesArray = new DevState[stateSpect.length];
        DeviceAttribute da = this.attribute.getAttribute();
        for (int i = 0; i < stateSpect.length; ++i) {
            devStatesArray[i] = Device.getStateFromString(stateSpect[i]);
        }
        da.insert(devStatesArray);
    }

    String[] getStateSpectrumValue(DeviceAttribute da) throws DevFailed {
        String[] retval = null;
        DevState[] devStates = null;
        devStates = da.extractDevStateArray();
        int nbReadElements = da.getNbRead();
        retval = new String[nbReadElements];
        for (int i = 0; i < nbReadElements; ++i) {
            retval[i] = Device.toString(devStates[i]);
        }
        return retval;
    }

    String[] getStateSpectrumSetPoint(DeviceAttribute da) throws DevFailed {
        int nbReadElements;
        DevState[] devStates = null;
        String[] retval = null;
        devStates = da.extractDevStateArray();
        int nbSetElements = devStates.length - (nbReadElements = da.getNbRead());
        if (nbSetElements <= 0) {
            return this.getStateSpectrumValue(da);
        }
        retval = new String[nbSetElements];
        int j = 0;
        for (int i = nbReadElements; i < devStates.length; ++i) {
            retval[j] = Device.toString(devStates[i]);
            ++j;
        }
        return retval;
    }

    void addDevStateSpectrumListener(IDevStateSpectrumListener l) {
        this.propChanges.addDevStateSpectrumListener(l);
    }

    void removeDevStateSpectrumListener(IDevStateSpectrumListener l) {
        this.propChanges.removeDevStateSpectrumListener(l);
    }

    public String getVersion() {
        return "$Id$";
    }
}

