/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IDevStateSpectrum;
import fr.esrf.tangoatk.core.IDevStateSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.DevStateSpectrumHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;

public class DevStateSpectrum
extends AAttribute
implements IDevStateSpectrum {
    DevStateSpectrumHelper dsSpectrumHelper = new DevStateSpectrumHelper(this);
    String[] dsSpectrumValue = null;
    String[] dsSpectrumSetPointValue = null;
    String[] stateLabels = null;
    boolean[] invertOpenClose = null;
    boolean[] invertInsertExtract = null;

    @Override
    public int getXDimension() {
        return 1;
    }

    @Override
    public int getMaxXDimension() {
        return 1;
    }

    @Override
    public String[] getValue() {
        return this.dsSpectrumValue;
    }

    @Override
    public String[] getSetPoint() {
        return this.dsSpectrumSetPointValue;
    }

    @Override
    public String[] getDeviceValue() {
        try {
            DeviceAttribute da = this.readValueFromNetwork();
            this.dsSpectrumValue = this.dsSpectrumHelper.getStateSpectrumValue(da);
            this.dsSpectrumSetPointValue = this.dsSpectrumHelper.getStateSpectrumSetPoint(da);
        }
        catch (DevFailed e) {
            this.readAttError(e.getMessage(), new AttributeReadException(e));
        }
        catch (Exception e) {
            System.out.println("DevStateSpectrum.getDeviceValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("DevStateSpectrum.getDeviceValue()------------------------------------------------");
        }
        return this.dsSpectrumValue;
    }

    @Override
    public void refresh() {
        DeviceAttribute att = null;
        long t0 = System.currentTimeMillis();
        ++this.refreshCount;
        this.trace(4, "DevStateSpectrum.refresh() method called for " + this.getName(), t0);
        try {
            try {
                att = this.readValueFromNetwork();
                this.trace(4, "DevStateSpectrum.refresh(" + this.getName() + ") readValueFromNetwork success", t0);
                if (att == null) {
                    return;
                }
                this.dsSpectrumValue = this.dsSpectrumHelper.getStateSpectrumValue(att);
                this.dsSpectrumSetPointValue = this.dsSpectrumHelper.getStateSpectrumSetPoint(att);
                this.trace(4, "DevStateSpectrum.refresh(" + this.getName() + ") fireValueChanged(dsSpectrumValue) success", t0);
                this.fireValueChanged(this.dsSpectrumValue);
            }
            catch (DevFailed e) {
                this.trace(4, "DevStateSpectrum.refresh(" + this.getName() + ") failed, caught DevFailed; will call readAttError", t0);
                this.readAttError(e.getMessage(), new AttributeReadException(e));
            }
            catch (Error err) {
                this.trace(4, "DevStateSpectrum.refresh(" + this.getName() + ") failed, caught java.lang.Error; will call readAttError", t0);
                this.readAttError(err.getMessage(), new AttributeReadException(err));
            }
        }
        catch (Throwable th) {
            this.trace(4, "DevStateSpectrum.refresh(" + this.getName() + ") Code failure, caught other Throwable", t0);
            System.out.println("DevStateSpectrum.refresh() Throwable caught ------------------------------");
            th.printStackTrace();
            System.out.println("DevStateSpectrum.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute attValue) {
        ++this.refreshCount;
        try {
            try {
                if (attValue == null) {
                    return;
                }
                this.attribute = attValue;
                this.setState(attValue);
                this.timeStamp = attValue.getTimeValMillisSec();
                this.dsSpectrumValue = this.dsSpectrumHelper.getStateSpectrumValue(attValue);
                this.dsSpectrumSetPointValue = this.dsSpectrumHelper.getStateSpectrumSetPoint(attValue);
                this.fireValueChanged(this.dsSpectrumValue);
            }
            catch (DevFailed e) {
                this.dispatchError(e);
            }
        }
        catch (Exception e) {
            System.out.println("DevStateSpectrum.dispatch() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("DevStateSpectrum.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed e) {
        this.readAttError(e.getMessage(), new AttributeReadException(e));
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(String[] newValue) {
        this.dsSpectrumHelper.fireDevStateSpectrumValueChanged(newValue, this.timeStamp);
    }

    @Override
    public void addDevStateSpectrumListener(IDevStateSpectrumListener l) {
        this.dsSpectrumHelper.addDevStateSpectrumListener(l);
        this.addStateListener(l);
    }

    @Override
    public void removeDevStateSpectrumListener(IDevStateSpectrumListener l) {
        this.dsSpectrumHelper.removeDevStateSpectrumListener(l);
        this.removeStateListener(l);
    }

    public void periodic(TangoPeriodicEvent evt) {
        ++this.periodicCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(128, "DevStateSpectrum.periodic method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(128, "DevStateSpectrum.periodicEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(128, "DevStateSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "DevStateSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(128, "DevStateSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(128, "DevStateSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            System.out.println("DevStateSpectrum.periodic.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("DevStateSpectrum.periodic.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.trace(128, "DevStateSpectrum.periodic(" + this.getName() + ") setState(da) called", t0);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.dsSpectrumValue = this.dsSpectrumHelper.getStateSpectrumValue(da);
                this.dsSpectrumSetPointValue = this.dsSpectrumHelper.getStateSpectrumSetPoint(da);
                this.fireValueChanged(this.dsSpectrumValue);
                this.trace(128, "DevStateSpectrum.periodic(" + this.getName() + ") fireValueChanged(devStateValue) called", t0);
            }
            catch (DevFailed dfe) {
                this.trace(128, "DevStateSpectrum.periodic(" + this.getName() + ") failed, got DevFailed when called fireValueChanged(devStateValue)", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.trace(128, "DevStateSpectrum.periodic(" + this.getName() + ") failed, got other Exception when called fireValueChanged(devStateValue)", t0);
                System.out.println("DevStateSpectrum.periodic: Device.toString(extractState()) Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("DevStateSpectrum.periodic: Device.toString(extractState())------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent evt) {
        ++this.changeCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(32, "DevStateSpectrum.change method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(32, "DevStateSpectrum.changeEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(32, "DevStateSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "DevStateSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(32, "DevStateSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(32, "DevStateSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            System.out.println("DevStateSpectrum.change.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("DevStateSpectrum.change.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.trace(32, "DevStateSpectrum.change(" + this.getName() + ") setState(da) called", t0);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.dsSpectrumValue = this.dsSpectrumHelper.getStateSpectrumValue(da);
                this.dsSpectrumSetPointValue = this.dsSpectrumHelper.getStateSpectrumSetPoint(da);
                this.fireValueChanged(this.dsSpectrumValue);
                this.trace(32, "DevStateSpectrum.change(" + this.getName() + ") fireValueChanged(devStateValue) called", t0);
            }
            catch (DevFailed dfe) {
                this.trace(32, "DevStateSpectrum.change(" + this.getName() + ") failed, got DevFailed when called fireValueChanged(devStateValue)", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.trace(32, "DevStateSpectrum.change(" + this.getName() + ") failed, got other Exception when called fireValueChanged(devStateValue)", t0);
                System.out.println("DevStateSpectrum.change: Device.toString(extractState()) Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("DevStateSpectrum.change: Device.toString(extractState())------------------------------------------------");
            }
        }
    }

    @Override
    public void setValue(String[] states) throws AttributeSetException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] getStateLabels() {
        return this.stateLabels;
    }

    @Override
    public boolean getInvertedOpenCloseForElement(int elemIndex) {
        if (this.invertOpenClose == null) {
            return false;
        }
        if (elemIndex < 0 || elemIndex >= this.invertOpenClose.length) {
            return false;
        }
        return this.invertOpenClose[elemIndex];
    }

    @Override
    public boolean getInvertedInsertExtractForElement(int elemIndex) {
        if (this.invertInsertExtract == null) {
            return false;
        }
        if (elemIndex < 0 || elemIndex >= this.invertInsertExtract.length) {
            return false;
        }
        return this.invertInsertExtract[elemIndex];
    }

    void setInvertedOpenClose(String[] openCloseLogic) {
        HashMap<Integer, Boolean> ocmap = new HashMap<Integer, Boolean>();
        for (int ind = 0; ind < openCloseLogic.length; ++ind) {
            String elemLogic = openCloseLogic[ind];
            this.parseElemLogic(elemLogic, ocmap);
        }
        Set indexSet = ocmap.keySet();
        if (indexSet == null) {
            return;
        }
        if (indexSet.isEmpty()) {
            return;
        }
        TreeSet indexSortedSet = new TreeSet(indexSet);
        Integer lastElemIndex = (Integer)indexSortedSet.last();
        int arrayLength = lastElemIndex + 1;
        this.invertOpenClose = new boolean[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            this.invertOpenClose[i] = false;
        }
        for (Integer key : indexSet) {
            int indexElem = key;
            if (indexElem <= 0 || indexElem >= this.invertOpenClose.length) continue;
            this.invertOpenClose[indexElem] = ocmap.get(key);
        }
    }

    void setInvertedInsertExtract(String[] insertExtractLogic) {
        HashMap<Integer, Boolean> iemap = new HashMap<Integer, Boolean>();
        for (int ind = 0; ind < insertExtractLogic.length; ++ind) {
            String elemLogic = insertExtractLogic[ind];
            this.parseElemLogic(elemLogic, iemap);
        }
        Set indexSet = iemap.keySet();
        if (indexSet == null) {
            return;
        }
        if (indexSet.isEmpty()) {
            return;
        }
        TreeSet indexSortedSet = new TreeSet(indexSet);
        Integer lastElemIndex = (Integer)indexSortedSet.last();
        int arrayLength = lastElemIndex + 1;
        this.invertInsertExtract = new boolean[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            this.invertInsertExtract[i] = false;
        }
        for (Integer key : indexSet) {
            int indexElem = key;
            if (indexElem <= 0 || indexElem >= this.invertInsertExtract.length) continue;
            this.invertInsertExtract[indexElem] = iemap.get(key);
        }
    }

    private void parseElemLogic(String str, HashMap<Integer, Boolean> elemMap) {
        int colon = -1;
        String indexStr = null;
        String boolStr = null;
        Integer index = null;
        Boolean elemLogic = null;
        if (str == null) {
            return;
        }
        if (str.length() < 3) {
            return;
        }
        colon = str.indexOf(":");
        if (colon < 1) {
            return;
        }
        if (colon >= str.length() - 1) {
            return;
        }
        try {
            indexStr = str.substring(0, colon);
            boolStr = str.substring(colon + 1);
        }
        catch (IndexOutOfBoundsException iob) {
            return;
        }
        try {
            index = Integer.valueOf(indexStr.trim());
        }
        catch (NumberFormatException nfe) {
            return;
        }
        elemLogic = Boolean.valueOf(boolStr.trim());
        if (elemMap.containsKey(index)) {
            elemMap.remove(index);
        }
        elemMap.put(index, elemLogic);
    }

    @Override
    public void loadAttProperties() {
        DbAttribute dbAtt = null;
        DbDatum propDbDatum = null;
        String[] invertedOpenCloseLogic = null;
        String[] invertedInsertExtractLogic = null;
        String[] stateLbls = null;
        try {
            this.attPropertiesLoaded = true;
            dbAtt = this.getDevice().get_attribute_property(this.getNameSansDevice());
            if (dbAtt == null) {
                return;
            }
            if (!dbAtt.is_empty("StateLabels")) {
                propDbDatum = dbAtt.datum("StateLabels");
                if (propDbDatum != null && !propDbDatum.is_empty()) {
                    stateLbls = propDbDatum.extractStringArray();
                }
                if (stateLbls != null && stateLbls.length > 0) {
                    this.stateLabels = stateLbls;
                }
            }
            if (!dbAtt.is_empty("OpenCloseInverted")) {
                propDbDatum = dbAtt.datum("OpenCloseInverted");
                if (propDbDatum != null && !propDbDatum.is_empty()) {
                    invertedOpenCloseLogic = propDbDatum.extractStringArray();
                }
                if (invertedOpenCloseLogic != null && invertedOpenCloseLogic.length > 0) {
                    this.setInvertedOpenClose(invertedOpenCloseLogic);
                }
            }
            if (!dbAtt.is_empty("InsertExtractInverted")) {
                propDbDatum = dbAtt.datum("InsertExtractInverted");
                if (propDbDatum != null && !propDbDatum.is_empty()) {
                    invertedInsertExtractLogic = propDbDatum.extractStringArray();
                }
                if (invertedInsertExtractLogic != null && invertedInsertExtractLogic.length > 0) {
                    this.setInvertedInsertExtract(invertedInsertExtractLogic);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("get_attribute_property(" + this.getName() + ") thrown exception");
            ex.printStackTrace();
        }
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        in.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isSpectrum() {
        return true;
    }

    @Override
    public boolean isImage() {
        return false;
    }
}

