/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class DevStateScalarHelper
implements Serializable {
    AAttribute attribute;
    EventSupport propChanges;

    public DevStateScalarHelper(AAttribute att) {
        this.init(att);
    }

    void init(AAttribute att) {
        this.setAttribute(att);
        this.propChanges = att.getPropChanges();
    }

    public void setAttribute(AAttribute att) {
        this.attribute = att;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String name, Number value) {
        this.attribute.setProperty(name, value);
        this.attribute.storeConfig();
    }

    protected void setProperty(String name, Number value, boolean writable) {
        this.attribute.setProperty(name, value, writable);
    }

    void fireValueChanged(String newValue, long timeStamp) {
        this.propChanges.fireDevStateScalarEvent((IDevStateScalar)((Object)this.attribute), newValue, timeStamp);
    }

    void addDevStateScalarListener(IDevStateScalarListener l) {
        this.propChanges.addDevStateScalarListener(l);
    }

    void removeDevStateScalarListener(IDevStateScalarListener l) {
        this.propChanges.removeDevStateScalarListener(l);
    }

    public String getDevStateScalarSetPoint(DeviceAttribute devAtt) throws DevFailed {
        DevState[] ds_arr = null;
        String stateSetPoint = null;
        ds_arr = devAtt.extractDevStateArray();
        if (ds_arr == null) {
            return null;
        }
        if (ds_arr.length < 2) {
            return null;
        }
        stateSetPoint = Device.toString(ds_arr[1]);
        return stateSetPoint;
    }

    public String getVersion() {
        return "$Id$";
    }
}

