/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.DevStateScalarHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class DevStateScalar
extends AAttribute
implements IDevStateScalar {
    DevStateScalarHelper devStateHelper = new DevStateScalarHelper(this);
    String devStateValue = null;
    String setPointValue = null;
    DevState devStateValueRaw = null;
    boolean invertOpenClose = false;
    boolean invertInsertExtract = false;

    @Override
    public int getXDimension() {
        return 1;
    }

    @Override
    public int getMaxXDimension() {
        return 1;
    }

    @Override
    public String getValue() {
        return this.devStateValue;
    }

    @Override
    public DevState getDevState() {
        return this.devStateValueRaw;
    }

    @Override
    public String getDeviceValue() {
        try {
            String readVal;
            this.devStateValueRaw = this.readValueFromNetwork().extractState();
            this.devStateValue = readVal = Device.toString(this.devStateValueRaw);
        }
        catch (DevFailed e) {
            this.readAttError(e.getMessage(), new AttributeReadException(e));
        }
        catch (Exception e) {
            System.out.println("DevStateScalar.getDeviceValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("DevStateScalar.getDeviceValue()------------------------------------------------");
        }
        return this.devStateValue;
    }

    @Override
    public void setValue(String stateValue) {
        try {
            DeviceAttribute da = new DeviceAttribute(this.getNameSansDevice());
            da.insert(Device.getStateFromString(stateValue));
            this.writeAtt(da);
        }
        catch (DevFailed df) {
            this.setAttError("Couldn't set value", new AttributeSetException(df));
        }
        catch (Exception e) {
            System.out.println("Received un exception other than DevFailed while setting a devStateScalar");
            this.setAttError("Couldn't set value", new AttributeSetException("Set Exception other than DevFailed."));
        }
    }

    @Override
    public String getSetPoint() {
        return this.setPointValue;
    }

    @Override
    public String getDeviceSetPoint() {
        String setPoint = null;
        try {
            this.setPointValue = setPoint = this.devStateHelper.getDevStateScalarSetPoint(this.readDeviceValueFromNetwork());
        }
        catch (DevFailed e) {
            this.readAttError(e.getMessage(), new AttributeReadException(e));
        }
        catch (Exception e) {
            this.readAttError(e.getMessage(), e);
        }
        return setPoint;
    }

    private boolean isConnected() {
        return this.getDevice().isConnected();
    }

    @Override
    public void refresh() {
        DeviceAttribute att = null;
        long t0 = System.currentTimeMillis();
        if (!this.isConnected()) {
            this.reconnectAtt();
        }
        if (!this.isConnected()) {
            this.trace(4, "DevStateScalar.refresh(" + this.getName() + ") failed, device not connected; will call readAttError", t0);
            this.readAttError("Failed to read the state attribute. Connection to device failed.", new AttributeReadException("Failed to read the state attribute. Connection to device failed."));
            return;
        }
        ++this.refreshCount;
        this.trace(4, "DevStateScalar.refresh() method called for " + this.getName(), t0);
        try {
            try {
                att = this.readValueFromNetwork();
                this.trace(4, "DevStateScalar.refresh(" + this.getName() + ") readValueFromNetwork success", t0);
                if (att == null) {
                    return;
                }
                this.devStateValueRaw = att.extractState();
                this.devStateValue = Device.toString(this.devStateValueRaw);
                this.setPointValue = this.devStateHelper.getDevStateScalarSetPoint(att);
                this.trace(4, "DevStateScalar.refresh(" + this.getName() + ") fireValueChanged(devStateValue) success", t0);
                this.fireValueChanged(this.devStateValue);
            }
            catch (DevFailed e) {
                this.trace(4, "DevStateScalar.refresh(" + this.getName() + ") failed, caught DevFailed; will call readAttError", t0);
                this.readAttError(e.getMessage(), new AttributeReadException(e));
            }
            catch (Error err) {
                this.trace(4, "DevStateScalar.refresh(" + this.getName() + ") failed, caught java.lang.Error; will call readAttError", t0);
                this.readAttError(err.getMessage(), new AttributeReadException(err));
            }
        }
        catch (Throwable th) {
            this.trace(4, "DevStateScalar.refresh(" + this.getName() + ") Code failure, caught other Throwable", t0);
            System.out.println("DevStateScalar.refresh() Throwable caught ------------------------------");
            th.printStackTrace();
            System.out.println("DevStateScalar.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute attValue) {
        ++this.refreshCount;
        try {
            try {
                if (attValue == null) {
                    return;
                }
                this.attribute = attValue;
                this.setState(attValue);
                this.timeStamp = attValue.getTimeValMillisSec();
                this.devStateValueRaw = attValue.extractState();
                this.devStateValue = Device.toString(this.devStateValueRaw);
                this.setPointValue = this.devStateHelper.getDevStateScalarSetPoint(attValue);
                this.fireValueChanged(this.devStateValue);
            }
            catch (DevFailed e) {
                this.dispatchError(e);
            }
        }
        catch (Exception e) {
            System.out.println("DevStateScalar.dispatch() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("DevStateScalar.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed e) {
        this.readAttError(e.getMessage(), new AttributeReadException(e));
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(String newValue) {
        this.devStateHelper.fireValueChanged(newValue, this.timeStamp);
    }

    @Override
    public void addDevStateScalarListener(IDevStateScalarListener l) {
        this.devStateHelper.addDevStateScalarListener(l);
        this.addStateListener(l);
    }

    @Override
    public void removeDevStateScalarListener(IDevStateScalarListener l) {
        this.devStateHelper.removeDevStateScalarListener(l);
        this.removeStateListener(l);
    }

    public String getDevStateValue() {
        return this.devStateValue;
    }

    public void periodic(TangoPeriodicEvent evt) {
        ++this.periodicCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(128, "DevStateScalar.periodic method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(128, "DevStateScalar.periodicEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(128, "DevStateScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "DevStateScalar.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(128, "DevStateScalar.periodicEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(128, "DevStateScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            System.out.println("DevStateScalar.periodic.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("DevStateScalar.periodic.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.trace(128, "DevStateScalar.periodic(" + this.getName() + ") setState(da) called", t0);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.devStateValueRaw = da.extractState();
                this.devStateValue = Device.toString(this.devStateValueRaw);
                this.setPointValue = this.devStateHelper.getDevStateScalarSetPoint(da);
                this.fireValueChanged(this.devStateValue);
                this.trace(128, "DevStateScalar.periodic(" + this.getName() + ") fireValueChanged(devStateValue) called", t0);
            }
            catch (DevFailed dfe) {
                this.trace(128, "DevStateScalar.periodic(" + this.getName() + ") failed, got DevFailed when called fireValueChanged(devStateValue)", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.trace(128, "DevStateScalar.periodic(" + this.getName() + ") failed, got other Exception when called fireValueChanged(devStateValue)", t0);
                System.out.println("DevStateScalar.periodic: Device.toString(extractState()) Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("DevStateScalar.periodic: Device.toString(extractState())------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent evt) {
        ++this.changeCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(32, "DevStateScalar.change method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(32, "DevStateScalar.changeEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(32, "DevStateScalar.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "DevStateScalar.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(32, "DevStateScalar.changeEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(32, "DevStateScalar.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            System.out.println("DevStateScalar.change.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("DevStateScalar.change.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.trace(32, "DevStateScalar.change(" + this.getName() + ") setState(da) called", t0);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.devStateValueRaw = da.extractState();
                this.devStateValue = Device.toString(this.devStateValueRaw);
                this.setPointValue = this.devStateHelper.getDevStateScalarSetPoint(da);
                this.fireValueChanged(this.devStateValue);
                this.trace(32, "DevStateScalar.change(" + this.getName() + ") fireValueChanged(devStateValue) called", t0);
            }
            catch (DevFailed dfe) {
                this.trace(32, "DevStateScalar.change(" + this.getName() + ") failed, got DevFailed when called da.extractState()", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.trace(32, "DevStateScalar.change(" + this.getName() + ") failed, got other Exception when called fireValueChanged(devStateValue)", t0);
                System.out.println("DevStateScalar.change: Device.toString(extractState()) Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("DevStateScalar.change: Device.toString(extractState())------------------------------------------------");
            }
        }
    }

    @Override
    public boolean getInvertedOpenClose() {
        return this.invertOpenClose;
    }

    @Override
    public boolean getInvertedInsertExtract() {
        return this.invertInsertExtract;
    }

    @Override
    public void loadAttProperties() {
        DbAttribute dbAtt = null;
        DbDatum propDbDatum = null;
        try {
            this.attPropertiesLoaded = true;
            dbAtt = this.getDevice().get_attribute_property(this.getNameSansDevice());
            if (dbAtt == null) {
                return;
            }
            if (!dbAtt.is_empty("OpenCloseInverted") && (propDbDatum = dbAtt.datum("OpenCloseInverted")) != null && !propDbDatum.is_empty()) {
                this.invertOpenClose = propDbDatum.extractBoolean();
            }
            if (!dbAtt.is_empty("InsertExtractInverted") && (propDbDatum = dbAtt.datum("InsertExtractInverted")) != null && !propDbDatum.is_empty()) {
                this.invertInsertExtract = propDbDatum.extractBoolean();
            }
        }
        catch (Exception ex) {
            System.out.println("get_attribute_property(" + this.getName() + ") thrown exception");
            ex.printStackTrace();
        }
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        in.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isSpectrum() {
        return false;
    }

    @Override
    public boolean isImage() {
        return false;
    }
}

