/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanSpectrum;
import fr.esrf.tangoatk.core.IBooleanSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

public class BooleanSpectrumHelper
implements Serializable {
    AAttribute attribute;
    EventSupport propChanges;

    public BooleanSpectrumHelper(AAttribute attribute) {
        this.init(attribute);
    }

    void init(AAttribute attribute) {
        this.setAttribute(attribute);
        this.propChanges = attribute.getPropChanges();
    }

    public void setAttribute(AAttribute attribute) {
        this.attribute = attribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String name, Number value) {
        this.attribute.setProperty(name, value);
        this.attribute.storeConfig();
    }

    protected void setProperty(String name, Number value, boolean writable) {
        this.attribute.setProperty(name, value, writable);
    }

    boolean[] getBooleanSpectrumValue(DeviceAttribute da) throws DevFailed {
        boolean[] tmp = da.extractBooleanArray();
        int nbReadElements = da.getNbRead();
        if (nbReadElements == tmp.length) {
            return tmp;
        }
        boolean[] retval = new boolean[nbReadElements];
        for (int i = 0; i < nbReadElements; ++i) {
            retval[i] = tmp[i];
        }
        return retval;
    }

    boolean[] getBooleanSpectrumSetPoint(DeviceAttribute da) throws DevFailed {
        int nbReadElements;
        boolean[] tmp = da.extractBooleanArray();
        int nbSetElements = tmp.length - (nbReadElements = da.getNbRead());
        if (nbSetElements <= 0) {
            return this.getBooleanSpectrumValue(da);
        }
        boolean[] retval = new boolean[nbSetElements];
        int j = 0;
        for (int i = nbReadElements; i < tmp.length; ++i) {
            retval[j] = tmp[i];
            ++j;
        }
        return retval;
    }

    void fireSpectrumValueChanged(boolean[] newValue, long timeStamp) {
        this.propChanges.fireBooleanSpectrumEvent((IBooleanSpectrum)((Object)this.attribute), newValue, timeStamp);
    }

    void insert(boolean[] boolSpect) {
        this.attribute.getAttribute().insert(boolSpect, this.attribute.getXDimension(), this.attribute.getYDimension());
    }

    void addBooleanSpectrumListener(IBooleanSpectrumListener l) {
        this.propChanges.addBooleanSpectrumListener(l);
    }

    void removeBooleanSpectrumListener(IBooleanSpectrumListener l) {
        this.propChanges.removeBooleanSpectrumListener(l);
    }

    public String getVersion() {
        return "$Id$";
    }
}

