/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IBooleanSpectrum;
import fr.esrf.tangoatk.core.IBooleanSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.BooleanSpectrumHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BooleanSpectrum
extends AAttribute
implements IBooleanSpectrum {
    BooleanSpectrumHelper spectrumHelper = new BooleanSpectrumHelper(this);
    boolean[] spectrumValue = null;
    boolean[] spectrumSetPointValue = null;
    String[] booleanLabels = null;

    @Override
    public boolean[] getValue() {
        return this.spectrumValue;
    }

    @Override
    public boolean[] getSetPoint() {
        return this.spectrumSetPointValue;
    }

    @Override
    public boolean[] getDeviceValue() {
        try {
            try {
                DeviceAttribute att = this.readValueFromNetwork();
                if (att == null) {
                    return null;
                }
                this.spectrumValue = this.spectrumHelper.getBooleanSpectrumValue(att);
                this.spectrumSetPointValue = this.spectrumHelper.getBooleanSpectrumSetPoint(att);
            }
            catch (DevFailed e) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(e.getMessage(), new AttributeReadException(e));
            }
        }
        catch (Exception e) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("BooleanSpectrum.refregetDeviceValuesh() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("BooleanSpectrum.getDeviceValue()------------------------------------------------");
        }
        return this.spectrumValue;
    }

    @Override
    public void setValue(boolean[] bArray) {
        try {
            DeviceAttribute da = new DeviceAttribute(this.getNameSansDevice());
            da.insert(bArray);
            this.writeAtt(da);
            this.refresh();
        }
        catch (DevFailed df) {
            this.setAttError("Couldn't set value", new AttributeSetException(df));
        }
    }

    @Override
    public void refresh() {
        DeviceAttribute att = null;
        ++this.refreshCount;
        try {
            try {
                att = this.readValueFromNetwork();
                if (att == null) {
                    return;
                }
                this.spectrumValue = this.spectrumHelper.getBooleanSpectrumValue(att);
                this.spectrumSetPointValue = this.spectrumHelper.getBooleanSpectrumSetPoint(att);
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed e) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(e.getMessage(), new AttributeReadException(e));
            }
            catch (Error err) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(err.getMessage(), new AttributeReadException(err));
            }
        }
        catch (Throwable th) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("BooleanImage.refresh() Throwable caught ------------------------------");
            th.printStackTrace();
            System.out.println("BooleanImage.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute attValue) {
        ++this.refreshCount;
        try {
            try {
                if (attValue == null) {
                    return;
                }
                this.attribute = attValue;
                this.setState(attValue);
                this.timeStamp = attValue.getTimeValMillisSec();
                this.spectrumValue = this.spectrumHelper.getBooleanSpectrumValue(attValue);
                this.spectrumSetPointValue = this.spectrumHelper.getBooleanSpectrumSetPoint(attValue);
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed e) {
                this.dispatchError(e);
            }
        }
        catch (Exception e) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("BooleanSpectrum.dispatch() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("BooleanSpectrum.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed e) {
        this.spectrumValue = null;
        this.spectrumSetPointValue = null;
        this.readAttError(e.getMessage(), new AttributeReadException(e));
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(boolean[] newValue) {
        this.spectrumHelper.fireSpectrumValueChanged(newValue, this.timeStamp);
    }

    @Override
    public void addBooleanSpectrumListener(IBooleanSpectrumListener l) {
        this.spectrumHelper.addBooleanSpectrumListener(l);
        this.addStateListener(l);
    }

    @Override
    public void removeBooleanSpectrumListener(IBooleanSpectrumListener l) {
        this.spectrumHelper.removeBooleanSpectrumListener(l);
        this.removeStateListener(l);
    }

    public void periodic(TangoPeriodicEvent evt) {
        ++this.periodicCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(128, "BooleanSpectrum.periodic method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(128, "BooleanSpectrum.periodicEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(128, "BooleanSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "BooleanSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(128, "BooleanSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            this.trace(128, "BooleanSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            System.out.println("BooleanSpectrum.periodic.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("BooleanSpectrum.periodic.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.spectrumValue = this.spectrumHelper.getBooleanSpectrumValue(da);
                this.spectrumSetPointValue = this.spectrumHelper.getBooleanSpectrumSetPoint(da);
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed dfe) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                System.out.println("BooleanSpectrum.periodic.extractBooleanArray() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("BooleanSpectrum.periodic.extractBooleanArray()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent evt) {
        ++this.changeCount;
        DeviceAttribute da = null;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        long t0 = System.currentTimeMillis();
        this.trace(32, "BooleanSpectrum.change method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(32, "BooleanSpectrum.changeEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(32, "BooleanSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "BooleanSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(32, "BooleanSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            this.trace(32, "BooleanSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            System.out.println("BooleanSpectrum.change.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("BooleanSpectrum.change.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.spectrumValue = this.spectrumHelper.getBooleanSpectrumValue(da);
                this.spectrumSetPointValue = this.spectrumHelper.getBooleanSpectrumSetPoint(da);
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed dfe) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                System.out.println("BooleanSpectrum.change.extractBooleanArray() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("BooleanSpectrum.change.extractBooleanArray()------------------------------------------------");
            }
        }
    }

    @Override
    public String[] getBooleanLabels() {
        return this.booleanLabels;
    }

    @Override
    public void loadAttProperties() {
        DbAttribute dbAtt = null;
        DbDatum propDbDatum = null;
        String[] booleanLbls = null;
        try {
            this.attPropertiesLoaded = true;
            dbAtt = this.getDevice().get_attribute_property(this.getNameSansDevice());
            if (dbAtt == null) {
                return;
            }
            if (!dbAtt.is_empty("BooleanLabels")) {
                propDbDatum = dbAtt.datum("BooleanLabels");
                if (propDbDatum != null && !propDbDatum.is_empty()) {
                    booleanLbls = propDbDatum.extractStringArray();
                }
                if (booleanLbls != null && booleanLbls.length > 0) {
                    this.booleanLabels = booleanLbls;
                }
            }
        }
        catch (Exception ex) {
            System.out.println("get_attribute_property(" + this.getName() + ") thrown exception");
            ex.printStackTrace();
        }
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        in.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isSpectrum() {
        return true;
    }

    @Override
    public boolean isImage() {
        return false;
    }
}

