/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class BooleanScalarHelper
implements Serializable {
    AAttribute attribute;
    EventSupport propChanges;

    public BooleanScalarHelper(AAttribute attribute) {
        this.init(attribute);
    }

    void init(AAttribute attribute) {
        this.setAttribute(attribute);
        this.propChanges = attribute.getPropChanges();
    }

    public void setAttribute(AAttribute attribute) {
        this.attribute = attribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String name, Number value) {
        this.attribute.setProperty(name, value);
        this.attribute.storeConfig();
    }

    protected void setProperty(String name, Number value, boolean writable) {
        this.attribute.setProperty(name, value, writable);
    }

    void fireValueChanged(boolean newValue, long timeStamp) {
        this.propChanges.fireBooleanScalarEvent((IBooleanScalar)((Object)this.attribute), newValue, timeStamp);
    }

    void insert(boolean b) {
        this.attribute.getAttribute().insert(b);
    }

    boolean extract() throws DevFailed {
        return this.attribute.getAttribute().extractBoolean();
    }

    void addBooleanScalarListener(IBooleanScalarListener l) {
        this.propChanges.addBooleanScalarListener(l);
    }

    void removeBooleanScalarListener(IBooleanScalarListener l) {
        this.propChanges.removeBooleanScalarListener(l);
    }

    public boolean getBooleanScalarSetPoint(DeviceAttribute attribute) throws DevFailed {
        boolean[] bool_arr = null;
        bool_arr = attribute.extractBooleanArray();
        if (bool_arr == null) {
            return false;
        }
        if (bool_arr.length < 1) {
            return false;
        }
        if (bool_arr.length > 1) {
            return bool_arr[1];
        }
        return bool_arr[0];
    }

    public String getVersion() {
        return "$Id$";
    }
}

