/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.tangoatk.core.AEntityFactory;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.BooleanImage;
import fr.esrf.tangoatk.core.attribute.BooleanScalar;
import fr.esrf.tangoatk.core.attribute.BooleanSpectrum;
import fr.esrf.tangoatk.core.attribute.DevStateScalar;
import fr.esrf.tangoatk.core.attribute.DevStateSpectrum;
import fr.esrf.tangoatk.core.attribute.DoubleImageHelper;
import fr.esrf.tangoatk.core.attribute.DoubleScalarHelper;
import fr.esrf.tangoatk.core.attribute.DoubleSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.EnumScalar;
import fr.esrf.tangoatk.core.attribute.EnumScalarHelper;
import fr.esrf.tangoatk.core.attribute.EnumSpectrum;
import fr.esrf.tangoatk.core.attribute.EnumSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.FloatImageHelper;
import fr.esrf.tangoatk.core.attribute.FloatScalarHelper;
import fr.esrf.tangoatk.core.attribute.FloatSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.InvalidAttribute;
import fr.esrf.tangoatk.core.attribute.Long64ImageHelper;
import fr.esrf.tangoatk.core.attribute.Long64ScalarHelper;
import fr.esrf.tangoatk.core.attribute.Long64SpectrumHelper;
import fr.esrf.tangoatk.core.attribute.LongImageHelper;
import fr.esrf.tangoatk.core.attribute.LongScalarHelper;
import fr.esrf.tangoatk.core.attribute.LongSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.NumberImage;
import fr.esrf.tangoatk.core.attribute.NumberScalar;
import fr.esrf.tangoatk.core.attribute.NumberSpectrum;
import fr.esrf.tangoatk.core.attribute.RawImage;
import fr.esrf.tangoatk.core.attribute.ShortImageHelper;
import fr.esrf.tangoatk.core.attribute.ShortScalarHelper;
import fr.esrf.tangoatk.core.attribute.ShortSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.StringImage;
import fr.esrf.tangoatk.core.attribute.StringScalar;
import fr.esrf.tangoatk.core.attribute.StringSpectrum;
import fr.esrf.tangoatk.core.attribute.UCharImageHelper;
import fr.esrf.tangoatk.core.attribute.UCharScalarHelper;
import fr.esrf.tangoatk.core.attribute.UCharSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.ULong64ImageHelper;
import fr.esrf.tangoatk.core.attribute.ULong64ScalarHelper;
import fr.esrf.tangoatk.core.attribute.ULong64SpectrumHelper;
import fr.esrf.tangoatk.core.attribute.ULongImageHelper;
import fr.esrf.tangoatk.core.attribute.ULongScalarHelper;
import fr.esrf.tangoatk.core.attribute.ULongSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.UShortImageHelper;
import fr.esrf.tangoatk.core.attribute.UShortScalarHelper;
import fr.esrf.tangoatk.core.attribute.UShortSpectrumHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class AttributeFactory
extends AEntityFactory {
    private static AttributeFactory instance;
    protected Vector<AAttribute> attributes = new Vector();
    protected String[] attNames = new String[0];

    protected AttributeFactory() {
    }

    public static AttributeFactory getInstance() {
        if (instance == null) {
            instance = new AttributeFactory();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AAttribute[] getAttributes() {
        AAttribute[] ret = new AAttribute[this.attributes.size()];
        AttributeFactory attributeFactory = this;
        synchronized (attributeFactory) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                ret[i] = this.attributes.get(i);
            }
        }
        return ret;
    }

    @Override
    public int getSize() {
        return this.attributes.size();
    }

    private int getAttributePos(String fqname) {
        return Arrays.binarySearch(this.attNames, fqname.toLowerCase());
    }

    @Override
    protected synchronized List<IEntity> getWildCardEntities(String name, Device device) throws DevFailed {
        Vector<IEntity> list = new Vector<IEntity>();
        AttributeInfoEx[] config = device.getAttributeInfo((String[])null);
        for (int i = 0; i < config.length; ++i) {
            String fqname = AttributeFactory.getFQName(device, config[i].name);
            int pos = this.getAttributePos(fqname);
            AAttribute attribute = pos >= 0 ? this.attributes.get(pos) : this.initAttribute(device, config[i], -(pos + 1), fqname);
            list.add(attribute);
        }
        return list;
    }

    Device getConnectionlessDevice(String deviceName) throws ConnectionException {
        return DeviceFactory.getInstance().getConnectionlessDevice(deviceName);
    }

    @Override
    protected synchronized List<IEntity> getConnectionlessSingleAttribute(String name) throws ConnectionException {
        Vector<IEntity> list = new Vector<IEntity>();
        Device d = this.getConnectionlessDevice(AttributeFactory.extractDeviceName(name));
        list.add(this.getConnectionlessStateAttribute(name, d));
        return list;
    }

    protected synchronized IEntity getConnectionlessStateAttribute(String fqname, Device device) throws ConnectionException {
        int pos = this.getAttributePos(fqname);
        if (pos >= 0) {
            return this.attributes.get(pos);
        }
        String name = AttributeFactory.extractEntityName(fqname);
        return this.initConnectionlessStateAttribute(device, -(pos + 1), fqname);
    }

    @Override
    protected synchronized IEntity getSingleEntity(String fqname, Device device) throws DevFailed {
        int pos = this.getAttributePos(fqname);
        if (pos >= 0) {
            return this.attributes.get(pos);
        }
        String name = AttributeFactory.extractEntityName(fqname);
        AttributeInfoEx config = device.getAttributeInfo(name);
        return this.initAttribute(device, config, -(pos + 1), fqname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAttribute getAttribute(String fqname) throws ConnectionException, DevFailed {
        Device d = null;
        IEntity ie = null;
        AAttribute att = null;
        AttributeFactory attributeFactory = this;
        synchronized (attributeFactory) {
            int pos = this.getAttributePos(fqname);
            if (pos >= 0) {
                ie = this.attributes.get(pos);
            }
        }
        if (ie == null) {
            d = this.getDevice(AttributeFactory.extractDeviceName(fqname));
            ie = this.getSingleEntity(fqname, d);
        }
        if (ie == null) {
            return null;
        }
        if (ie instanceof AAttribute) {
            att = (AAttribute)ie;
            return att;
        }
        return null;
    }

    public boolean isAttribute(String fqname) {
        try {
            return this.getAttribute(fqname) != null;
        }
        catch (ConnectionException de) {
            return false;
        }
        catch (DevFailed dfe) {
            return false;
        }
        catch (Exception e) {
            System.out.println("AttributeFactory.isAttribute(" + fqname + ") : Unexpected exception caught...");
            e.printStackTrace();
            return false;
        }
    }

    public boolean isConnectionLessAttribute(String fqname) {
        try {
            return this.getConnectionlessSingleAttribute(fqname) != null;
        }
        catch (ConnectionException de) {
            System.out.println("AttributeFactory.isConnectionLessAttribute(" + fqname + ") : " + de.getErrors()[0].desc);
            return false;
        }
        catch (Exception e) {
            System.out.println("AttributeFactory.isConnectionLessAttribute(" + fqname + ") : Unexpected exception caught...");
            e.printStackTrace();
            return false;
        }
    }

    protected AAttribute initAttribute(Device device, AttributeInfoEx config, int insertionPos, String fqname) {
        AAttribute attribute = this.getAttributeOfType(device, config);
        long t0 = System.currentTimeMillis();
        attribute.init(device, config.name, config, true);
        DeviceFactory.getInstance().trace(2, "AttributeFactory.init(" + fqname + ")", t0);
        this.buildNames(fqname, insertionPos);
        this.attributes.add(insertionPos, attribute);
        this.dumpFactory("Adding " + fqname);
        return attribute;
    }

    protected AAttribute initConnectionlessStateAttribute(Device device, int insertionPos, String fqname) throws ConnectionException {
        AAttribute attribute = this.getConnectionlessDevStateScalar(device, fqname);
        long t0 = System.currentTimeMillis();
        attribute.connectionlessInit(device, AttributeFactory.extractEntityName(fqname), true);
        DeviceFactory.getInstance().trace(2, "AttributeFactory.initConnectionlessStateAttribute(" + fqname + ")", t0);
        this.buildNames(fqname, insertionPos);
        this.attributes.add(insertionPos, attribute);
        this.dumpFactory("Adding " + fqname);
        return attribute;
    }

    protected void buildNames(String fqname, int insertionPos) {
        int lgth = this.attNames.length;
        String[] newAttNames = new String[lgth + 1];
        System.arraycopy(this.attNames, 0, newAttNames, 0, insertionPos);
        System.arraycopy(this.attNames, insertionPos, newAttNames, insertionPos + 1, lgth - insertionPos);
        newAttNames[insertionPos] = fqname.toLowerCase();
        this.attNames = newAttNames;
    }

    protected AAttribute getAttributeOfType(Device device, AttributeInfoEx config) {
        if (config == null) {
            System.out.println("Warning, AttributeFactory.getAttributeOfType(): Warning, null AttributeInfo pointer got from " + device.getName());
            return new InvalidAttribute();
        }
        AttrDataFormat format = config.data_format;
        String name = config.name;
        switch (format.value()) {
            case 0: {
                return this.getScalar(device, config);
            }
            case 1: {
                return this.getSpectrum(device, config);
            }
            case 2: {
                return this.getImage(device, config);
            }
        }
        System.out.println("Warning, AttributeFactory.getAttributeOfType(" + device.getName() + "/" + name + ") : Unsupported attribute format [" + format.value() + "]");
        return new InvalidAttribute();
    }

    protected AAttribute getConnectionlessDevStateScalar(Device device, String fqname) throws ConnectionException {
        String attName = AttributeFactory.extractEntityName(fqname);
        if (!attName.equalsIgnoreCase("state")) {
            throw new ConnectionException("Only state attribute can be created without connection to the device.");
        }
        DevStateScalar dss = new DevStateScalar();
        return dss;
    }

    private double getMinimumIncrement(Device device, AttributeInfoEx config) {
        String name = config.name;
        double inc = Double.NaN;
        if (config.writable == AttrWriteType.READ_WRITE) {
            try {
                String[] propVal;
                DbAttribute dbAtt = device.get_attribute_property(name);
                if (dbAtt != null && !dbAtt.is_empty("minimumIncrement") && (propVal = dbAtt.get_value("minimumIncrement")) != null) {
                    try {
                        inc = Double.parseDouble(propVal[0]);
                    }
                    catch (NumberFormatException e1) {
                        System.out.println("Warning, " + device.getName() + "/" + name + "/minimumIncrement, invalid number");
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("get_attribute_property(" + name + ") thrown exception");
                ex.printStackTrace();
            }
        }
        return inc;
    }

    private EnumScalar getEnumScalarFromScalar(Device device, AttributeInfoEx config, DbAttribute dbAtt) {
        String name = config.name;
        String[] propVal = null;
        String[] enumLabs = null;
        String[] enumSetExcludeLabs = null;
        EnumScalar ens = null;
        try {
            if (dbAtt != null && !dbAtt.is_empty("EnumLabels") && (propVal = dbAtt.get_value("EnumLabels")) != null) {
                enumLabs = EnumScalar.getNonEmptyLabels(propVal);
            }
        }
        catch (Exception ex) {
            System.out.println("get_attribute_property(" + name + ") thrown exception");
            ex.printStackTrace();
        }
        if (enumLabs == null) {
            return null;
        }
        if (enumLabs.length <= 1) {
            return null;
        }
        try {
            dbAtt = device.get_attribute_property(name);
            if (dbAtt != null && !dbAtt.is_empty("EnumSetExclusion") && (propVal = dbAtt.get_value("EnumSetExclusion")) != null) {
                enumSetExcludeLabs = EnumScalar.getNonEmptyLabels(propVal);
            }
        }
        catch (Exception ex) {
            System.out.println("get_attribute_property(" + name + ") thrown exception");
            ex.printStackTrace();
        }
        if (enumSetExcludeLabs != null && enumSetExcludeLabs.length < 1) {
            enumSetExcludeLabs = null;
        }
        ens = new EnumScalar(enumLabs, enumSetExcludeLabs);
        return ens;
    }

    private EnumScalar getTangoEnumScalar(AttributeInfoEx config) {
        String[] enumLabs = null;
        EnumScalar ens = null;
        enumLabs = config.enum_label;
        if (enumLabs == null) {
            return null;
        }
        if (enumLabs.length <= 0) {
            return null;
        }
        ens = new EnumScalar(enumLabs);
        return ens;
    }

    private EnumSpectrum getTangoEnumSpectrum(AttributeInfoEx config) {
        String[] enumLabs = null;
        EnumSpectrum ens = null;
        enumLabs = config.enum_label;
        if (enumLabs == null) {
            return null;
        }
        if (enumLabs.length <= 1) {
            return null;
        }
        ens = new EnumSpectrum(enumLabs);
        return ens;
    }

    private AAttribute getScalar(Device device, AttributeInfoEx config) {
        String name = config.name;
        int dataType = config.data_type;
        BooleanScalar bs = null;
        DevStateScalar dss = null;
        EnumScalar ens = null;
        RawImage ri = null;
        if (dataType == 8) {
            return new StringScalar();
        }
        NumberScalar ns = new NumberScalar();
        DbAttribute dbAtt = null;
        try {
            dbAtt = device.get_attribute_property(name);
            if (!dbAtt.is_empty("ConfirmationMessage")) {
                ns.confirmationMessage = dbAtt.get_value("ConfirmationMessage")[0];
            }
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        switch (dataType) {
            case 22: {
                ns.setNumberHelper(new UCharScalarHelper(ns));
                return ns;
            }
            case 2: {
                ens = this.getEnumScalarFromScalar(device, config, dbAtt);
                if (ens != null) {
                    ens.setEnumHelper(new EnumScalarHelper(ens));
                    return ens;
                }
                ns.setNumberHelper(new ShortScalarHelper(ns));
                break;
            }
            case 6: {
                ens = this.getEnumScalarFromScalar(device, config, dbAtt);
                if (ens != null) {
                    ens.setEnumHelper(new EnumScalarHelper(ens));
                    return ens;
                }
                ns.setNumberHelper(new UShortScalarHelper(ns));
                break;
            }
            case 5: {
                ns.setNumberHelper(new DoubleScalarHelper(ns));
                ns.setMinimumIncrement(this.getMinimumIncrement(device, config));
                break;
            }
            case 4: {
                ns.setNumberHelper(new FloatScalarHelper(ns));
                ns.setMinimumIncrement(this.getMinimumIncrement(device, config));
                break;
            }
            case 3: {
                ens = this.getEnumScalarFromScalar(device, config, dbAtt);
                if (ens != null) {
                    ens.setEnumHelper(new EnumScalarHelper(ens));
                    return ens;
                }
                ns.setNumberHelper(new LongScalarHelper(ns));
                break;
            }
            case 7: {
                ens = this.getEnumScalarFromScalar(device, config, dbAtt);
                if (ens != null) {
                    ens.setEnumHelper(new EnumScalarHelper(ens));
                    return ens;
                }
                ns.setNumberHelper(new ULongScalarHelper(ns));
                break;
            }
            case 23: {
                ens = this.getEnumScalarFromScalar(device, config, dbAtt);
                if (ens != null) {
                    ens.setEnumHelper(new EnumScalarHelper(ens));
                    return ens;
                }
                ns.setNumberHelper(new Long64ScalarHelper(ns));
                break;
            }
            case 24: {
                ens = this.getEnumScalarFromScalar(device, config, dbAtt);
                if (ens != null) {
                    ens.setEnumHelper(new EnumScalarHelper(ens));
                    return ens;
                }
                ns.setNumberHelper(new ULong64ScalarHelper(ns));
                break;
            }
            case 1: {
                bs = new BooleanScalar();
                return bs;
            }
            case 19: {
                dss = new DevStateScalar();
                return dss;
            }
            case 28: {
                if (config.format.equalsIgnoreCase("RawImage")) {
                    ri = new RawImage();
                    return ri;
                }
                System.out.println("Warning, AttributeFactory.getScalar(" + device.getName() + "/" + name + ") : Unsupported DevEncoded attribute. Try to set the format attribute property to 'RawImage'.");
                return new InvalidAttribute();
            }
            case 29: {
                ens = this.getTangoEnumScalar(config);
                if (ens == null) {
                    System.out.println("Warning, Tango_DEV_ENUM, AttributeFactory.getTangoEnumScalar(" + device.getName() + "/" + name + ") : Failed ");
                    return new InvalidAttribute();
                }
                ens.setEnumHelper(new EnumScalarHelper(ens));
                return ens;
            }
            default: {
                System.out.println("Warning, AttributeFactory.getScalar(" + device.getName() + "/" + name + ") : Unsupported data type [" + dataType + "]");
                return new InvalidAttribute();
            }
        }
        return ns;
    }

    private AAttribute getSpectrum(Device device, AttributeInfoEx config) {
        String name = config.name;
        int dataType = config.data_type;
        NumberSpectrum ns = new NumberSpectrum();
        StringSpectrum ss = null;
        BooleanSpectrum bs = null;
        DevStateSpectrum dss = null;
        EnumSpectrum ens = null;
        switch (dataType) {
            case 22: {
                ns.setNumberHelper(new UCharSpectrumHelper(ns));
                return ns;
            }
            case 2: {
                ns.setNumberHelper(new ShortSpectrumHelper(ns));
                return ns;
            }
            case 6: {
                ns.setNumberHelper(new UShortSpectrumHelper(ns));
                return ns;
            }
            case 5: {
                ns.setNumberHelper(new DoubleSpectrumHelper(ns));
                return ns;
            }
            case 4: {
                ns.setNumberHelper(new FloatSpectrumHelper(ns));
                return ns;
            }
            case 3: {
                ns.setNumberHelper(new LongSpectrumHelper(ns));
                return ns;
            }
            case 7: {
                ns.setNumberHelper(new ULongSpectrumHelper(ns));
                return ns;
            }
            case 23: {
                ns.setNumberHelper(new Long64SpectrumHelper(ns));
                return ns;
            }
            case 24: {
                ns.setNumberHelper(new ULong64SpectrumHelper(ns));
                return ns;
            }
            case 8: {
                ss = new StringSpectrum();
                return ss;
            }
            case 1: {
                bs = new BooleanSpectrum();
                return bs;
            }
            case 19: {
                dss = new DevStateSpectrum();
                return dss;
            }
            case 29: {
                ens = this.getTangoEnumSpectrum(config);
                if (ens == null) {
                    System.out.println("Warning, Tango_DEV_ENUM, AttributeFactory.getTangoEnumSpectrum(" + device.getName() + "/" + name + ") : Failed ");
                    return new InvalidAttribute();
                }
                ens.setEnumSpectrumHelper(new EnumSpectrumHelper(ens));
                return ens;
            }
        }
        System.out.println("Warning, AttributeFactory.getSpectrum(" + device.getName() + "/" + name + ") : Unsupported data type [" + dataType + "]");
        return new InvalidAttribute();
    }

    private AAttribute getImage(Device device, AttributeInfoEx config) {
        String name = config.name;
        int dataType = config.data_type;
        NumberImage nimg = new NumberImage();
        BooleanImage bi = null;
        StringImage si = null;
        switch (dataType) {
            case 22: {
                nimg.setNumberHelper(new UCharImageHelper(nimg));
                return nimg;
            }
            case 2: {
                nimg.setNumberHelper(new ShortImageHelper(nimg));
                return nimg;
            }
            case 6: {
                nimg.setNumberHelper(new UShortImageHelper(nimg));
                return nimg;
            }
            case 5: {
                nimg.setNumberHelper(new DoubleImageHelper(nimg));
                return nimg;
            }
            case 4: {
                nimg.setNumberHelper(new FloatImageHelper(nimg));
                return nimg;
            }
            case 3: {
                nimg.setNumberHelper(new LongImageHelper(nimg));
                return nimg;
            }
            case 7: {
                nimg.setNumberHelper(new ULongImageHelper(nimg));
                return nimg;
            }
            case 23: {
                nimg.setNumberHelper(new Long64ImageHelper(nimg));
                return nimg;
            }
            case 24: {
                nimg.setNumberHelper(new ULong64ImageHelper(nimg));
                return nimg;
            }
            case 1: {
                bi = new BooleanImage();
                return bi;
            }
            case 8: {
                si = new StringImage();
                return si;
            }
        }
        System.out.println("Warning, AttributeFactory.getSpectrum(" + device.getName() + "/" + name + ") : Unsupported data type [" + dataType + "]");
        return new InvalidAttribute();
    }

    private void dumpFactory(String msg) {
        if ((DeviceFactory.getInstance().getTraceMode() & 0x200) != 0) {
            System.out.println("-- AttributeFactory : " + msg + " --");
            for (int i = 0; i < this.attNames.length; ++i) {
                System.out.println("  " + i + ":" + this.attNames[i]);
            }
            System.out.println("-- AttributeFactory --------------------------------------");
        }
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }
}

