/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.NumberAttributeHelper;

public abstract class ANumber
extends AAttribute {
    private NumberAttributeHelper numberHelper = null;

    public double getMinValue() {
        return this.getPropertyStorage().getNumberProperty("min_value");
    }

    public double getMaxValue() {
        return this.getPropertyStorage().getNumberProperty("max_value");
    }

    public double getMinAlarm() {
        return this.getPropertyStorage().getNumberProperty("min_alarm");
    }

    public double getMaxAlarm() {
        return this.getPropertyStorage().getNumberProperty("max_alarm");
    }

    public double getMinWarning() {
        return this.getPropertyStorage().getNumberProperty("min_warning");
    }

    public double getMaxWarning() {
        return this.getPropertyStorage().getNumberProperty("max_warning");
    }

    public double getDeltaT() {
        return this.getPropertyStorage().getNumberProperty("delta_t");
    }

    public double getDeltaVal() {
        return this.getPropertyStorage().getNumberProperty("delta_val");
    }

    public void setMinValue(double d) {
        this.numberHelper.setMinValue(d);
    }

    public void setMaxValue(double d) {
        this.numberHelper.setMaxValue(d);
    }

    public void setMinAlarm(double d) {
        this.numberHelper.setMinAlarm(d);
    }

    public void setMaxAlarm(double d) {
        this.numberHelper.setMaxAlarm(d);
    }

    public void setMinWarning(double d) {
        this.numberHelper.setMinWarning(d);
    }

    public void setMaxWarning(double d) {
        this.numberHelper.setMaxWarning(d);
    }

    public void setDeltaT(double d) {
        this.numberHelper.setDeltaT(d);
    }

    public void setDeltaVal(double d) {
        this.numberHelper.setDeltaVal(d);
    }

    public void setMinValue(double d, boolean writable) {
        this.numberHelper.setMinValue(d, writable);
    }

    public void setMaxValue(double d, boolean writable) {
        this.numberHelper.setMaxValue(d, writable);
    }

    public void setMinAlarm(double d, boolean writable) {
        this.numberHelper.setMinAlarm(d, writable);
    }

    public void setMaxAlarm(double d, boolean writable) {
        this.numberHelper.setMaxAlarm(d, writable);
    }

    public void setMinWarning(double d, boolean writable) {
        this.numberHelper.setMinWarning(d, writable);
    }

    public void setMaxWarning(double d, boolean writable) {
        this.numberHelper.setMaxWarning(d, writable);
    }

    public void setDeltaT(double d, boolean writable) {
        this.numberHelper.setDeltaT(d, writable);
    }

    public void setDeltaVal(double d, boolean writable) {
        this.numberHelper.setDeltaVal(d, writable);
    }

    public NumberAttributeHelper getNumberHelper() {
        return this.numberHelper;
    }

    public void setNumberHelper(NumberAttributeHelper numberHelper) {
        this.numberHelper = numberHelper;
    }

    @Override
    public void setConfiguration(AttributeInfoEx c) {
        double d;
        super.setConfiguration(c);
        try {
            d = new Double(this.config.min_value);
            this.setMinValue(d, true);
            if (Double.isNaN(d)) {
                this.getProperty("min_value").setSpecified(false);
            }
        }
        catch (NumberFormatException e) {
            this.setMinValue(Double.NaN, true);
            this.getProperty("min_value").setSpecified(false);
        }
        try {
            d = new Double(this.config.max_value);
            this.setMaxValue(d, true);
            if (Double.isNaN(d)) {
                this.getProperty("max_value").setSpecified(false);
            }
        }
        catch (NumberFormatException e) {
            this.setMaxValue(Double.NaN, true);
            this.getProperty("max_value").setSpecified(false);
        }
        try {
            double d2 = this.config.alarms != null ? new Double(this.config.alarms.min_alarm).doubleValue() : new Double(this.config.min_alarm).doubleValue();
            this.setMinAlarm(d2, true);
            if (Double.isNaN(d2)) {
                this.getProperty("min_alarm").setSpecified(false);
            }
        }
        catch (NumberFormatException e) {
            this.setMinAlarm(Double.NaN, true);
            this.getProperty("min_alarm").setSpecified(false);
        }
        try {
            double d3 = this.config.alarms != null ? new Double(this.config.alarms.max_alarm).doubleValue() : new Double(this.config.max_alarm).doubleValue();
            this.setMaxAlarm(d3, true);
            if (Double.isNaN(d3)) {
                this.getProperty("max_alarm").setSpecified(false);
            }
        }
        catch (NumberFormatException e) {
            this.setMaxAlarm(Double.NaN, true);
            this.getProperty("max_alarm").setSpecified(false);
        }
        try {
            if (this.config.alarms != null) {
                double d4 = new Double(this.config.alarms.min_warning);
                this.setMinWarning(d4, true);
                if (Double.isNaN(d4)) {
                    this.getProperty("min_warning").setSpecified(false);
                }
            }
        }
        catch (NumberFormatException e) {
            this.setMinWarning(Double.NaN, true);
            this.getProperty("min_warning").setSpecified(false);
        }
        try {
            if (this.config.alarms != null) {
                double d5 = new Double(this.config.alarms.max_warning);
                this.setMaxWarning(d5, true);
                if (Double.isNaN(d5)) {
                    this.getProperty("max_warning").setSpecified(false);
                }
            }
        }
        catch (NumberFormatException e) {
            this.setMaxWarning(Double.NaN, true);
            this.getProperty("max_warning").setSpecified(false);
        }
        try {
            if (this.config.alarms != null) {
                double d6 = new Double(this.config.alarms.delta_t);
                this.setDeltaT(d6, true);
                if (Double.isNaN(d6)) {
                    this.getProperty("delta_t").setSpecified(false);
                }
            }
        }
        catch (NumberFormatException e) {
            this.setDeltaT(Double.NaN, true);
            this.getProperty("delta_t").setSpecified(false);
        }
        try {
            if (this.config.alarms != null) {
                double d7 = new Double(this.config.alarms.delta_val);
                this.setDeltaVal(d7, true);
                if (Double.isNaN(d7)) {
                    this.getProperty("delta_val").setSpecified(false);
                }
            }
        }
        catch (NumberFormatException e) {
            this.setDeltaVal(Double.NaN, true);
            this.getProperty("delta_val").setSpecified(false);
        }
    }

    public double getValueInDeviceUnit(double dispPval) {
        double dUnitFactor = 1.0;
        dUnitFactor = this.getDisplayUnitFactor();
        if (dUnitFactor <= 0.0) {
            dUnitFactor = 1.0;
        }
        double devPval = dispPval / dUnitFactor;
        return devPval;
    }

    public double getValueInDisplayUnit(double devPval) {
        double dUnitFactor = 1.0;
        dUnitFactor = this.getDisplayUnitFactor();
        if (dUnitFactor <= 0.0) {
            dUnitFactor = 1.0;
        }
        double dispPval = devPval * dUnitFactor;
        return dispPval;
    }
}

