/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.tangoatk.core.IRefreshee;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class Refresher
extends Thread
implements Serializable {
    public boolean stop = false;
    public boolean running = false;
    private boolean synchronizedPeriod = false;
    private boolean traceUnexpected = false;
    long refreshInterval = 1000L;
    private long before;
    private long after;
    private long sleepingPeriod;
    IRefreshee refreshee;
    protected static ThreadGroup refreshers = new ThreadGroup("ATKRefreshers");

    public Refresher() {
    }

    public Refresher(String s) {
        super(refreshers, s);
    }

    public void setRefreshInterval(long milliSeconds) {
        this.refreshInterval = milliSeconds;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.stop = false;
        super.start();
    }

    public void stopRunning() {
        this.running = false;
        this.stop = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        while (true) {
            block7: {
                if (this.stop) {
                    return;
                }
                this.before = System.currentTimeMillis();
                try {
                    this.refreshee.refresh();
                }
                catch (Exception unexpected) {
                    if (!this.traceUnexpected) break block7;
                    System.out.println("!!!!!!!!!!! Unexpected exception in refreshment !!!!!!!!!!!!!!!!!!!!!!");
                    unexpected.printStackTrace();
                }
            }
            try {
                if (this.synchronizedPeriod) {
                    this.synchronRefresh();
                    continue;
                }
                Refresher.sleep(this.refreshInterval);
                continue;
            }
            catch (Exception e) {
                if (!this.traceUnexpected) continue;
                System.out.println("!!!!!!!!!!! Refreshment sleep exception !!!!!!!!!!!!!!!!!!!!!!");
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public Thread addRefreshee(IRefreshee e) {
        this.refreshee = e;
        return this;
    }

    public String getVersion() {
        return "$Id$";
    }

    private void synchronRefresh() {
        block3: {
            this.after = System.currentTimeMillis();
            this.sleepingPeriod = this.refreshInterval - (this.after - this.before);
            try {
                if (this.sleepingPeriod > 0L) {
                    Refresher.sleep(this.sleepingPeriod);
                }
            }
            catch (InterruptedException e) {
                if (!this.traceUnexpected) break block3;
                System.out.println("!!!!!!!!!!! Refreshment sleep exception !!!!!!!!!!!!!!!!!!!!!!");
                e.printStackTrace();
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading EntityList ");
        in.defaultReadObject();
        this.stopRunning();
    }

    public void setSynchronizedPeriod(boolean synchronizedP) {
        this.synchronizedPeriod = synchronizedP;
    }

    public boolean isSynchronizedPeriod() {
        return this.synchronizedPeriod;
    }

    public void setTraceUnexpected(boolean trace) {
        this.traceUnexpected = trace;
    }

    public boolean isTraceUnexpected() {
        return this.traceUnexpected;
    }

    public IRefreshee getRefreshee() {
        return this.refreshee;
    }

    public void setRefreshee(IRefreshee refreshee) {
        this.refreshee = refreshee;
    }
}

