/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DispLevel;
import fr.esrf.tangoatk.core.DisplayLevelProperty;
import fr.esrf.tangoatk.core.FormatProperty;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.NumberProperty;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StringArrayProperty;
import fr.esrf.tangoatk.core.StringProperty;
import fr.esrf.tangoatk.core.WritableProperty;
import fr.esrf.tangoatk.util.AtkTimer;
import java.util.HashMap;
import java.util.Map;

public class PropertyStorage {
    protected Map<String, Property> propertyMap = new HashMap<String, Property>();

    public void setProperty(String name, Number value) {
        NumberProperty p = (NumberProperty)this.propertyMap.get(name);
        if (p == null) {
            AtkTimer.getInstance().endTimer(Thread.currentThread());
            return;
        }
        p.setValue(value);
    }

    public void setProperty(IEntity entity, String name, Object value, boolean editable) {
        this.propertyMap.put(name, new Property(entity, name, value, editable));
    }

    public void setProperty(IEntity entity, String name, Number value, boolean editable) {
        Property p = this.propertyMap.get(name);
        if (p == null) {
            this.propertyMap.put(name, new NumberProperty(entity, name, value, editable));
        } else {
            p.setValue(value);
        }
    }

    public void setProperty(IEntity entity, String name, String[] value, boolean editable) {
        StringArrayProperty p = (StringArrayProperty)this.propertyMap.get(name);
        if (p == null) {
            p = new StringArrayProperty(entity, name, null, editable);
            p.setValueFromStringArray(value);
            this.propertyMap.put(name, p);
        } else {
            p.setValueFromStringArray(value);
        }
    }

    public void setProperty(IAttribute entity, String name, AttrWriteType value, boolean editable) {
        Property p = this.propertyMap.get(name);
        if (p == null) {
            this.propertyMap.put(name, new WritableProperty(entity, name, value, editable));
        } else {
            p.setValue(value);
        }
    }

    public void setProperty(IAttribute entity, String name, AttrDataFormat value, boolean editable) {
        AtkTimer.getInstance().startTimer(Thread.currentThread());
        Property p = this.propertyMap.get(name);
        if (p == null) {
            this.propertyMap.put(name, new FormatProperty(entity, name, value, editable));
        } else {
            p.setValue(value);
        }
        AtkTimer.getInstance().endTimer(Thread.currentThread());
    }

    public void setProperty(IEntity entity, String name, DispLevel value, boolean editable) {
        Property p = this.propertyMap.get(name);
        if (p == null) {
            this.propertyMap.put(name, new DisplayLevelProperty(entity, name, value, editable));
        } else {
            p.setValue(value);
        }
    }

    public void setProperty(IEntity entity, String name, String value, boolean editable) {
        Property p = this.propertyMap.get(name);
        if (p == null) {
            this.propertyMap.put(name, new StringProperty(entity, name, value, editable));
        } else {
            p.setValue(value);
        }
    }

    public void setProperty(IEntity entity, String name, Object value) {
        Property p = this.propertyMap.get(name);
        p.setValue(value);
    }

    public Map<String, Property> getPropertyMap() {
        return this.propertyMap;
    }

    public void refreshProperties() {
        for (Property prop : this.getPropertyMap().values()) {
            prop.refresh();
        }
    }

    public Property getProperty(String s) {
        AtkTimer.getInstance().startTimer(Thread.currentThread());
        Property p = null;
        if (this.propertyMap != null) {
            p = this.propertyMap.get(s);
        }
        AtkTimer.getInstance().endTimer(Thread.currentThread());
        return p;
    }

    public double getNumberProperty(String s) {
        NumberProperty p = (NumberProperty)this.getProperty(s);
        if (p != null && p.isSpecified()) {
            if (p.getValue() instanceof Number) {
                return ((Number)p.getValue()).doubleValue();
            }
            if (p.getValue() instanceof String) {
                try {
                    double value = Double.parseDouble((String)p.getValue());
                    return value;
                }
                catch (NumberFormatException nfe) {
                    return Double.NaN;
                }
            }
        }
        return Double.NaN;
    }

    public String[] getStringArrayProperty(String name) {
        StringArrayProperty p = (StringArrayProperty)this.getProperty(name);
        if (p != null && p.isSpecified()) {
            return p.getStringArrayValue();
        }
        return null;
    }
}

