/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.tangoatk.core.IEntity;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class Property {
    protected String name;
    protected Object value;
    protected Object oldValue;
    protected boolean editable;
    protected IEntity parent;
    protected boolean specified = true;
    protected PropertyChangeSupport propChanges;

    public Property() {
    }

    public Property(IEntity parent, String name, Object value, boolean editable) {
        this.propChanges = new PropertyChangeSupport(this);
        this.parent = parent;
        this.setName(name);
        this.setValue(value);
        this.editable = editable;
    }

    public void addPresentationListener(PropertyChangeListener l) {
        this.propChanges.addPropertyChangeListener("presentation", l);
    }

    public void removePresentationListener(PropertyChangeListener l) {
        this.propChanges.removePropertyChangeListener("presentation", l);
    }

    public void refresh() {
        this.propChanges.firePropertyChange("presentation", this.oldValue, this.value);
        this.oldValue = this.value;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setSpecified(boolean b) {
        this.specified = b;
    }

    public boolean isSpecified() {
        return this.specified;
    }

    public void setName(String s) {
        this.name = s;
    }

    public void setValue(Object o) {
        this.setSpecified(true);
        this.oldValue = this.value;
        this.value = o;
    }

    public void setValueFromString(String stringValue) {
        this.setValue(stringValue);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getStringValue() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "";
    }

    public int getIntValue() {
        return (Integer)this.value;
    }

    public String getPresentation() {
        String tmp = "";
        if (this.value != null) {
            tmp = this.value.toString();
        }
        return tmp;
    }

    public String toString() {
        return this.getName();
    }

    public void store() {
        this.propChanges.firePropertyChange("presentation", this.oldValue, this.value);
        this.parent.storeConfig();
    }

    public String getVersion() {
        return "$Id$";
    }
}

