/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.tangoatk.core.ATKEvent;
import fr.esrf.tangoatk.core.INumberSpectrum;

public class NumberSpectrumEvent
extends ATKEvent {
    double[] value;
    double[] devValue;

    public NumberSpectrumEvent(INumberSpectrum source, double[] value, long timeStamp) {
        super(source, timeStamp);
        this.setValue(value);
        this.devValue = new double[1];
    }

    public double[] getValue() {
        return this.value;
    }

    public double[] getDeviceValue() {
        double dispUnitFactor = 1.0;
        if (this.source != null && this.source instanceof INumberSpectrum) {
            dispUnitFactor = ((INumberSpectrum)this.source).getDisplayUnitFactor();
        }
        if (dispUnitFactor <= 0.0) {
            dispUnitFactor = 1.0;
        }
        if (dispUnitFactor == 1.0) {
            return this.value;
        }
        int dim = this.value.length;
        if (dim != this.devValue.length || this.devValue.length == 0) {
            this.devValue = new double[dim];
        }
        for (int i = 0; i < dim; ++i) {
            this.devValue[i] = this.value[i] / dispUnitFactor;
        }
        return this.devValue;
    }

    public double[] getStandardValue() {
        double stdUnitFactor = 1.0;
        double[] devVal = this.getDeviceValue();
        if (this.source != null && this.source instanceof INumberSpectrum) {
            stdUnitFactor = ((INumberSpectrum)this.source).getStandardUnitFactor();
        }
        if (stdUnitFactor <= 0.0) {
            stdUnitFactor = 1.0;
        }
        if (stdUnitFactor == 1.0) {
            return devVal;
        }
        int dim = devVal.length;
        double[] stdVal = new double[dim];
        for (int i = 0; i < dim; ++i) {
            stdVal[i] = devVal[i] * stdUnitFactor;
        }
        return stdVal;
    }

    public void setValue(double[] value) {
        this.value = value;
    }

    public void setSource(INumberSpectrum source) {
        this.source = source;
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }
}

