/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.tangoatk.core.ATKEvent;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.INumberScalar;

public class NumberScalarEvent
extends ATKEvent {
    double value;
    double devValue;
    long timeStamp;
    INumberScalar _source;

    public NumberScalarEvent(INumberScalar source, double value, long timeStamp) {
        super(source, timeStamp);
        this._source = source;
        this.setValue(value);
    }

    public double getValue() {
        return this.value;
    }

    public double getDeviceValue() {
        double dispUnitFactor = 1.0;
        if (this.source != null && this.source instanceof INumberScalar) {
            dispUnitFactor = ((INumberScalar)this.source).getDisplayUnitFactor();
        }
        if (dispUnitFactor <= 0.0) {
            dispUnitFactor = 1.0;
        }
        if (dispUnitFactor == 1.0) {
            return this.value;
        }
        this.devValue = this.value / dispUnitFactor;
        return this.devValue;
    }

    public double getStandardValue() {
        double stdUnitFactor = 1.0;
        double devVal = this.getDeviceValue();
        if (this.source != null && this.source instanceof INumberImage) {
            stdUnitFactor = ((INumberImage)this.source).getStandardUnitFactor();
        }
        if (stdUnitFactor <= 0.0) {
            stdUnitFactor = 1.0;
        }
        if (stdUnitFactor == 1.0) {
            return devVal;
        }
        double stdVal = devVal * stdUnitFactor;
        return stdVal;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setSource(INumberScalar source) {
        this.source = source;
        this._source = source;
    }

    public INumberScalar getNumberSource() {
        return this._source;
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }
}

