/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DispLevel;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.Property;

public class DisplayLevelProperty
extends Property {
    public static final String OPERATOR = "OPERATOR";
    public static final String EXPERT = "EXPERT";

    public DisplayLevelProperty(IEntity parent, String name, DispLevel value, boolean editable) {
        super(parent, name, value, editable);
    }

    @Override
    public String getPresentation() {
        switch (((DispLevel)this.value).value()) {
            case 0: {
                return OPERATOR;
            }
            case 1: {
                return EXPERT;
            }
        }
        return null;
    }

    public boolean isOperator() {
        return this.getIntValue() == 0;
    }

    public boolean isExpert() {
        return this.getIntValue() == 1;
    }

    @Override
    public int getIntValue() {
        return ((DispLevel)this.value).value();
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    @Override
    public void setValueFromString(String stringValue) {
        if (OPERATOR.equalsIgnoreCase(stringValue.trim())) {
            this.setValue(DispLevel.OPERATOR);
        } else if (EXPERT.equalsIgnoreCase(stringValue.trim())) {
            this.setValue(DispLevel.EXPERT);
        }
    }
}

