/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.tangoatk.core.Device;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JOptionPane;

public class DeviceProperty {
    protected String name;
    protected String[] value;
    protected String[] oldValue;
    protected boolean editable;
    protected Device parent;
    protected boolean specified;
    protected PropertyChangeSupport propChanges;

    public DeviceProperty() {
        this.name = "";
        this.value = new String[0];
        this.oldValue = new String[0];
        this.editable = true;
        this.parent = null;
        this.propChanges = new PropertyChangeSupport(this);
        this.specified = true;
    }

    public DeviceProperty(Device theParent, String name, String[] value) {
        this.propChanges = new PropertyChangeSupport(this);
        this.parent = theParent;
        this.setName(name);
        this.setValue(value);
        this.editable = true;
        this.specified = true;
    }

    public DeviceProperty(Device theParent, String name, String[] value, boolean isEditable) {
        this.propChanges = new PropertyChangeSupport(this);
        this.parent = theParent;
        this.setName(name);
        this.setValue(value);
        this.editable = isEditable;
        this.specified = true;
    }

    public void addPresentationListener(PropertyChangeListener l) {
        this.propChanges.addPropertyChangeListener("presentation", l);
    }

    public void removePresentationListener(PropertyChangeListener l) {
        this.propChanges.removePropertyChangeListener("presentation", l);
    }

    public void refresh() {
        if (this.parent != null) {
            try {
                DbDatum property = this.parent.get_property(this.name);
                if (property == null) {
                    throw new DevFailed();
                }
                this.oldValue = this.value;
                this.value = property.extractStringArray();
                this.propChanges.firePropertyChange("presentation", this.oldValue, this.value);
            }
            catch (DevFailed e) {
                JOptionPane.showMessageDialog(null, "Failed to update property " + this.name, "Error", 0);
            }
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setSpecified(boolean b) {
        this.specified = b;
    }

    public boolean isSpecified() {
        return this.specified;
    }

    public void setName(String s) {
        this.name = s;
    }

    public void setValue(String[] o) {
        this.setSpecified(true);
        this.oldValue = this.value;
        this.value = o;
    }

    public void setValue(String s) {
        String tmp = "";
        if (s != null) {
            tmp = s;
        }
        while (tmp.endsWith("\n")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        this.setValue(tmp.split("\n"));
    }

    public String getName() {
        return this.name;
    }

    public String[] getValue() {
        return this.value;
    }

    public String getStringValue() {
        String tmp = "";
        for (int i = 0; i < this.value.length; ++i) {
            tmp = tmp + this.value[i] + "\n";
        }
        if (!"".equals(tmp)) {
            tmp = tmp.substring(0, tmp.lastIndexOf("\n"));
        }
        return tmp;
    }

    public String toString() {
        return this.getName();
    }

    public void store() {
        this.propChanges.firePropertyChange("presentation", this.oldValue, this.value);
        this.parent.storeProperty(this.name);
    }

    public String getVersion() {
        return "$Id$";
    }
}

