/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import java.lang.ref.WeakReference;
import java.util.EventListener;

public class AtkEventListenerList {
    private static final Object[] nullArray = new Object[0];
    Object[] listenerList = nullArray;

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public synchronized void add(Class t, EventListener l) {
        if (l == null) {
            System.out.print("AtkEventListenerList.add() : Trying to register a null listener object [" + t + "]");
            return;
        }
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + l + " is not of type " + t);
        }
        if (this.foundEntry(t, l) < 0) {
            int i = this.listenerList.length;
            Object[] tmp = new Object[i + 2];
            System.arraycopy(this.listenerList, 0, tmp, 0, i);
            tmp[i] = t;
            tmp[i + 1] = new WeakReference<EventListener>(l);
            this.listenerList = tmp;
        }
    }

    public synchronized void remove(Class t, EventListener l) {
        int index = this.foundEntry(t, l);
        this.remove(index);
    }

    public synchronized void remove(int index) {
        if (index < 0) {
            return;
        }
        Object[] tmp = new Object[this.listenerList.length - 2];
        System.arraycopy(this.listenerList, 0, tmp, 0, index);
        if (index < tmp.length) {
            System.arraycopy(this.listenerList, index + 2, tmp, index, tmp.length - index);
        }
        this.listenerList = tmp.length == 0 ? nullArray : tmp;
    }

    public synchronized void removeAtkEventListeners() {
        this.listenerList = nullArray;
    }

    public synchronized int getListenerCount() {
        return this.listenerList.length / 2;
    }

    private int foundEntry(Class t, EventListener l) {
        int index = -1;
        for (int i = this.listenerList.length - 2; i >= 0; i -= 2) {
            EventListener tempListener;
            WeakReference ref;
            if (this.listenerList[i] != t || (ref = (WeakReference)this.listenerList[i + 1]).get() == null || !(tempListener = (EventListener)ref.get()).equals(l)) continue;
            index = i;
            break;
        }
        return index;
    }
}

