/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.tangoatk.core.AEntityFactory;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityCollection;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.IEntityList;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IListStateListener;
import fr.esrf.tangoatk.core.IRefresherListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.Refresher;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;

public abstract class AEntityList
extends DefaultListModel
implements IEntityCollection,
ComboBoxModel,
IEntityList {
    public static final int REFRESHER_STARTED = 1;
    public static final int REFRESHER_STOPPED = 2;
    protected int refreshInterval = 1000;
    protected AEntityFactory factory;
    protected Refresher refresher = null;
    protected List<IErrorListener> errorListeners = new Vector<IErrorListener>();
    protected List<IRefresherListener> refresherListeners = new Vector<IRefresherListener>();
    protected List<IListStateListener> listStateListeners = new Vector<IListStateListener>();
    protected List<ISetErrorListener> setErrorListeners = new Vector<ISetErrorListener>();
    protected IEntity selectedItem;
    boolean refresherStarted = false;
    protected IEntityFilter filter = new IEntityFilter(){

        @Override
        public boolean keep(IEntity entity) {
            return true;
        }
    };
    protected boolean synchronizedPeriod = false;
    protected boolean traceUnexpected = false;
    private static String VERSION = "$Id$";

    @Override
    public void setRefreshInterval(int milliSeconds) {
        this.refreshInterval = milliSeconds;
        if (this.refresher != null) {
            this.refresher.setRefreshInterval(this.refreshInterval);
        }
    }

    @Override
    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object obj) {
        this.selectedItem = (IEntity)obj;
    }

    @Override
    public void refresh() {
        IEntity ie = null;
        long t0 = System.currentTimeMillis();
        this.trace(4, "AEntityList.refresh()  ", t0);
        for (int i = 0; i < this.size(); ++i) {
            ie = (IEntity)this.get(i);
            if (ie instanceof IAttribute) {
                IAttribute att = (IAttribute)ie;
                if (att.hasEvents()) continue;
                this.trace(4, "AEntityList.refresh() : attribute has not subscribed event; will call refresh for " + ie.getName(), t0);
                ie.refresh();
                continue;
            }
            ie.refresh();
        }
        this.fireRefresherStepEvent();
    }

    @Override
    public boolean isRefresherStarted() {
        return this.refresherStarted;
    }

    @Override
    public void stopRefresher() {
        if (this.refresher != null) {
            this.refresher.stop = true;
            this.refresher.refreshee = null;
        }
        this.refresher = null;
        this.refresherStarted = false;
        this.fireListStateChangeEvent();
    }

    @Override
    public void startRefresher() {
        if (this.isRefresherStarted()) {
            return;
        }
        if (this.refresher == null) {
            this.refresher = new Refresher("ListRefresher");
            this.refresher.setRefreshInterval(this.getRefreshInterval());
            this.refresher.setSynchronizedPeriod(this.synchronizedPeriod);
            this.refresher.setTraceUnexpected(this.traceUnexpected);
        }
        this.refresher.addRefreshee(this).start();
        this.refresherStarted = true;
        this.fireListStateChangeEvent();
    }

    @Override
    public void setRefresher(Refresher r) {
        if (r != null) {
            this.synchronizedPeriod = r.isSynchronizedPeriod();
            this.traceUnexpected = r.isTraceUnexpected();
        }
        this.refresher = r;
    }

    @Override
    public void setFilter(IEntityFilter filter) {
        this.filter = filter;
    }

    @Override
    public IEntityFilter getFilter() {
        return this.filter;
    }

    @Override
    public List<IEntity> get(String[] names) {
        Vector<IEntity> l = new Vector<IEntity>();
        for (int i = 0; i < names.length; ++i) {
            l.add(this.get(names[i]));
        }
        return l;
    }

    @Override
    public IEntity get(String attributeName) {
        for (int i = 0; i < this.size(); ++i) {
            IEntity e = (IEntity)this.get(i);
            if (!e.getName().equalsIgnoreCase(attributeName)) continue;
            return e;
        }
        return null;
    }

    @Override
    public void add(String[] names) throws ConnectionException {
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null) continue;
            this.add(names[i]);
        }
    }

    @Override
    public void add(IEntity entity) {
        int j;
        if (this.contains(entity)) {
            return;
        }
        if (!this.filter.keep(entity)) {
            return;
        }
        if (this.errorListeners != null) {
            for (j = 0; j < this.errorListeners.size(); ++j) {
                entity.addErrorListener(this.errorListeners.get(j));
            }
        }
        if (entity instanceof IAttribute && this.setErrorListeners != null) {
            for (j = 0; j < this.setErrorListeners.size(); ++j) {
                ((IAttribute)entity).addSetErrorListener(this.setErrorListeners.get(j));
            }
        }
        this.addElement(entity);
    }

    @Override
    public IEntity add(String name) throws ConnectionException {
        IEntity e2 = this.get(name);
        if (e2 == null) {
            List<IEntity> l = null;
            try {
                l = this.factory.getEntities(name);
            }
            catch (ConnectionException ex) {
                if (AEntityFactory.isWildCard(name)) {
                    name = name.substring(0, name.length() - 2);
                }
                this.fireErrorEvent(ex, name);
                throw ex;
            }
            for (IEntity e2 : l) {
                int j;
                if (e2 == null || this.contains(e2) || !this.filter.keep(e2)) continue;
                if (this.errorListeners != null) {
                    for (j = 0; j < this.errorListeners.size(); ++j) {
                        e2.addErrorListener(this.errorListeners.get(j));
                    }
                }
                if (e2 instanceof IAttribute && this.setErrorListeners != null) {
                    for (j = 0; j < this.setErrorListeners.size(); ++j) {
                        ((IAttribute)e2).addSetErrorListener(this.setErrorListeners.get(j));
                    }
                }
                this.addElement(e2);
            }
        }
        return e2;
    }

    @Override
    public boolean remove(String entityName) {
        IEntity a = this.get(entityName);
        int idx = this.indexOf(a);
        return idx >= 0 && this.remove(idx) != null;
    }

    @Override
    public void addErrorListener(IErrorListener l) {
        this.errorListeners.add(l);
    }

    @Override
    public void addSetErrorListener(ISetErrorListener l) {
        this.setErrorListeners.add(l);
    }

    @Override
    public void removeErrorListener(IErrorListener errl) {
        IEntity ie = null;
        if (errl == null) {
            return;
        }
        if (this.errorListeners.contains(errl)) {
            for (int i = 0; i < this.size(); ++i) {
                ie = (IEntity)this.get(i);
                ie.removeErrorListener(errl);
            }
            try {
                this.errorListeners.remove(errl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeSetErrorListener(ISetErrorListener setErrl) {
        IEntity ie = null;
        IAttribute ia = null;
        if (setErrl == null) {
            return;
        }
        if (this.setErrorListeners.contains(setErrl)) {
            for (int i = 0; i < this.size(); ++i) {
                ie = (IEntity)this.get(i);
                if (!(ie instanceof IAttribute)) continue;
                ia = (IAttribute)ie;
                ia.removeSetErrorListener(setErrl);
            }
            try {
                this.setErrorListeners.remove(setErrl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void addRefresherListener(IRefresherListener l) {
        if (!this.refresherListeners.contains(l)) {
            this.refresherListeners.add(l);
        }
    }

    @Override
    public void removeRefresherListener(IRefresherListener l) {
        if (this.refresherListeners != null) {
            this.refresherListeners.remove(l);
        }
    }

    public void clearRefresherListener() {
        this.refresherListeners.clear();
    }

    protected void fireRefresherStepEvent() {
        int s = this.refresherListeners.size();
        for (int i = 0; i < s; ++i) {
            IRefresherListener a = this.refresherListeners.get(i);
            try {
                a.refreshStep();
                continue;
            }
            catch (Exception e) {
                System.out.println("AEntityList.fireRefresherStepEvent() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("AEntityList.fireRefresherStepEvent()------------------------------------------------");
            }
        }
    }

    @Override
    public void addListStateListener(IListStateListener l) {
        if (!this.listStateListeners.contains(l)) {
            this.listStateListeners.add(l);
        }
    }

    @Override
    public void removeListStateListener(IListStateListener l) {
        if (this.listStateListeners != null) {
            this.listStateListeners.remove(l);
        }
    }

    @Override
    public void clearListStateListener() {
        this.listStateListeners.clear();
    }

    protected void fireListStateChangeEvent() {
        int s = this.listStateListeners.size();
        for (int i = 0; i < s; ++i) {
            IListStateListener a = this.listStateListeners.get(i);
            try {
                if (this.refresherStarted) {
                    a.stateChange(1);
                    continue;
                }
                a.stateChange(2);
                continue;
            }
            catch (Exception e) {
                System.out.println("AEntityList.fireListStateChangeEvent() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("AEntityList.fireListStateChangeEvent()------------------------------------------------");
            }
        }
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    private void fireErrorEvent(ConnectionException ex, String name) {
        if (this.errorListeners != null) {
            for (int j = 0; j < this.errorListeners.size(); ++j) {
                this.errorListeners.get(j).errorChange(new ErrorEvent(name, ex, System.currentTimeMillis()));
            }
        }
    }

    public void finalize() {
        this.stopRefresher();
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public void setSynchronizedPeriod(boolean synchro) {
        this.synchronizedPeriod = synchro;
        if (this.refresher == null) {
            this.refresher = new Refresher("ListRefresher");
            this.refresher.setRefreshInterval(this.getRefreshInterval());
        }
        this.refresher.setSynchronizedPeriod(this.synchronizedPeriod);
        this.refresher.setTraceUnexpected(this.traceUnexpected);
    }

    @Override
    public void setTraceUnexpected(boolean trace) {
        this.traceUnexpected = trace;
        if (this.refresher == null) {
            this.refresher = new Refresher("ListRefresher");
            this.refresher.setRefreshInterval(this.getRefreshInterval());
        }
        this.refresher.setSynchronizedPeriod(this.synchronizedPeriod);
        this.refresher.setTraceUnexpected(this.traceUnexpected);
    }
}

