/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture.spi;

import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.texture.spi.LEDataInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class TGAImage {
    private final Header header;
    private int format;
    private int bpp;
    private ByteBuffer data;

    private TGAImage(Header header) {
        this.header = header;
    }

    private void decodeImage(GLProfile gLProfile, LEDataInputStream lEDataInputStream) throws IOException {
        switch (this.header.imageType()) {
            case 1: {
                throw new IOException("TGADecoder Uncompressed Colormapped images not supported");
            }
            case 2: {
                switch (this.header.pixelDepth) {
                    case 16: {
                        throw new IOException("TGADecoder Compressed 16-bit True Color images not supported");
                    }
                    case 24: 
                    case 32: {
                        this.decodeRGBImageU24_32(gLProfile, lEDataInputStream);
                    }
                }
                break;
            }
            case 3: {
                throw new IOException("TGADecoder Uncompressed Grayscale images not supported");
            }
            case 9: {
                throw new IOException("TGADecoder Compressed Colormapped images not supported");
            }
            case 10: {
                switch (this.header.pixelDepth) {
                    case 16: {
                        throw new IOException("TGADecoder Compressed 16-bit True Color images not supported");
                    }
                    case 24: 
                    case 32: {
                        this.decodeRGBImageRLE24_32(gLProfile, lEDataInputStream);
                    }
                }
                break;
            }
            case 11: {
                throw new IOException("TGADecoder Compressed Grayscale images not supported");
            }
        }
    }

    private void decodeRGBImageU24_32(GLProfile gLProfile, LEDataInputStream lEDataInputStream) throws IOException {
        this.setupImage24_32(gLProfile);
        int n = this.header.width() * this.bpp;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n * this.header.height()];
        for (int i = 0; i < this.header.height(); ++i) {
            lEDataInputStream.readFully(byArray, 0, n);
            int n2 = this.header.topToBottom() ? this.header.height - i - 1 : i;
            System.arraycopy(byArray, 0, byArray2, n2 * n, byArray.length);
        }
        if (this.format == 6407 || this.format == 6408) {
            TGAImage.swapBGR(byArray2, n, this.header.height(), this.bpp);
        }
        this.data = ByteBuffer.wrap(byArray2);
    }

    private void decodeRGBImageRLE24_32(GLProfile gLProfile, LEDataInputStream lEDataInputStream) throws IOException {
        int n;
        this.setupImage24_32(gLProfile);
        byte[] byArray = new byte[this.bpp];
        int n2 = this.header.width() * this.bpp;
        byte[] byArray2 = new byte[n2 * this.header.height()];
        for (int i = 0; i < byArray2.length; i += this.bpp * n) {
            int n3 = lEDataInputStream.readUnsignedByte();
            n = (n3 & 0x7F) + 1;
            if ((n3 & 0x80) != 0) {
                lEDataInputStream.read(byArray);
                for (int j = 0; j < n; ++j) {
                    System.arraycopy(byArray, 0, byArray2, i + j * this.bpp, this.bpp);
                }
                continue;
            }
            lEDataInputStream.read(byArray2, i, n * this.bpp);
        }
        if (this.format == 6407 || this.format == 6408) {
            TGAImage.swapBGR(byArray2, n2, this.header.height(), this.bpp);
        }
        this.data = ByteBuffer.wrap(byArray2);
    }

    private void setupImage24_32(GLProfile gLProfile) {
        this.bpp = this.header.pixelDepth / 8;
        switch (this.header.pixelDepth) {
            case 24: {
                this.format = gLProfile.isGL2GL3() ? 32992 : 6407;
                break;
            }
            case 32: {
                boolean bl = gLProfile.isGL2GL3();
                if (!bl) {
                    GLContext gLContext = GLContext.getCurrent();
                    bl = null != gLContext && gLContext.isTextureFormatBGRA8888Available();
                }
                this.format = bl ? 32993 : 6408;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private static void swapBGR(byte[] byArray, int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; j += n3) {
                byte by;
                int n4 = i * n + j;
                byte by2 = byArray[n4 + 0];
                byArray[n4 + 0] = by = byArray[n4 + 2];
                byArray[n4 + 2] = by2;
            }
        }
    }

    public int getWidth() {
        return this.header.width();
    }

    public int getHeight() {
        return this.header.height();
    }

    public int getGLFormat() {
        return this.format;
    }

    public int getBytesPerPixel() {
        return this.bpp;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public static TGAImage read(GLProfile gLProfile, String string) throws IOException {
        return TGAImage.read(gLProfile, new FileInputStream(string));
    }

    public static TGAImage read(GLProfile gLProfile, InputStream inputStream) throws IOException {
        LEDataInputStream lEDataInputStream = new LEDataInputStream(new BufferedInputStream(inputStream));
        Header header = new Header(lEDataInputStream);
        TGAImage tGAImage = new TGAImage(header);
        tGAImage.decodeImage(gLProfile, lEDataInputStream);
        return tGAImage;
    }

    public void write(String string) throws IOException {
        this.write(new File(string));
    }

    public void write(File file) throws IOException {
        FileOutputStream fileOutputStream = IOUtil.getFileOutputStream(file, true);
        FileChannel fileChannel = fileOutputStream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.header.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.header.write(byteBuffer);
        byteBuffer.rewind();
        fileChannel.write(byteBuffer);
        fileChannel.write(this.data);
        fileChannel.force(true);
        fileChannel.close();
        fileOutputStream.close();
        this.data.rewind();
    }

    public static TGAImage createFromData(int n, int n2, boolean bl, boolean bl2, ByteBuffer byteBuffer) {
        Header header = new Header();
        header.imageType = 2;
        header.width = n;
        header.height = n2;
        header.pixelDepth = (byte)(bl ? 32 : 24);
        header.imageDescriptor = (byte)(bl2 ? 32 : 0);
        TGAImage tGAImage = new TGAImage(header);
        tGAImage.data = byteBuffer;
        return tGAImage;
    }

    public static class Header {
        public static final int TYPE_NEW = 0;
        public static final int TYPE_OLD = 1;
        public static final int TYPE_UNK = 2;
        public static final int NO_IMAGE = 0;
        public static final int UCOLORMAPPED = 1;
        public static final int UTRUECOLOR = 2;
        public static final int UBLACKWHITE = 3;
        public static final int COLORMAPPED = 9;
        public static final int TRUECOLOR = 10;
        public static final int BLACKWHITE = 11;
        public static final int ID_ATTRIBPERPIXEL = 15;
        public static final int ID_RIGHTTOLEFT = 16;
        public static final int ID_TOPTOBOTTOM = 32;
        public static final int ID_INTERLEAVE = 192;
        public static final int I_NOTINTERLEAVED = 0;
        public static final int I_TWOWAY = 1;
        public static final int I_FOURWAY = 2;
        private final int tgaType;
        private int idLength;
        private int colorMapType;
        private int imageType;
        private int firstEntryIndex;
        private int colorMapLength;
        private byte colorMapEntrySize;
        private int xOrigin;
        private int yOrigin;
        private int width;
        private int height;
        private byte pixelDepth;
        private byte imageDescriptor;
        private byte[] imageIDbuf;
        private String imageID;

        Header() {
            this.tgaType = 1;
        }

        Header(LEDataInputStream lEDataInputStream) throws IOException {
            this.tgaType = 1;
            this.idLength = lEDataInputStream.readUnsignedByte();
            this.colorMapType = lEDataInputStream.readUnsignedByte();
            this.imageType = lEDataInputStream.readUnsignedByte();
            this.firstEntryIndex = lEDataInputStream.readUnsignedShort();
            this.colorMapLength = lEDataInputStream.readUnsignedShort();
            this.colorMapEntrySize = lEDataInputStream.readByte();
            this.xOrigin = lEDataInputStream.readUnsignedShort();
            this.yOrigin = lEDataInputStream.readUnsignedShort();
            this.width = lEDataInputStream.readUnsignedShort();
            this.height = lEDataInputStream.readUnsignedShort();
            this.pixelDepth = lEDataInputStream.readByte();
            this.imageDescriptor = lEDataInputStream.readByte();
            if (this.idLength > 0) {
                this.imageIDbuf = new byte[this.idLength];
                lEDataInputStream.read(this.imageIDbuf, 0, this.idLength);
                this.imageID = new String(this.imageIDbuf, "US-ASCII");
            }
        }

        public int tgaType() {
            return this.tgaType;
        }

        public int idLength() {
            return this.idLength;
        }

        public int colorMapType() {
            return this.colorMapType;
        }

        public int imageType() {
            return this.imageType;
        }

        public int firstEntryIndex() {
            return this.firstEntryIndex;
        }

        public int colorMapLength() {
            return this.colorMapLength;
        }

        public byte colorMapEntrySize() {
            return this.colorMapEntrySize;
        }

        public int xOrigin() {
            return this.xOrigin;
        }

        public int yOrigin() {
            return this.yOrigin;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public byte pixelDepth() {
            return this.pixelDepth;
        }

        public byte imageDescriptor() {
            return this.imageDescriptor;
        }

        public byte attribPerPixel() {
            return (byte)(this.imageDescriptor & 0xF);
        }

        public boolean rightToLeft() {
            return (this.imageDescriptor & 0x10) != 0;
        }

        public boolean topToBottom() {
            return (this.imageDescriptor & 0x20) != 0;
        }

        public byte interleave() {
            return (byte)((this.imageDescriptor & 0xC0) >> 6);
        }

        public byte[] imageIDbuf() {
            return this.imageIDbuf;
        }

        public String imageID() {
            return this.imageID;
        }

        public String toString() {
            return "TGA Header  id length: " + this.idLength + " color map type: " + this.colorMapType + " image type: " + this.imageType + " first entry index: " + this.firstEntryIndex + " color map length: " + this.colorMapLength + " color map entry size: " + this.colorMapEntrySize + " x Origin: " + this.xOrigin + " y Origin: " + this.yOrigin + " width: " + this.width + " height: " + this.height + " pixel depth: " + this.pixelDepth + " image descriptor: " + this.imageDescriptor + (this.imageIDbuf == null ? "" : " ID String: " + this.imageID);
        }

        public int size() {
            return 18 + this.idLength;
        }

        private void write(ByteBuffer byteBuffer) {
            byteBuffer.put((byte)this.idLength);
            byteBuffer.put((byte)this.colorMapType);
            byteBuffer.put((byte)this.imageType);
            byteBuffer.putShort((short)this.firstEntryIndex);
            byteBuffer.putShort((short)this.colorMapLength);
            byteBuffer.put(this.colorMapEntrySize);
            byteBuffer.putShort((short)this.xOrigin);
            byteBuffer.putShort((short)this.yOrigin);
            byteBuffer.putShort((short)this.width);
            byteBuffer.putShort((short)this.height);
            byteBuffer.put(this.pixelDepth);
            byteBuffer.put(this.imageDescriptor);
            if (this.idLength > 0) {
                try {
                    byte[] byArray = this.imageID.getBytes("US-ASCII");
                    byteBuffer.put(byArray);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
            }
        }
    }
}

