/*
 * Decompiled with CFR 0.152.
 */
package atktuning;

import fr.esrf.TacoApi.TacoDevice;
import fr.esrf.TacoApi.TacoException;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.ErrorEvent;
import java.awt.Font;
import javax.swing.JOptionPane;

public class Utils {
    private static Utils object = null;

    public static Utils getInstance() {
        if (object == null) {
            object = new Utils();
        }
        return object;
    }

    public ATKException buildATKException(TacoException e, String reason, ErrSeverity severity, String where) {
        DevError[] err = new DevError[]{new DevError(reason, severity, e.getErrorString(), where)};
        DevFailed df = new DevFailed(err);
        return new ATKException(df);
    }

    public AttributeSetException buildAttributeSetException(TacoException e, String reason, ErrSeverity severity, String where) {
        DevError[] err = new DevError[]{new DevError(reason, severity, e.getErrorString(), where)};
        DevFailed df = new DevFailed(err);
        return new AttributeSetException(df);
    }

    public ErrorEvent buildError(String devName, TacoException e, String reason, ErrSeverity severity, String where) {
        devName = "taco:" + devName;
        ATKException ae = this.buildATKException(e, reason, severity, where);
        return new ErrorEvent((Object)devName, (Throwable)ae, System.currentTimeMillis());
    }

    public String getAttributeName(String attName) {
        int idx = attName.lastIndexOf(47);
        if (idx != -1) {
            return attName.substring(idx + 1);
        }
        return "";
    }

    public String getDeviceName(String attName) {
        int idx = attName.lastIndexOf(47);
        if (idx != -1) {
            return attName.substring(0, idx);
        }
        return "";
    }

    public String[] getResource(String resName) throws TacoException {
        TacoDevice ds = new TacoDevice(this.getDeviceName(resName));
        return ds.getResource(this.getAttributeName(resName));
    }

    public Font parseFont(String name) {
        String fName = "Dialog";
        int style = 1;
        int size = 14;
        String[] fields = name.split(",");
        if (fields.length != 3) {
            JOptionPane.showMessageDialog(null, "Invalid font definition\n" + name, "Error", 0);
        } else {
            fName = fields[0];
            style = Integer.parseInt(fields[1]);
            size = Integer.parseInt(fields[2]);
        }
        return new Font(fName, style, size);
    }

    public void printXtuningConf(String tag) throws Exception {
        TacoDevice ds = new TacoDevice("sr/tapp-" + tag + "/config");
        String[] nStr = ds.getResource("NU_OF_PANELS");
        if (nStr == null || nStr.length == 0) {
            System.out.println("No tapp application defined for " + tag);
            return;
        }
        if (nStr[0].isEmpty()) {
            System.out.println("No tapp application defined for " + tag);
            return;
        }
        int nbPanel = Integer.parseInt(nStr[0]);
        for (int i = 0; i < nbPanel; ++i) {
            String pName = "sr/tapp-" + tag + "/panel" + Integer.toString(i + 1);
            System.out.println("#" + this.getResource(pName + "/label")[0]);
            String[] signals = this.getResource(pName + "/signals");
            for (int j = 0; j < signals.length; j += 4) {
                if (signals[j + 2].equalsIgnoreCase("null")) {
                    System.out.println("taco:" + signals[j + 0] + "/" + signals[j + 1]);
                    continue;
                }
                System.out.println("taco:" + signals[j + 0] + "/" + signals[j + 1] + "," + signals[j + 2] + "," + signals[j + 3]);
            }
        }
    }
}

