/*
 * Decompiled with CFR 0.152.
 */
package atktuning;

import atktuning.TuningConfig;
import atktuning.Utils;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarCheckBoxViewer;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.command.CommandMenuViewer;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

class TuningPanel
extends JPanel
implements ActionListener {
    private final JSmoothLabel title;
    private final LabelViewer[] labels;
    private final JComponent[] values;
    private NumberScalarWheelEditor[] setters = null;
    private CommandMenuViewer[] commands;
    private final JButton[] propBtn;
    private JButton[] setBtn = null;
    private int maxLabWidth = 0;
    private int height = 0;
    private final TuningConfig theCfg;
    private final JFrame parentFrame;
    private final boolean showCommand;
    private final boolean showBackground;
    private final boolean showEditor;
    private final boolean showSettingFrameButton;
    private int setterWidth = 0;
    private int setBtnWidth = 0;
    private int rowHeight = 28;
    private static SimplePropertyFrame propFrame = null;
    private static Color uColor = new Color(130, 130, 130);
    private static int viewerWidth = 120;
    private static int titleHeight = 40;
    private static Font titleFont = new Font("Dialog", 1, 18);
    private static Font viewerFont = null;

    public TuningPanel(TuningConfig cfg, int maxH, boolean showCommand, boolean readOnly, boolean showEditor, boolean showBackground, boolean showSettingFrameButton, String fName, JFrame parent) {
        INumberScalar ns;
        IAttribute m;
        int i;
        int nb = cfg.getNbItem();
        this.theCfg = cfg;
        this.showCommand = showCommand;
        this.showBackground = showBackground;
        this.showSettingFrameButton = showSettingFrameButton;
        this.showEditor = showEditor;
        this.parentFrame = parent;
        if (viewerFont == null) {
            viewerFont = Utils.getInstance().parseFont(fName);
        }
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.title = new JSmoothLabel();
        this.title.setFont(titleFont);
        this.title.setBackground(this.getBackground());
        this.title.setHorizontalAlignment(JSmoothLabel.CENTER_ALIGNMENT);
        this.title.setText(this.getConfig().getTitle());
        this.add((Component)this.title);
        this.labels = new LabelViewer[nb];
        for (i = 0; i < nb; ++i) {
            this.labels[i] = new LabelViewer();
            m = cfg.getAtt(i);
            this.labels[i].setModel(m);
            this.labels[i].setBackground(this.getBackground());
            this.labels[i].setHorizontalAlignment(JSmoothLabel.RIGHT_ALIGNMENT);
            this.labels[i].setFont(viewerFont);
            Dimension d = this.labels[i].getPreferredSize();
            if (d.width > this.maxLabWidth) {
                this.maxLabWidth = d.width;
            }
            this.add((Component)this.labels[i]);
        }
        if (showEditor) {
            this.setters = new NumberScalarWheelEditor[nb];
            for (i = 0; i < nb; ++i) {
                m = cfg.getAtt(i);
                if (m.isWritable() && m instanceof INumberScalar) {
                    ns = (INumberScalar)m;
                    this.setters[i] = new NumberScalarWheelEditor();
                    this.setters[i].setBackground(this.getBackground());
                    this.setters[i].setFont(viewerFont);
                    this.setters[i].setModel(ns);
                    if (readOnly) {
                        this.setters[i].setEnabled(false);
                    }
                    this.add((Component)this.setters[i]);
                    continue;
                }
                this.setters[i] = null;
            }
        }
        if (showSettingFrameButton) {
            this.setBtn = new JButton[nb];
            for (i = 0; i < nb; ++i) {
                m = cfg.getAtt(i);
                if (m.isWritable() && m instanceof INumberScalar) {
                    this.setBtn[i] = new JButton("...");
                    this.setBtn[i].addActionListener(this);
                    if (readOnly) {
                        this.setBtn[i].setEnabled(false);
                    }
                    this.add(this.setBtn[i]);
                    continue;
                }
                this.setBtn[i] = null;
            }
        }
        this.values = new JComponent[nb];
        for (i = 0; i < nb; ++i) {
            SimpleScalarViewer v;
            m = cfg.getAtt(i);
            if (m instanceof INumberScalar) {
                ns = (INumberScalar)m;
                v = new SimpleScalarViewer();
                v.setHorizontalAlignment(JAutoScrolledText.RIGHT_ALIGNMENT);
                v.setMargin(new Insets(0, 0, 0, 10));
                if (!showBackground) {
                    v.setBackgroundColor(this.getBackground());
                }
                v.setFont(viewerFont);
                v.setBorder(BorderFactory.createLoweredBevelBorder());
                v.setModel(ns);
                v.setBackground(uColor);
                v.setText("------");
                v.setEditable(readOnly);
                this.values[i] = v;
            }
            if (m instanceof IBooleanScalar) {
                IBooleanScalar bs = (IBooleanScalar)m;
                v = new BooleanScalarCheckBoxViewer();
                v.setAttModel(bs);
                v.setTrueLabel("");
                v.setFalseLabel("");
                this.values[i] = v;
            }
            this.add(this.values[i]);
        }
        if (showCommand) {
            this.commands = new CommandMenuViewer[nb];
            for (i = 0; i < nb; ++i) {
                this.commands[i] = new CommandMenuViewer();
                this.commands[i].setMenuTitle(" V");
                this.commands[i].setBackground(this.getBackground());
                if (cfg.hasCommand(i)) {
                    this.commands[i].setModel(cfg.getCmds(i));
                }
                this.add((Component)this.commands[i]);
            }
        }
        this.propBtn = new JButton[nb];
        for (i = 0; i < nb; ++i) {
            this.propBtn[i] = new JButton();
            this.propBtn[i].setFont(viewerFont);
            this.propBtn[i].setText("?");
            this.propBtn[i].setMargin(new Insets(0, 0, 0, 0));
            this.propBtn[i].addActionListener(this);
            this.add(this.propBtn[i]);
        }
        this.computeMaxWidth();
        this.height = maxH * this.rowHeight + titleHeight;
        this.placeComponents();
    }

    private void placeComponents() {
        int nb = this.theCfg.getNbItem();
        int compH = this.rowHeight - 1;
        if (this.showCommand) {
            this.title.setBounds(2, 2, 66 + viewerWidth + this.setterWidth + this.setBtnWidth + this.maxLabWidth, titleHeight - 2);
        } else {
            this.title.setBounds(2, 2, 36 + viewerWidth + this.setterWidth + this.setBtnWidth + this.maxLabWidth, titleHeight - 2);
        }
        for (int i = 0; i < nb; ++i) {
            int y = titleHeight + i * this.rowHeight;
            int xl = this.maxLabWidth + this.setterWidth + viewerWidth + this.setBtnWidth;
            this.labels[i].setBounds(2, y, this.maxLabWidth, compH);
            this.values[i].setBounds(this.maxLabWidth + 4, y + 1, viewerWidth, compH);
            if (this.showEditor && this.setters[i] != null) {
                this.setters[i].setBounds(this.maxLabWidth + 4 + viewerWidth, y + 1, this.setterWidth, compH);
            }
            if (this.showSettingFrameButton && this.setBtn[i] != null) {
                this.setBtn[i].setBounds(this.maxLabWidth + viewerWidth + this.setterWidth + 6, y + 1, this.setBtnWidth, compH);
            }
            if (this.showCommand) {
                this.commands[i].setBounds(xl + 7, y + 1, 30, compH);
                this.propBtn[i].setBounds(xl + 37, y + 1, 30, compH);
                continue;
            }
            this.propBtn[i].setBounds(xl + 7, y + 1, 30, compH);
        }
    }

    private void computeMaxWidth() {
        int nb = this.theCfg.getNbItem();
        this.maxLabWidth = 0;
        this.setterWidth = 0;
        this.setBtnWidth = 0;
        this.rowHeight = 28;
        for (int i = 0; i < nb; ++i) {
            Dimension d = this.labels[i].getPreferredSize();
            if (d.width > this.maxLabWidth) {
                this.maxLabWidth = d.width;
            }
            if (this.showEditor && this.setters[i] != null) {
                this.setterWidth = Math.max(this.setters[i].getPreferredSize().width, this.setterWidth);
                this.rowHeight = 35;
            }
            if (!this.showSettingFrameButton || this.setBtn[i] == null) continue;
            this.setBtnWidth = 30;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i = 0;
        boolean found = false;
        while (i < this.theCfg.getNbItem() && !found) {
            found = this.propBtn[i].equals(e.getSource());
            if (found) continue;
            ++i;
        }
        if (found) {
            if (propFrame == null) {
                propFrame = new SimplePropertyFrame(this.parentFrame, true);
            }
            propFrame.setModel(this.theCfg.getAtt(i));
            propFrame.setVisible(true);
            return;
        }
        i = 0;
        found = false;
        while (i < this.theCfg.getNbItem() && !found) {
            found = this.setBtn[i] != null && this.setBtn[i].equals(e.getSource());
            if (found) continue;
            ++i;
        }
        if (found) {
            if (this.theCfg.getSetFrame(i) == null) {
                this.theCfg.createSettingFrame(i, this.title.getText(), (INumberScalar)this.theCfg.getAtt(i), this.showBackground);
            }
            ATKGraphicsUtils.centerFrameOnScreen((Frame)this.theCfg.getSetFrame(i));
            this.theCfg.getSetFrame(i).setVisible(true);
            return;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.showCommand) {
            return new Dimension(70 + viewerWidth + this.setterWidth + this.setBtnWidth + this.maxLabWidth, this.height + 2);
        }
        return new Dimension(42 + viewerWidth + this.setterWidth + this.setBtnWidth + this.maxLabWidth, this.height + 2);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public TuningConfig getConfig() {
        return this.theCfg;
    }

    public void clearModel() {
        for (int i = 0; i < this.theCfg.getNbItem(); ++i) {
            this.labels[i].clearModel();
            this.theCfg.clearSetFrame(i);
            if (this.values[i] instanceof SimpleScalarViewer) {
                ((SimpleScalarViewer)this.values[i]).clearModel();
            } else if (this.values[i] instanceof BooleanScalarCheckBoxViewer) {
                ((BooleanScalarCheckBoxViewer)this.values[i]).clearModel();
            }
            if (!this.showCommand) continue;
            this.commands[i].setModel((CommandList)null);
        }
        if (propFrame != null) {
            propFrame.setModel(null);
            propFrame.setVisible(false);
            propFrame.dispose();
            propFrame = null;
        }
    }
}

