/*
 * Decompiled with CFR 0.152.
 */
package atktuning;

import atktuning.AttPanel;
import atktuning.SettingFrame;
import atktuning.Taco.TacoDeviceFactory;
import atktuning.Taco.TacoNumberScalar;
import atktuning.TuningCmdList;
import atktuning.Utils;
import fr.esrf.TacoApi.TacoException;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import fr.esrf.tangoatk.widget.util.Splash;

public class TuningConfig {
    private AttributeList attList;
    private TuningCmdList[] cmdList = null;
    private String title;
    private int startIndex;
    private int nbItem = 0;
    private SettingFrame[] setFrames;

    public TuningConfig(ErrorHistory errWin, AttPanel panel, Splash splashScreen, AttributeList globalList, boolean showCommand, int currentPanel, int nbPanel) {
        double prg;
        int i;
        this.attList = globalList;
        this.startIndex = this.attList.size();
        String splashMsg = splashScreen.getMessage();
        double totalP = panel.getSize();
        double idx = 0.0;
        if (showCommand) {
            totalP += (double)panel.getSize();
        }
        this.title = panel.title;
        for (i = 0; i < panel.getSize(); ++i) {
            splashScreen.setMessage(splashMsg + panel.get((int)i).attName);
            try {
                if (panel.get((int)i).isTaco) {
                    this.addTacoAttribute(errWin, panel.get((int)i).attName, panel.get((int)i).setCommand, panel.get((int)i).setName);
                } else {
                    this.attList.add(panel.get((int)i).attName);
                }
            }
            catch (ConnectionException e) {
                System.out.println(e.getDescription());
            }
            prg = ((double)currentPanel + idx / totalP) / (double)nbPanel;
            splashScreen.progress((int)(prg * 100.0));
            idx += 1.0;
        }
        this.nbItem = this.attList.size() - this.startIndex;
        this.setFrames = new SettingFrame[this.nbItem];
        for (i = 0; i < this.nbItem; ++i) {
            this.setFrames[i] = null;
        }
        if (showCommand) {
            this.cmdList = new TuningCmdList[this.nbItem];
            for (i = 0; i < this.nbItem; ++i) {
                if (!panel.get((int)i).isTaco) {
                    String devName = this.getAtt(i).getDeviceName();
                    splashScreen.setMessage(splashMsg + devName);
                    TuningCmdList newList = TuningCmdList.findList(this.cmdList, i, devName);
                    if (newList == null) {
                        this.cmdList[i] = new TuningCmdList();
                        this.cmdList[i].addErrorListener((IErrorListener)ErrorPopup.getInstance());
                        this.cmdList[i].setModel(devName);
                    } else {
                        this.cmdList[i] = newList;
                    }
                } else {
                    this.cmdList[i] = null;
                }
                prg = ((double)currentPanel + idx / totalP) / (double)nbPanel;
                splashScreen.progress((int)(prg * 100.0));
                idx += 1.0;
            }
        }
    }

    private void addTacoAttribute(ErrorHistory errWin, String attName, String setCommand, String setName) {
        try {
            TacoNumberScalar tacoAtt = TacoDeviceFactory.getInstance().getTacoAttribute(attName, setCommand, setName);
            this.attList.add((IEntity)tacoAtt);
        }
        catch (Exception e) {
            String srcName = Utils.getInstance().getDeviceName(attName);
            errWin.setErrorOccured(Utils.getInstance().buildError(srcName, (TacoException)((Object)e), "TacoImportFail", ErrSeverity.PANIC, "TuningConfig()"));
        }
    }

    public void clearSetFrame(int index) {
        if (this.setFrames[index] != null) {
            this.setFrames[index].setVisible(false);
            this.setFrames[index].clearModel();
            this.setFrames[index].dispose();
        }
        this.setFrames[index] = null;
    }

    public void createSettingFrame(int index, String title, INumberScalar model, boolean showBackground) {
        this.setFrames[index] = new SettingFrame(title, model, showBackground);
    }

    public SettingFrame getSetFrame(int index) {
        return this.setFrames[index];
    }

    public int getNbItem() {
        return this.nbItem;
    }

    public String getTitle() {
        return this.title;
    }

    public IAttribute getAtt(int index) {
        return (IAttribute)this.attList.get(this.startIndex + index);
    }

    public boolean hasCommand(int index) {
        return this.cmdList != null && this.cmdList[index] != null;
    }

    public CommandList getCmds(int index) {
        return this.cmdList[index];
    }
}

