/*
 * Decompiled with CFR 0.152.
 */
package atktuning.Taco;

import atktuning.Taco.TacoSignal;
import atktuning.Utils;
import fr.esrf.TacoApi.TacoDevice;
import fr.esrf.TacoApi.TacoException;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DispLevel;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AtkEventListenerList;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeStateListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarHistory;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.IScalarAttribute;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.PropertyStorage;
import fr.esrf.tangoatk.core.attribute.NumberScalar;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.util.Map;

public class TacoNumberScalar
extends NumberScalar {
    TacoSignal tacoSignal;

    public TacoNumberScalar(TacoSignal signal) {
        this.tacoSignal = signal;
        this.propertyStorage = new PropertyStorage();
        this.updateConfiguration();
    }

    public void updateConfiguration() {
        this.propertyStorage.setProperty((IEntity)this, "unit", this.tacoSignal.unit, true);
        this.propertyStorage.setProperty((IEntity)this, "data_format", (Number)0, true);
        this.propertyStorage.setProperty((IEntity)this, "format", this.tacoSignal.format, true);
        this.propertyStorage.setProperty((IEntity)this, "data_type", (Number)new Integer(5), true);
        this.propertyStorage.setProperty((IEntity)this, "description", this.tacoSignal.desc, true);
        this.propertyStorage.setProperty((IEntity)this, "label", this.tacoSignal.label, true);
        if (this.tacoSignal.isWritable()) {
            this.propertyStorage.setProperty((IAttribute)this, "writable", AttrWriteType.READ_WRITE, true);
        } else {
            this.propertyStorage.setProperty((IAttribute)this, "writable", AttrWriteType.READ, true);
        }
        this.propertyStorage.setProperty((IEntity)this, "writable_attr_name", "", false);
        this.propertyStorage.getProperty("writable_attr_name").setSpecified(false);
        this.propertyStorage.setProperty((IEntity)this, "display_unit", (Number)new Double(1.0), false);
        this.propertyStorage.setProperty((IEntity)this, "max_dim_x", (Number)new Integer(1), true);
        this.propertyStorage.setProperty((IEntity)this, "max_dim_y", (Number)new Integer(1), true);
        this.propertyStorage.setProperty((IEntity)this, "level", DispLevel.OPERATOR, true);
        this.propertyStorage.setProperty((IEntity)this, "standard_unit", (Number)new Double(1.0), false);
        this.propertyStorage.setProperty((IEntity)this, "min_value", (Number)new Double(this.tacoSignal.min), true);
        this.propertyStorage.setProperty((IEntity)this, "max_value", (Number)new Double(this.tacoSignal.max), true);
        this.propertyStorage.setProperty((IEntity)this, "min_alarm", (Number)new Double(this.tacoSignal.alLow), true);
        this.propertyStorage.setProperty((IEntity)this, "max_alarm", (Number)new Double(this.tacoSignal.alHigh), true);
        this.propertyStorage.setProperty((IEntity)this, "min_warning", (Number)new Double(Double.NaN), true);
        this.propertyStorage.setProperty((IEntity)this, "max_warning", (Number)new Double(Double.NaN), true);
        this.propertyStorage.setProperty((IEntity)this, "delta_t", (Number)new Double(Double.NaN), true);
        this.propertyStorage.setProperty((IEntity)this, "delta_val", (Number)new Double(Double.NaN), true);
        this.propertyStorage.refreshProperties();
    }

    public Number getNumber() {
        return this.tacoSignal.getValue();
    }

    public void setNumber(Number number) {
        double v = number.doubleValue();
        this.setValue(v);
    }

    public void addNumberScalarListener(INumberScalarListener l) {
        this.propChanges.addNumberScalarListener(l);
        this.addStateListener((IAttributeStateListener)l);
    }

    public void removeNumberScalarListener(INumberScalarListener l) {
        this.propChanges.removeNumberScalarListener(l);
        this.removeStateListener((IAttributeStateListener)l);
    }

    public double getNumberScalarValue() {
        return this.getNumber().doubleValue();
    }

    public double getNumberScalarDeviceValue() {
        return this.getNumberScalarValue();
    }

    public double getNumberScalarStandardValue() {
        return this.getNumberScalarValue();
    }

    public double getNumberScalarSetPoint() {
        if (this.tacoSignal.hasWriteValue()) {
            return this.tacoSignal.getSetValue();
        }
        return Double.NaN;
    }

    public double getNumberScalarDeviceSetPoint() {
        return this.getNumberScalarSetPoint();
    }

    public double getNumberScalarStandardSetPoint() {
        return this.getNumberScalarSetPoint();
    }

    public double getNumberScalarSetPointFromDevice() {
        return this.getNumberScalarSetPoint();
    }

    public void setValue(double v) {
        try {
            this.tacoSignal.setValue(v);
        }
        catch (TacoException e) {
            this.propChanges.fireSetErrorEvent((Object)this, (Throwable)Utils.getInstance().buildAttributeSetException(e, "TacoCmdFailed", ErrSeverity.ERR, "TacoNumberScalar.setValue()"));
        }
    }

    public INumberScalarHistory[] getNumberScalarHistory() {
        return new INumberScalarHistory[0];
    }

    public INumberScalarHistory[] getNumberScalarDeviceHistory() {
        return new INumberScalarHistory[0];
    }

    public void setPossibleValues(double[] doubles) {
    }

    public double[] getPossibleValues() {
        return new double[0];
    }

    public IScalarAttribute getWritableAttribute() {
        return null;
    }

    public IScalarAttribute getReadableAttribute() {
        return null;
    }

    public String getState() {
        return "VALID";
    }

    public String getType() {
        return "DoubleScalar";
    }

    public boolean isWritable() {
        return this.tacoSignal.isWritable();
    }

    public void dispatch(DeviceAttribute deviceAttribute) {
    }

    public void dispatchError(DevFailed devFailed) {
    }

    public void addStateListener(IAttributeStateListener l) {
        this.propChanges.addAttributeStateListener(l);
    }

    public void removeStateListener(IAttributeStateListener l) {
        this.propChanges.removeAttributeStateListener(l);
    }

    public void addSetErrorListener(ISetErrorListener l) {
        this.propChanges.addSetErrorListener(l);
    }

    public void removeSetErrorListener(ISetErrorListener l) {
        this.propChanges.removeSetErrorListener(l);
    }

    public int getMaxXDimension() {
        return 1;
    }

    public int getMaxYDimension() {
        return 1;
    }

    public int getXDimension() {
        return 1;
    }

    public int getYDimension() {
        return 1;
    }

    public int getHeight() {
        return 1;
    }

    public int getWidth() {
        return 1;
    }

    public boolean hasEvents() {
        return false;
    }

    public boolean areAttPropertiesLoaded() {
        return false;
    }

    public void loadAttProperties() {
    }

    public String getName() {
        return this.tacoSignal.getFullName();
    }

    public String getNameSansDevice() {
        return this.tacoSignal.sigName;
    }

    public Property getProperty(String name) {
        return this.propertyStorage.getProperty(name);
    }

    public Map getPropertyMap() {
        return this.propertyStorage.getPropertyMap();
    }

    public void addErrorListener(IErrorListener l) {
        this.propChanges.addErrorListener(l);
    }

    public void removeErrorListener(IErrorListener l) {
        this.propChanges.removeErrorListener(l);
    }

    public Device getDevice() {
        return null;
    }

    private void updateNumberRes(TacoSignal sig, String resName, double resValue, double oldValue) {
        TacoDevice ds = sig.device.ds;
        try {
            if (Double.isNaN(resValue)) {
                ds.delResource(sig.sigName + resName);
            } else if (resValue != oldValue) {
                ds.putResource(sig.sigName + resName, new String[]{Double.toString(resValue)});
            }
        }
        catch (TacoException e) {
            ATKException ae = Utils.getInstance().buildATKException(e, "TacoPutResourceFail", ErrSeverity.ERR, "TacoNumberScalar.storeConfig()");
            ErrorPane.showErrorMessage(null, (String)ds.getName(), (ATKException)ae);
        }
    }

    private void updateRes(TacoSignal sig, String resName, String resValue, String oldValue) {
        TacoDevice ds = sig.device.ds;
        if (!resValue.equals(oldValue)) {
            try {
                if (resValue.isEmpty() || resValue.equalsIgnoreCase("Not specified")) {
                    ds.delResource(sig.sigName + resName);
                } else {
                    ds.putResource(sig.sigName + resName, new String[]{resValue});
                }
            }
            catch (TacoException e) {
                ATKException ae = Utils.getInstance().buildATKException(e, "TacoPutResourceFail", ErrSeverity.ERR, "TacoNumberScalar.storeConfig()");
                ErrorPane.showErrorMessage(null, (String)ds.getName(), (ATKException)ae);
            }
        }
    }

    public void storeConfig() {
        this.updateRes(this.tacoSignal, ".label", this.getLabel(), this.tacoSignal.label);
        this.tacoSignal.label = this.getLabel();
        this.updateRes(this.tacoSignal, ".unit", this.getUnit(), this.tacoSignal.unit);
        this.tacoSignal.unit = this.getUnit();
        this.updateRes(this.tacoSignal, ".format", this.getFormat(), this.tacoSignal.format);
        this.tacoSignal.format = this.getFormat();
        this.updateNumberRes(this.tacoSignal, ".alhigh", this.getMaxAlarm(), this.tacoSignal.alHigh);
        this.tacoSignal.alHigh = this.getMaxAlarm();
        this.updateNumberRes(this.tacoSignal, ".allow", this.getMinAlarm(), this.tacoSignal.alLow);
        this.tacoSignal.alLow = this.getMinAlarm();
        if (this.tacoSignal.hasWriteValue()) {
            this.updateNumberRes(this.tacoSignal, ".max", this.getMaxValue(), this.tacoSignal.max);
            this.tacoSignal.max = this.getMaxValue();
            this.updateNumberRes(this.tacoSignal.setSignal, ".max", this.getMaxValue(), this.tacoSignal.setSignal.max);
            this.tacoSignal.setSignal.max = this.getMaxValue();
        }
        if (this.tacoSignal.hasWriteValue()) {
            this.updateNumberRes(this.tacoSignal, ".min", this.getMinValue(), this.tacoSignal.min);
            this.tacoSignal.min = this.getMinValue();
            this.updateNumberRes(this.tacoSignal.setSignal, ".min", this.getMinValue(), this.tacoSignal.setSignal.min);
            this.tacoSignal.setSignal.min = this.getMinValue();
        }
        try {
            this.tacoSignal.device.updateSigConfig();
        }
        catch (TacoException e) {
            ATKException ae = Utils.getInstance().buildATKException(e, "TacoUpdateSigConfigFail", ErrSeverity.ERR, "TacoNumberScalar.storeConfig()");
            ErrorPane.showErrorMessage(null, (String)this.tacoSignal.device.getName(), (ATKException)ae);
        }
    }

    public void setAlias(String s) {
    }

    public String getAlias() {
        return "";
    }

    public boolean isOperator() {
        return true;
    }

    public boolean isExpert() {
        return false;
    }

    public AtkEventListenerList getListenerList() {
        return this.propChanges.getListenerList();
    }

    public void refresh() {
        ++this.refreshCount;
        try {
            double value = this.tacoSignal.getValue();
            if (Double.isNaN(value)) {
                this.setState("INVALID");
            } else if (value == 65536.0) {
                value = Double.NaN;
                this.setState("INVALID");
            } else {
                this.setState("VALID");
            }
            this.propChanges.fireNumberScalarEvent((INumberScalar)this, value, System.currentTimeMillis());
        }
        catch (Exception e) {
            System.out.println("TacoNumberScalar.refresh() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("TacoNumberScalar.refresh()------------------------------------------------");
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
    }
}

