/*
 * Decompiled with CFR 0.152.
 */
package atktuning.Taco;

import atktuning.Taco.MyTacoDevice;
import atktuning.Taco.TacoNumberScalar;
import atktuning.Taco.TacoSignal;
import atktuning.Utils;
import fr.esrf.TacoApi.TacoException;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import java.util.Vector;

public class TacoDeviceFactory {
    private static TacoDeviceFactory factory = null;
    private Vector<MyTacoDevice> ds = new Vector();
    private long refreshInterval = 2000L;
    private boolean isRefresherRunning = false;
    private Thread refresher = null;
    private ErrorHistory errWin = null;

    private TacoDeviceFactory() {
    }

    public static TacoDeviceFactory getInstance() {
        if (factory == null) {
            factory = new TacoDeviceFactory();
        }
        return factory;
    }

    private int getDeviceIndex(String name) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.ds.size()) {
            found = this.ds.get(i).getName().equalsIgnoreCase(name);
            if (found) continue;
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public MyTacoDevice getDevice(String devName) throws TacoException {
        int idx = this.getDeviceIndex(devName);
        if (idx < 0) {
            MyTacoDevice d = new MyTacoDevice(devName);
            this.ds.add(d);
            return d;
        }
        return this.ds.get(idx);
    }

    public int getDeviceNumber() {
        return this.ds.size();
    }

    public TacoNumberScalar getTacoAttribute(String attName) throws TacoException {
        return this.getTacoAttribute(attName, null, null);
    }

    public TacoNumberScalar getTacoAttribute(String attName, String setCommand, String setAttName) throws TacoException {
        String devName = Utils.getInstance().getDeviceName(attName);
        MyTacoDevice ds = TacoDeviceFactory.getInstance().getDevice(devName);
        String att = Utils.getInstance().getAttributeName(attName);
        TacoSignal sig = ds.getSignal(att);
        sig.setCommandName = setCommand;
        if (setAttName != null) {
            sig.setSignal = ds.getSignal(setAttName);
        }
        return new TacoNumberScalar(sig);
    }

    public void setErrorWin(ErrorHistory w) {
        this.errWin = w;
    }

    public void setRefreshInterval(long ms) {
        this.refreshInterval = ms;
    }

    public void stopRefresher() {
        if (this.isRefresherRunning) {
            this.isRefresherRunning = false;
            try {
                this.refresher.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.refresher = null;
        }
    }

    public void startRefresher() {
        if (this.isRefresherRunning) {
            return;
        }
        this.isRefresherRunning = true;
        this.refresher = new Thread(new Runnable(){

            @Override
            public void run() {
                while (TacoDeviceFactory.this.isRefresherRunning) {
                    long t0 = System.currentTimeMillis();
                    try {
                        for (int i = 0; i < TacoDeviceFactory.this.ds.size() && TacoDeviceFactory.this.isRefresherRunning; ++i) {
                            MyTacoDevice d = (MyTacoDevice)TacoDeviceFactory.this.ds.get(i);
                            try {
                                d.refreshValues();
                                continue;
                            }
                            catch (TacoException e) {
                                d.clearValues();
                                TacoDeviceFactory.this.errWin.setErrorOccured(Utils.getInstance().buildError(d.getName(), e, "TacoReadFail", ErrSeverity.ERR, "TacoDevice.refreshValues()"));
                            }
                        }
                    }
                    catch (Exception e2) {
                        System.out.println("TacoDeviceFactory.refresher(): Unexpected exception : " + e2.getMessage());
                    }
                    long t1 = System.currentTimeMillis();
                    long toSleep = TacoDeviceFactory.this.refreshInterval - (t1 - t0);
                    if (toSleep <= 0L) continue;
                    try {
                        Thread.sleep(toSleep);
                    }
                    catch (InterruptedException e) {}
                }
            }
        });
        this.refresher.start();
    }
}

