/*
 * Decompiled with CFR 0.152.
 */
package atktuning.Taco;

import atktuning.Taco.TacoSignal;
import fr.esrf.TacoApi.TacoCommand;
import fr.esrf.TacoApi.TacoData;
import fr.esrf.TacoApi.TacoDevice;
import fr.esrf.TacoApi.TacoException;
import java.util.Vector;

public class MyTacoDevice {
    TacoDevice ds;
    TacoDevice dsClass;
    String deviceClass;
    Vector<TacoSignal> signalList;
    double[] values;

    MyTacoDevice(String devName) throws TacoException {
        this.ds = new TacoDevice(devName);
        this.ds.setSource(0);
        this.deviceClass = this.ds.getDeviceClass();
        this.dsClass = new TacoDevice("CLASS/" + this.deviceClass + "/DEFAULT");
        String[] signals = this.dsClass.getResource("signal_names");
        if (signals == null || signals.length == 0) {
            signals = this.ds.getResource("signal_names");
        }
        this.signalList = new Vector();
        int i = 0;
        while (i < signals.length) {
            TacoSignal s = new TacoSignal();
            s.sigName = signals[i];
            s.label = this.getSignalProperty(signals[i], "label");
            s.unit = this.getSignalProperty(signals[i], "unit");
            s.format = this.getSignalProperty(signals[i], "format");
            s.desc = this.getSignalProperty(signals[i], "descr");
            s.min = this.getNumberSignalProperty(signals[i], "min");
            s.max = this.getNumberSignalProperty(signals[i], "max");
            s.alLow = this.getNumberSignalProperty(signals[i], "allow");
            s.alHigh = this.getNumberSignalProperty(signals[i], "alhigh");
            s.device = this;
            s.idx = i++;
            this.signalList.add(s);
        }
        this.values = new double[signals.length];
        this.clearValues();
    }

    public double getValue(int idx) {
        return this.values[idx];
    }

    public void updateSigConfig() throws TacoException {
        this.ds.command(199);
    }

    public TacoSignal getSignal(String sigName) throws TacoException {
        int i = 0;
        boolean found = false;
        while (!found && i < this.signalList.size()) {
            found = this.signalList.get((int)i).sigName.equalsIgnoreCase(sigName);
            if (found) continue;
            ++i;
        }
        if (found) {
            return this.signalList.get(i);
        }
        for (i = 0; i < this.signalList.size(); ++i) {
            System.out.println(this.signalList.get((int)i).sigName);
        }
        throw new TacoException(sigName + " signal not found");
    }

    public TacoCommand getCommand(String cmdName) throws TacoException {
        TacoCommand[] cmds = this.ds.commandQuery();
        int i = 0;
        boolean found = false;
        while (!found && i < cmds.length) {
            found = cmds[i].cmdName.equalsIgnoreCase(cmdName);
            if (found) continue;
            ++i;
        }
        if (found) {
            return cmds[i];
        }
        throw new TacoException(cmdName + " command not found");
    }

    public void clearValues() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Double.NaN;
        }
    }

    public void refreshValues() throws TacoException {
        TacoData data = this.ds.get(239);
        switch (data.getType()) {
            case 12: {
                float[] fvals = data.extractFloatArray();
                for (int i = 0; i < this.values.length && i < fvals.length; ++i) {
                    this.values[i] = fvals[i];
                }
                break;
            }
            case 68: {
                double[] dvals = data.extractDoubleArray();
                for (int i = 0; i < this.values.length && i < dvals.length; ++i) {
                    this.values[i] = dvals[i];
                }
                break;
            }
        }
    }

    public String getName() {
        return this.ds.getName();
    }

    private Double getNumberSignalProperty(String signalName, String propName) throws TacoException {
        String r = this.getSignalProperty(signalName, propName);
        double d = Double.NaN;
        try {
            d = Double.parseDouble(r);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return d;
    }

    private String getSignalProperty(String signalName, String propName) throws TacoException {
        String propNameFull = signalName + "." + propName;
        String[] res = this.ds.getResource(propNameFull);
        if (res == null || res.length == 0 || res[0].length() == 0) {
            res = this.dsClass.getResource(propNameFull);
        }
        if (res == null) {
            return "";
        }
        String ret = "";
        for (int i = 0; i < res.length; ++i) {
            ret = ret + res[i];
            if (i >= res.length - 1) continue;
            ret = ret + " ";
        }
        return ret;
    }
}

