/*
 * Decompiled with CFR 0.152.
 */
package atktuning;

import atktuning.AttItem;
import atktuning.AttPanel;
import atktuning.Taco.TacoDeviceFactory;
import atktuning.TuningConfig;
import atktuning.TuningPanel;
import atktuning.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MainPanel
extends JFrame {
    static final int MAX_WIDTH = 1400;
    private JPanel thePanel;
    private JScrollPane theView;
    private JMenuBar mainMenu;
    private int nbPanel = 0;
    private TuningPanel[] panels;
    private boolean runFromShell = false;
    private boolean showCommand = false;
    private boolean showSetter = false;
    private boolean showBackground = false;
    private boolean showSettingFrameButton = false;
    private boolean readOnly = false;
    private String fName = "Dialog,1,14";
    private ErrorHistory errWin;
    private final String appVersion = "ATKTuning " + MainPanel.getVersion();
    private Splash splashScreen = null;
    public AttributePolledList attList = null;
    private TacoDeviceFactory TacoFactory;

    public MainPanel(String filename) {
        this(filename, false);
    }

    public MainPanel(String filename, boolean runningFromShell) {
        this(filename, runningFromShell, true);
    }

    public MainPanel(String filename, boolean runningFromShell, boolean showCommand) {
        this(filename, runningFromShell, true, false);
    }

    public MainPanel(String filename, boolean runningFromShell, boolean showCommand, boolean readOnly) {
        this.runFromShell = runningFromShell;
        this.showCommand = showCommand;
        this.readOnly = readOnly;
        this.initComponents(filename);
    }

    public MainPanel(String filename, boolean runningFromShell, boolean showCommand, boolean readOnly, boolean showSetter) {
        this.runFromShell = runningFromShell;
        this.showCommand = showCommand;
        this.readOnly = readOnly;
        this.showSetter = showSetter;
        this.initComponents(filename);
    }

    public MainPanel(String filename, boolean runningFromShell, boolean showCommand, boolean readOnly, boolean showSetter, String fName, boolean showBackground, boolean showSettingFrameButton) {
        this.runFromShell = runningFromShell;
        this.showCommand = showCommand;
        this.readOnly = readOnly;
        this.showSetter = showSetter;
        if (fName != null) {
            this.fName = fName;
        }
        this.showBackground = showBackground;
        this.showSettingFrameButton = showSettingFrameButton;
        this.initComponents(filename);
    }

    private void initComponents(String filename) {
        int i;
        this.errWin = new ErrorHistory();
        this.TacoFactory = TacoDeviceFactory.getInstance();
        this.TacoFactory.setErrorWin(this.errWin);
        this.splashScreen = new Splash();
        this.splashScreen.setTitle(this.appVersion);
        this.splashScreen.setMessage("Reading " + filename + "...");
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.setTitle(this.appVersion + " [" + filename + "]");
        AttPanel[] list = this.readConfigFile(filename);
        if (list == null) {
            return;
        }
        this.nbPanel = list.length;
        this.thePanel = new JPanel();
        this.thePanel.setBackground(this.getBackground());
        this.thePanel.setLayout(new GridBagLayout());
        this.thePanel.setBorder(null);
        int maxRows = 0;
        for (i = 0; i < this.nbPanel; ++i) {
            if (list[i].getSize() <= maxRows) continue;
            maxRows = list[i].getSize();
        }
        this.attList = new AttributePolledList();
        this.attList.setForceRefresh(true);
        this.attList.addErrorListener((IErrorListener)this.errWin);
        this.attList.addSetErrorListener((ISetErrorListener)ErrorPopup.getInstance());
        IEntityFilter attfilter = new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof INumberScalar || entity instanceof IBooleanScalar) {
                    return true;
                }
                System.out.println(entity.getName() + " not supported.");
                return false;
            }
        };
        this.attList.setFilter(attfilter);
        int totalWidth = 0;
        boolean cropped = false;
        this.panels = new TuningPanel[this.nbPanel];
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridy = 0;
        for (i = 0; i < this.nbPanel; ++i) {
            this.splashScreen.setMessage("Panel " + (i + 1) + "/" + this.nbPanel + ":");
            TuningConfig cfg = new TuningConfig(this.errWin, list[i], this.splashScreen, (AttributeList)this.attList, this.showCommand, i, this.nbPanel);
            this.panels[i] = new TuningPanel(cfg, maxRows, this.showCommand, this.readOnly, this.showSetter, this.showBackground, this.showSettingFrameButton, this.fName, this);
            int pWidth = this.panels[i].getPreferredSize().width;
            if (!cropped && totalWidth + pWidth < 1400) {
                totalWidth += pWidth;
            } else {
                cropped = true;
            }
            gbc.gridx = i;
            this.thePanel.add((Component)this.panels[i], gbc);
        }
        this.attList.setRefreshInterval(2000);
        if (this.TacoFactory.getDeviceNumber() > 0) {
            this.TacoFactory.setRefreshInterval(2000L);
        }
        this.attList.startRefresher();
        if (this.runFromShell) {
            DeviceFactory.getInstance().stopRefresher();
        }
        this.splashScreen.progress(100);
        if (this.TacoFactory.getDeviceNumber() > 0) {
            MainPanel mainPanel = this;
            mainPanel.TacoFactory.getInstance().startRefresher();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.mainMenu = new JMenuBar();
        JMenu jMenu1 = new JMenu();
        JMenu jMenu2 = new JMenu();
        JMenu jMenu3 = new JMenu();
        JMenuItem jMenuItem1 = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        JMenuItem jMenuItem3 = new JMenuItem();
        jMenu1.setText("File");
        jMenu2.setText("Options");
        jMenu3.setText("Trends");
        jMenuItem1.setText("Exit");
        jMenuItem2.setText("Set refresh interval");
        jMenuItem3.setText("View errors");
        JMenuItem jTrendMenuItem = new JMenuItem();
        jTrendMenuItem.setText("Show trends");
        jTrendMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.showTrendAll();
            }
        });
        jMenu3.add(jTrendMenuItem);
        jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.exitForm();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.setRefreshInterval();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ATKGraphicsUtils.centerFrameOnScreen((Frame)MainPanel.this.errWin);
                MainPanel.this.errWin.setVisible(true);
            }
        });
        jMenu1.add(jMenuItem1);
        jMenu2.add(jMenuItem2);
        jMenu2.add(jMenuItem3);
        this.mainMenu.add(jMenu1);
        this.mainMenu.add(jMenu2);
        this.mainMenu.add(jMenu3);
        this.setJMenuBar(this.mainMenu);
        this.theView = new JScrollPane(this.thePanel);
        this.theView.setHorizontalScrollBarPolicy(32);
        this.theView.setVerticalScrollBarPolicy(20);
        Dimension viewD = this.theView.getPreferredSize();
        if (cropped) {
            this.theView.setPreferredSize(new Dimension(totalWidth, viewD.height));
        }
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        innerPanel.add((Component)this.theView, "Center");
        this.setContentPane(innerPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainPanel.this.exitForm();
            }
        });
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(this.getClass().getResource("/atktuning/icon.gif"));
        if (image != null) {
            this.setIconImage(image);
        }
        this.splashScreen.setVisible(false);
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
        this.setVisible(true);
    }

    private void showTrendAll() {
        JFrame f = new JFrame();
        Trend graph = new Trend(f);
        f.setTitle("Trends");
        graph.setModel(this.attList);
        f.setContentPane((Container)graph);
        f.pack();
        f.setPreferredSize(new Dimension(640, 480));
        ATKGraphicsUtils.centerFrameOnScreen((Frame)f);
        f.setVisible(true);
    }

    private void setRefreshInterval() {
        if (this.nbPanel <= 0) {
            return;
        }
        int old_it = this.attList.getRefreshInterval();
        String i = JOptionPane.showInputDialog(this, "Enter refresh interval (ms)", new Integer(old_it));
        if (i != null) {
            try {
                int it = Integer.parseInt(i);
                this.attList.setRefreshInterval(it);
                if (this.TacoFactory.getDeviceNumber() > 0) {
                    this.TacoFactory.setRefreshInterval(it);
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, i + " invalid nunber.", "Error", 0);
            }
        }
    }

    private AttItem getItem(String s) {
        AttItem item = new AttItem();
        if (s.startsWith("taco:")) {
            item.isTaco = true;
            String tacoDef = s.substring(5).trim();
            String[] fields = tacoDef.split(",");
            if (fields.length <= 1) {
                item.attName = tacoDef;
            } else {
                item.attName = fields[0];
                item.isSettable = true;
                item.setCommand = fields[1];
                item.setName = fields[2];
            }
        } else {
            item.attName = s;
        }
        return item;
    }

    public AttPanel[] readConfigFile(String filename) {
        FileReader f = null;
        Vector<AttPanel> items = new Vector<AttPanel>();
        try {
            f = new FileReader(filename);
        }
        catch (FileNotFoundException e) {
            Database db = null;
            String path = null;
            try {
                db = ApiUtil.get_db_obj();
                path = db.get_property("AtkTuning", "path").extractString();
            }
            catch (DevFailed e1) {
                this.splashScreen.setVisible(false);
                this.fatalError(e1.errors[0].desc);
                return null;
            }
            try {
                f = new FileReader(path + "/" + filename);
            }
            catch (FileNotFoundException e2) {
                this.splashScreen.setVisible(false);
                this.fatalError(filename + " not found.");
                return null;
            }
        }
        String s = this.readLine(f);
        if (s != null) {
            if (s.startsWith("#")) {
                boolean eof = false;
                while (!eof) {
                    String title;
                    AttPanel panel = new AttPanel();
                    panel.title = title = s.substring(1);
                    boolean eop = false;
                    while (!eop) {
                        s = this.readLine(f);
                        if (s != null) {
                            eop = s.startsWith("#");
                            if (eop) continue;
                            AttItem item = this.getItem(s);
                            panel.items.add(item);
                            continue;
                        }
                        eof = true;
                        eop = true;
                    }
                    items.add(panel);
                }
            } else {
                AttPanel panel = new AttPanel();
                panel.title = s;
                while ((s = this.readLine(f)) != null) {
                    AttItem item = this.getItem(s);
                    panel.items.add(item);
                }
                items.add(panel);
            }
        }
        try {
            f.close();
        }
        catch (IOException e) {
            System.out.println("Warning " + e.getMessage());
        }
        if (items.size() == 0) {
            this.splashScreen.setVisible(false);
            this.fatalError(filename + " is not an atktuning configuration file.");
            return null;
        }
        AttPanel[] ret = new AttPanel[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            ret[i] = (AttPanel)items.get(i);
        }
        return ret;
    }

    private String readLine(FileReader f) {
        int c = 0;
        String result = "";
        boolean eor = false;
        while (!eor) {
            boolean ok;
            try {
                c = f.read();
            }
            catch (IOException e) {
                this.fatalError(f.toString() + " " + e.getMessage());
            }
            boolean bl = ok = c >= 32;
            if (ok) {
                result = result + (char)c;
            }
            eor = c == -1 || !ok && result.length() > 0;
        }
        if (result.length() > 0) {
            return result;
        }
        return null;
    }

    private void fatalError(String message) {
        this.splashScreen.setVisible(false);
        JOptionPane.showMessageDialog(null, message, "Fatal Error", 0);
        this.exitForm();
    }

    private void exitForm() {
        if (this.runFromShell) {
            System.exit(0);
        } else {
            System.out.println("Clear model");
            for (int i = 0; i < this.nbPanel; ++i) {
                this.panels[i].clearModel();
            }
            System.out.println("Clear attList");
            if (this.attList != null) {
                this.attList.stopRefresher();
                this.attList.removeErrorListener((IErrorListener)this.errWin);
                this.attList = null;
            }
            System.out.println("Clear Taco");
            TacoDeviceFactory.getInstance().stopRefresher();
            this.setVisible(false);
            System.out.println("Done");
            this.dispose();
        }
    }

    public static String getVersion() {
        Package p = MainPanel.class.getPackage();
        if (p.getImplementationVersion() != null) {
            return p.getImplementationVersion();
        }
        return "*.*";
    }

    private static void printUsage() {
        System.out.println("Usage: atktuning [-conv res_tag] [-h] [-cmd] [-ro] [-w] [-s] [-f fontname] [-sb] config_filename");
    }

    private static void printHelp() {
        System.out.println("  -conv res_tag : Build a configuration file from TACO resource");
        System.out.println("  -cmd : Show command menu");
        System.out.println("  -ro : Read only mode");
        System.out.println("  -w : Display editor in the panel");
        System.out.println("  -s : Display setting frame button");
        System.out.println("  -f fontname : Font used by viewer Name,style,size (ex -f Dialog,1,14) 0=PLAIN 1=BOLD 2=ITALIC");
        System.out.println("  -sb : Show background when attribute is valid");
        System.out.println("");
        System.out.println("  The config file is a list of tango attributes, each line is");
        System.out.println("  an attribute name (ex: eas/test-api/1/Long_attr).");
        System.out.println("  AtkTuning supports only number scalar attributes.");
        System.out.println("  The first line of the config file is the panel title.");
        System.out.println("  Since the version 2.0, AtkTuning also supports multiple panels");
        System.out.println("  Configuration file examples:");
        System.out.println("   Version1                      Version2 (AtkTunig >2.0)");
        System.out.println("  Test panel                     #Test panel1");
        System.out.println("  jlp/test/1/att_un              jlp/test/1/att_un");
        System.out.println("  jlp/test/1/att_deux            jlp/test/1/att_deux");
        System.out.println("  jlp/test/1/att_trois           #Test panel 2");
        System.out.println("  jlp/test/1/att_quatre          jlp/test/1/att_trois");
        System.out.println("                                 jlp/test/2/att_un");
    }

    public static void main(String[] args) {
        boolean showBackground;
        boolean showSettingFrameButton;
        boolean showEditor;
        boolean roMode;
        int index;
        boolean showCommand;
        String fName = null;
        if (args.length < 1) {
            MainPanel.printUsage();
            System.exit(0);
        }
        if ("-conv".equals(args[0])) {
            if (args.length < 2) {
                MainPanel.printUsage();
                System.out.println("Resource TAG expected.");
                System.exit(0);
            }
            try {
                Utils.getInstance().printXtuningConf(args[1]);
            }
            catch (Exception e) {
                System.out.print(e.getMessage());
            }
            System.exit(0);
        }
        if ("-h".equals(args[0])) {
            MainPanel.printUsage();
            MainPanel.printHelp();
            System.exit(0);
        }
        if (showCommand = "-cmd".equals(args[index = 0])) {
            ++index;
        }
        if (roMode = "-ro".equals(args[index])) {
            ++index;
        }
        if (showEditor = "-w".equals(args[index])) {
            ++index;
        }
        if (showSettingFrameButton = "-s".equals(args[index])) {
            ++index;
        }
        if ("-f".equals(args[index])) {
            if (++index >= args.length) {
                MainPanel.printUsage();
                System.exit(0);
            }
            fName = args[index];
            ++index;
        }
        if (showBackground = "-sb".equals(args[index])) {
            ++index;
        }
        if (args.length < index + 1) {
            MainPanel.printUsage();
            System.exit(0);
        }
        new MainPanel(args[index], true, showCommand, roMode, showEditor, fName, showBackground, showSettingFrameButton);
    }
}

