/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.command;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Group.Group;
import fr.esrf.TangoApi.Group.GroupCmdReply;
import fr.esrf.TangoApi.Group.GroupCmdReplyList;
import fr.esrf.tangoatk.core.CommandExecuteException;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.ICommandGroup;
import fr.esrf.tangoatk.core.IEndGroupExecutionListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.command.ACommand;
import fr.esrf.tangoatk.core.command.CommandFactory;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import java.util.List;

public class VoidVoidCommandGroup
extends CommandList
implements ICommandGroup {
    protected EventSupport propChanges;
    protected Group devGroup;
    protected String uniqueCmdName = null;

    public VoidVoidCommandGroup() {
        this.factory = CommandFactory.getInstance();
        this.devGroup = new Group("VoidVoidCmd Group");
        this.filter = new IEntityFilter(){

            @Override
            public boolean keep(IEntity entity) {
                if (entity instanceof VoidVoidCommand) {
                    if (VoidVoidCommandGroup.this.uniqueCmdName != null && !VoidVoidCommandGroup.this.uniqueCmdName.equalsIgnoreCase(entity.getNameSansDevice())) {
                        return false;
                    }
                    if (VoidVoidCommandGroup.this.uniqueCmdName == null) {
                        VoidVoidCommandGroup.this.uniqueCmdName = new String(entity.getNameSansDevice());
                    }
                    try {
                        VoidVoidCommandGroup.this.devGroup.add(entity.getDevice().getName());
                    }
                    catch (DevFailed ex) {
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        this.propChanges = new EventSupport();
    }

    @Override
    public void setFilter(IEntityFilter filter) {
    }

    @Override
    public void addEndGroupExecutionListener(IEndGroupExecutionListener l) {
        this.propChanges.addEndGroupExecutionListener(l);
    }

    @Override
    public void removeEndGroupExecutionListener(IEndGroupExecutionListener l) {
        this.propChanges.removeEndGroupExecutionListener(l);
    }

    protected void publishEndExecution(List result) {
        this.propChanges.fireEndGroupExecutionEvent(this, result);
    }

    public void loopExecute() {
        long t0 = System.currentTimeMillis();
        IEntity ie = null;
        ICommand ic = null;
        DeviceFactory.getInstance().trace(16, "VoidVoidCommandGroup.loopExecute()  ", t0);
        for (int i = 0; i < this.size(); ++i) {
            ie = (IEntity)this.get(i);
            if (!(ie instanceof VoidVoidCommand)) continue;
            ic = (ICommand)ie;
            ic.execute();
        }
        long t1 = System.currentTimeMillis();
        DeviceFactory.getInstance().trace(16, "VoidVoidCommandGroup.loopExecute()  end of loop", t1);
        this.publishEndExecution(null);
    }

    @Override
    public void execute() {
        long t0 = System.currentTimeMillis();
        GroupCmdReplyList replies = null;
        if (this.uniqueCmdName == null) {
            return;
        }
        if (this.devGroup == null) {
            return;
        }
        if (this.devGroup.get_size(false) <= 0) {
            return;
        }
        try {
            replies = this.devGroup.command_inout(this.uniqueCmdName, true);
            DeviceFactory.getInstance().trace(16, "VoidVoidCommandGroup.execute()  ", t0);
            t0 = System.currentTimeMillis();
            if (replies.has_failed()) {
                for (int i = 0; i < replies.size(); ++i) {
                    IEntity ie;
                    GroupCmdReply reply = (GroupCmdReply)replies.get(i);
                    if (!reply.has_failed() || (ie = this.get(reply.dev_name() + "/" + this.uniqueCmdName)) == null) continue;
                    ACommand acmd = (ACommand)ie;
                    String message = "execute(" + acmd.getName() + ") failed: ";
                    CommandExecuteException cee = this.buildCmdException(message, reply);
                    acmd.cmdError(message, cee);
                }
            }
            if ((DeviceFactory.getInstance().getTraceMode() & 0x10) != 0) {
                String str = this.buildRepliesTrace(replies);
                DeviceFactory.getInstance().trace(16, "VoidVoidCommandGroup replies trace :  " + str, t0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DeviceFactory.getInstance().trace(16, "VoidVoidCommandGroup.execute()  end of loop", t0);
        this.publishEndExecution(null);
    }

    private String buildRepliesTrace(GroupCmdReplyList rep) {
        if (rep == null) {
            String str = "ReplyList is null\n";
            return str;
        }
        if (rep.size() <= 0) {
            String str = "ReplyList is empty\n";
            return str;
        }
        String str = "Nb replies = " + rep.size() + " \n";
        str = rep.has_failed() ? str + "At least one reply has failed\n" : str + "All replies successful\n";
        for (int i = 0; i < rep.size(); ++i) {
            GroupCmdReply reply = (GroupCmdReply)rep.get(i);
            str = str + reply.dev_name() + " ";
            str = reply.has_failed() ? str + "has failed " : str + "successfull ";
            IEntity ie = this.get(reply.dev_name() + "/" + this.uniqueCmdName);
            str = ie == null ? str + "  Cannot get IEntity " : str + "  IEntity = " + ie.getName();
            str = str + "\n";
        }
        return str;
    }

    private CommandExecuteException buildCmdException(String msg, GroupCmdReply reply) {
        CommandExecuteException cee = null;
        DevError[] errs = reply.get_err_stack();
        if (errs == null) {
            cee = new CommandExecuteException(msg);
            return cee;
        }
        if (errs.length <= 0) {
            cee = new CommandExecuteException(msg);
            return cee;
        }
        cee = errs[0].reason != null ? new CommandExecuteException(errs[0].reason, errs) : new CommandExecuteException(msg, errs);
        return cee;
    }

    @Override
    public String getCmdName() {
        return this.uniqueCmdName;
    }

    @Override
    public String getVersion() {
        return "$Id $";
    }

    @Override
    public String toString() {
        String str = null;
        str = this.uniqueCmdName == null ? "CmdName = none\n" : "CmdName = " + this.uniqueCmdName + "\n";
        if (this.devGroup == null) {
            str = str + "DeviceGroup = none\n";
            return str;
        }
        if (this.devGroup.get_size(true) <= 0) {
            str = str + "DeviceGroup = empty\n";
            return str;
        }
        str = str + "DeviceGroup = \n";
        String[] devNames = this.devGroup.get_device_list(true);
        for (int i = 0; i < devNames.length; ++i) {
            str = str + devNames[i] + "\n";
        }
        return str;
    }

    public static void main(String[] args) {
        VoidVoidCommandGroup cmdg = new VoidVoidCommandGroup();
        try {
            cmdg.add("id/id/00/open");
            cmdg.add("fe/id/0/open");
            cmdg.add("fe/id/0/delivery");
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        cmdg.execute();
    }
}

