/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.command;

import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.tangoatk.core.command.ACommand;
import fr.esrf.tangoatk.core.command.ACommandHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

class TableCommandHelper
extends ACommandHelper {
    TableCommandHelper(ACommand command) {
        super(command);
    }

    @Override
    protected DeviceData setInput(List l) {
        return this.setInput((List)l.get(0), (List)l.get(1));
    }

    protected DeviceData setInput(List numerics, List strings) {
        int i;
        int length = strings.size();
        String[] str = new String[length];
        for (i = 0; i < length; ++i) {
            str[i] = (String)strings.get(i);
        }
        length = numerics.size();
        switch (this.getInType()) {
            case 17: {
                int[] ints = new int[length];
                for (i = 0; i < length; ++i) {
                    Double element = (Double)numerics.get(i);
                    ints[i] = element.intValue();
                }
                this.data.insert(new DevVarLongStringArray(ints, str));
                break;
            }
            case 18: {
                double[] doubles = new double[length];
                for (i = 0; i < length; ++i) {
                    Double element = (Double)numerics.get(i);
                    doubles[i] = element;
                }
                this.data.insert(new DevVarDoubleStringArray(doubles, str));
                break;
            }
        }
        return this.data;
    }

    @Override
    protected List<List> extractOutput(DeviceData d) {
        List<Object> strings = new Vector();
        Vector<Number> numerics = new Vector<Number>();
        Vector<List> res = new Vector<List>();
        switch (this.getOutType()) {
            case 17: {
                DevVarLongStringArray lsa = d.extractLongStringArray();
                for (int i = 0; i < lsa.lvalue.length; ++i) {
                    numerics.add(new Integer(lsa.lvalue[i]));
                }
                strings = Arrays.asList(lsa.svalue);
                break;
            }
            case 18: {
                DevVarDoubleStringArray dsa = d.extractDoubleStringArray();
                for (int i = 0; i < dsa.dvalue.length; ++i) {
                    numerics.add(new Double(dsa.dvalue[i]));
                }
                strings = Arrays.asList(dsa.svalue);
                break;
            }
        }
        res.add(numerics);
        res.add(strings);
        return res;
    }
}

