/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.command;

import fr.esrf.TangoApi.DeviceData;
import fr.esrf.tangoatk.core.command.ACommand;
import fr.esrf.tangoatk.core.command.ACommandHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Vector;

class ArrayCommandHelper
extends ACommandHelper {
    ArrayCommandHelper(ACommand command) {
        super(command);
    }

    @Override
    protected DeviceData setInput(List l) {
        int size = l.size();
        switch (this.getInType()) {
            case 10: {
                short[] tmp = new short[size];
                for (int i = 0; i < size; ++i) {
                    tmp[i] = Short.parseShort((String)l.get(i));
                }
                this.data.insert(tmp);
                break;
            }
            case 12: {
                float[] tmp = new float[size];
                for (int i = 0; i < size; ++i) {
                    tmp[i] = Float.parseFloat((String)l.get(i));
                }
                this.data.insert(tmp);
                break;
            }
            case 13: {
                double[] tmp = new double[size];
                for (int i = 0; i < size; ++i) {
                    tmp[i] = Double.parseDouble((String)l.get(i));
                }
                this.data.insert(tmp);
                break;
            }
            case 14: {
                int[] tmp = new int[size];
                for (int i = 0; i < size; ++i) {
                    tmp[i] = Integer.parseInt((String)l.get(i));
                }
                this.data.insert_us(tmp);
                break;
            }
            case 15: {
                long[] tmp = new long[size];
                for (int i = 0; i < size; ++i) {
                    tmp[i] = Long.parseLong((String)l.get(i));
                }
                this.data.insert_ul(tmp);
                break;
            }
            case 11: {
                int[] tmp = new int[size];
                for (int i = 0; i < size; ++i) {
                    tmp[i] = Integer.parseInt((String)l.get(i));
                }
                this.data.insert(tmp);
                break;
            }
            case 16: {
                String[] tmp = new String[size];
                for (int i = 0; i < size; ++i) {
                    tmp[i] = (String)l.get(i);
                }
                this.data.insert(tmp);
                break;
            }
            case 9: {
                byte[] tmp = new byte[size];
                for (int i = 0; i < size; ++i) {
                    tmp[i] = Byte.parseByte((String)l.get(i));
                }
                this.data.insert(tmp);
            }
        }
        return this.data;
    }

    @Override
    protected List<String> extractOutput(DeviceData d) {
        Vector<String> val = new Vector<String>();
        switch (this.getOutType()) {
            case 10: {
                short[] tmp = d.extractShortArray();
                for (int i = 0; i < tmp.length; ++i) {
                    val.add(Short.toString(tmp[i]));
                }
                break;
            }
            case 12: {
                float[] tmp = d.extractFloatArray();
                for (int i = 0; i < tmp.length; ++i) {
                    val.add(Float.toString(tmp[i]));
                }
                break;
            }
            case 13: {
                double[] tmp = d.extractDoubleArray();
                for (int i = 0; i < tmp.length; ++i) {
                    val.add(Double.toString(tmp[i]));
                }
                break;
            }
            case 11: {
                long[] tmp = d.extractULongArray();
                for (int i = 0; i < tmp.length; ++i) {
                    val.add(Long.toString(tmp[i]));
                }
                break;
            }
            case 14: {
                int[] tmp = d.extractUShortArray();
                for (int i = 0; i < tmp.length; ++i) {
                    val.add(Integer.toString(tmp[i]));
                }
                break;
            }
            case 15: {
                long[] tmp = d.extractULongArray();
                for (int i = 0; i < tmp.length; ++i) {
                    val.add(Long.toString(tmp[i]));
                }
                break;
            }
            case 16: {
                String[] tmp = d.extractStringArray();
                for (int i = 0; i < tmp.length; ++i) {
                    val.add(tmp[i]);
                }
                break;
            }
            case 9: {
                byte[] tmp = d.extractByteArray();
                for (int i = 0; i < tmp.length; ++i) {
                    val.add(Byte.toString(tmp[i]));
                }
                break;
            }
        }
        return val;
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.serializeInit();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

