/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.command;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DispLevel;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.tangoatk.core.AtkEventListenerList;
import fr.esrf.tangoatk.core.CommandExecuteException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DisplayLevelProperty;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IResultListener;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StringProperty;
import fr.esrf.tangoatk.core.TypeProperty;
import fr.esrf.tangoatk.core.command.ACommandHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class ACommand
implements ICommand {
    protected ACommandHelper inputHelper;
    protected ACommandHelper outputHelper;
    protected Map<String, Property> propertyMap;
    protected String name;
    protected String nameSansDevice;
    private transient CommandInfo info;
    private Device device;
    protected String error;
    protected List oldResult;
    protected EventSupport propChanges;
    protected Throwable oldt;
    protected String alias;
    protected int executionCount = 0;
    private static String VERSION = "$Id$";

    public String getVersion() {
        return VERSION;
    }

    protected void init(Device d, String cmdName, CommandInfo info) {
        this.propertyMap = new HashMap<String, Property>();
        this.device = d;
        this.nameSansDevice = cmdName;
        this.name = d.getName() + "/" + cmdName;
        this.setInfo(info);
        this.propChanges = new EventSupport();
    }

    @Override
    public Device getDevice() {
        return this.device;
    }

    protected void cmdError(String message, Throwable t) {
        this.propChanges.fireReadErrorEvent(this, t);
        this.oldt = t;
    }

    @Override
    public void storeConfig() {
    }

    @Override
    public Property getProperty(String name) {
        return this.propertyMap.get(name);
    }

    int getInType() {
        return this.getNumericProperty("in_type");
    }

    protected String getTypeName(int type) {
        switch (type) {
            case 1: {
                return "boolean";
            }
            case 2: {
                return "short";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "double";
            }
            case 6: {
                return "ushort";
            }
            case 7: {
                return "ulong";
            }
            case 3: {
                return "long";
            }
            case 8: {
                return "string";
            }
            case 19: {
                return "scalar";
            }
            case 17: {
                return "long string array";
            }
            case 18: {
                return "double string array";
            }
            case 10: {
                return "short array";
            }
            case 12: {
                return "float array";
            }
            case 13: {
                return "double double";
            }
            case 14: {
                return "unsigned short array";
            }
            case 15: {
                return "unsigned long array";
            }
            case 11: {
                return "long array";
            }
            case 9: {
                return "char array";
            }
            case 16: {
                return "string array";
            }
        }
        return " ";
    }

    @Override
    public String getInTypeElemName() {
        return this.getTypeName(this.getInType());
    }

    @Override
    public String getOutTypeElemName() {
        return this.getTypeName(this.getOutType());
    }

    @Override
    public String getTag() {
        return this.getStringProperty("tag");
    }

    @Override
    public String getLevel() {
        return this.getStringProperty("level");
    }

    int getNumericProperty(String name) {
        try {
            return this.getProperty(name).getIntValue();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException(name + " is not a known property");
        }
    }

    int getOutType() {
        return this.getNumericProperty("out_type");
    }

    String getStringProperty(String name) {
        try {
            return this.getProperty(name).getStringValue();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException(name + " is not a known property");
        }
    }

    @Override
    public String getInTypeDescription() {
        return this.getStringProperty("in_type_desc");
    }

    @Override
    public String getOutTypeDescription() {
        return this.getStringProperty("out_type_desc");
    }

    void setInTypeName(String s) {
        this.setProperty("in_type_name", s);
    }

    @Override
    public Map<String, Property> getPropertyMap() {
        return this.propertyMap;
    }

    void setOutTypeName(String s) {
        this.setProperty("out_type_name", s);
    }

    void setProperty(String name, String value) {
        Property p = this.propertyMap.get(name);
        if (p == null) {
            this.propertyMap.put(name, new StringProperty((IEntity)this, name, value, false));
        } else {
            p.setValue(value);
        }
    }

    void setProperty(String name, int value) {
        Property p = this.propertyMap.get(name);
        if (p == null) {
            this.propertyMap.put(name, new TypeProperty(this, name, new Integer(value), false));
        } else {
            p.setValue(new Integer(value));
        }
    }

    protected void setProperty(String name, DispLevel value) {
        Property p = this.propertyMap.get(name);
        if (p == null) {
            this.propertyMap.put(name, new DisplayLevelProperty((IEntity)this, name, value, false));
        } else {
            p.setValue(value);
        }
    }

    void setInfo(CommandInfo info) {
        this.info = info;
        this.setProperty("name", this.name);
        this.setProperty("tag", info.cmd_tag);
        this.setProperty("in_type", info.in_type);
        this.setProperty("out_type", info.out_type);
        this.setProperty("in_type_desc", info.in_type_desc);
        this.setProperty("out_type_desc", info.out_type_desc);
        this.setProperty("level", info.level);
    }

    @Override
    public void refresh() {
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    @Override
    public String getName() {
        return this.getProperty("name").getStringValue();
    }

    @Override
    public String getNameSansDevice() {
        return this.nameSansDevice;
    }

    public String toString() {
        return this.nameSansDevice;
    }

    @Override
    public void addErrorListener(IErrorListener l) {
        this.propChanges.addErrorListener(l);
    }

    @Override
    public void removeErrorListener(IErrorListener l) {
        this.propChanges.removeErrorListener(l);
    }

    @Override
    public boolean takesInput() {
        return !ACommand.isVoid(this.getInType());
    }

    @Override
    public boolean takesTableInput() {
        return ACommand.isTable(this.getInType());
    }

    @Override
    public boolean takesArrayInput() {
        return ACommand.isArray(this.getInType());
    }

    @Override
    public boolean takesScalarInput() {
        return ACommand.isScalar(this.getInType());
    }

    @Override
    public boolean doesOutput() {
        return !ACommand.isVoid(this.getOutType());
    }

    @Override
    public boolean doesArrayOutput() {
        return ACommand.isArray(this.getOutType());
    }

    public static boolean isVoid(int type) {
        return type == 0;
    }

    public static boolean isBoolean(int type) {
        return type == 1;
    }

    public static boolean isString(int type) {
        return type == 8;
    }

    public static boolean isScalar(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: 
            case 23: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static boolean isArray(int type) {
        switch (type) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTable(int type) {
        switch (type) {
            case 17: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    void setDevice(Device d) {
        this.device = d;
    }

    void setName(String s) {
        this.setProperty("name", s);
        this.name = s;
    }

    @Override
    public void execute() {
        this.execute(null);
    }

    @Override
    public void addResultListener(IResultListener l) {
        this.propChanges.addResultListener(l);
    }

    @Override
    public void removeResultListener(IResultListener l) {
        this.propChanges.removeResultListener(l);
    }

    protected void publishResult(List result) {
        this.propChanges.fireResultEvent(this, result);
    }

    protected boolean checkArgin(List l) {
        if (!this.takesInput()) {
            return true;
        }
        if (l == null) {
            String message = "execute (" + this.getName() + ") failed: Invalid argin syntax. Empty argument, you must specify a value.";
            this.cmdError(message, new CommandExecuteException(message));
            return false;
        }
        if (l.size() < 1) {
            String message = "execute (" + this.getName() + ") failed: Invalid argin syntax. Empty argument, you must specify a value.";
            this.cmdError(message, new CommandExecuteException(message));
            return false;
        }
        if (this.takesTableInput() && l.size() < 2) {
            String message = "execute (" + this.getName() + ") failed: Invalid argin syntax. You must specify a list of couples.";
            this.cmdError(message, new CommandExecuteException(message));
            return false;
        }
        if (this.takesTableInput() && l.get(0) == null && l.get(1) == null) {
            String message = "execute (" + this.getName() + ") failed: Invalid argin syntax. You must specify a list of couples.";
            this.cmdError(message, new CommandExecuteException(message));
            return false;
        }
        if (this.takesTableInput() && l.get(0) != null && l.get(1) != null && ((List)l.get(0)).size() == 0 && ((List)l.get(1)).size() == 0) {
            String message = "execute (" + this.getName() + ") failed: Invalid argin syntax. You must specify a list of couples.";
            this.cmdError(message, new CommandExecuteException(message));
            return false;
        }
        return true;
    }

    @Override
    public void execute(List l) {
        ++this.executionCount;
        boolean arginOK = this.checkArgin(l);
        if (!arginOK) {
            return;
        }
        try {
            this.publishResult(this.outputHelper.extractOutput(this.getDevice().executeCommand(this.getName(), this.inputHelper.setInput(l))));
        }
        catch (DevFailed devfailed) {
            this.cmdError("execute(" + this.getName() + " failed", new CommandExecuteException(devfailed));
        }
        catch (Exception e) {
            String message = "execute(" + this.getName() + " failed: " + e + ")";
            this.cmdError(message, new CommandExecuteException(message));
        }
    }

    @Override
    public boolean isOperator() {
        Property prop = this.getProperty("level");
        if (prop != null && prop instanceof DisplayLevelProperty) {
            DisplayLevelProperty dlp = (DisplayLevelProperty)prop;
            return dlp.isOperator();
        }
        return false;
    }

    @Override
    public boolean isExpert() {
        Property prop = this.getProperty("level");
        if (prop != null && prop instanceof DisplayLevelProperty) {
            DisplayLevelProperty dlp = (DisplayLevelProperty)prop;
            return dlp.isExpert();
        }
        return false;
    }

    @Override
    public AtkEventListenerList getListenerList() {
        if (this.propChanges == null) {
            return null;
        }
        return this.propChanges.getListenerList();
    }
}

