/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.IAttributeScalarHistory;
import fr.esrf.tangoatk.core.INumberScalarHistory;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberScalarHelper;
import fr.esrf.tangoatk.core.attribute.NumberScalarHistory;
import java.util.Vector;

public class UShortScalarHelper
extends ANumberScalarHelper {
    public UShortScalarHelper(AAttribute attribute) {
        this.init(attribute);
    }

    @Override
    void init(AAttribute attribute) {
        super.init(attribute);
    }

    @Override
    void insert(DeviceAttribute da, double d) {
        double dUnitFactor = 1.0;
        dUnitFactor = this.attribute.getDisplayUnitFactor();
        if (dUnitFactor == 1.0) {
            da.insert_us((int)d);
        } else {
            int di = (int)(d / dUnitFactor);
            da.insert_us(di);
        }
    }

    @Override
    double getNumberScalarValue(DeviceAttribute devAtt) {
        int[] ushort_arr = null;
        try {
            ushort_arr = devAtt.extractUShortArray();
        }
        catch (DevFailed e) {
            return Double.NaN;
        }
        if (ushort_arr == null) {
            return Double.NaN;
        }
        if (ushort_arr.length < 1) {
            return Double.NaN;
        }
        return ushort_arr[0];
    }

    @Override
    double getNumberScalarSetPoint(DeviceAttribute devAtt) {
        int[] ushort_arr = null;
        try {
            ushort_arr = devAtt.extractUShortArray();
        }
        catch (DevFailed e) {
            return Double.NaN;
        }
        if (ushort_arr == null) {
            return Double.NaN;
        }
        if (ushort_arr.length < 1) {
            return Double.NaN;
        }
        if (ushort_arr.length > 1) {
            return ushort_arr[1];
        }
        return ushort_arr[0];
    }

    @Override
    double getNumberScalarDisplayValue(DeviceAttribute devAtt) {
        int[] ushort_arr = null;
        double dUnitFactor = this.attribute.getDisplayUnitFactor();
        try {
            ushort_arr = devAtt.extractUShortArray();
        }
        catch (DevFailed e) {
            return Double.NaN;
        }
        if (ushort_arr == null) {
            return Double.NaN;
        }
        if (ushort_arr.length < 1) {
            return Double.NaN;
        }
        return (double)ushort_arr[0] * dUnitFactor;
    }

    @Override
    double getNumberScalarDisplaySetPoint(DeviceAttribute devAtt) {
        int[] ushort_arr = null;
        double dUnitFactor = this.attribute.getDisplayUnitFactor();
        try {
            ushort_arr = devAtt.extractUShortArray();
        }
        catch (DevFailed e) {
            return Double.NaN;
        }
        if (ushort_arr == null) {
            return Double.NaN;
        }
        if (ushort_arr.length < 1) {
            return Double.NaN;
        }
        if (ushort_arr.length > 1) {
            return (double)ushort_arr[1] * dUnitFactor;
        }
        return (double)ushort_arr[0] * dUnitFactor;
    }

    @Override
    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Integer((int)d));
    }

    @Override
    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Integer((int)d));
    }

    @Override
    void setMinValue(double d) {
        this.setProperty("min_value", new Integer((int)d));
    }

    @Override
    void setMaxValue(double d) {
        this.setProperty("max_value", new Integer((int)d));
    }

    @Override
    void setMinWarning(double d) {
        this.setProperty("min_warning", new Short((short)d));
    }

    @Override
    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Short((short)d));
    }

    @Override
    void setDeltaT(double d) {
        this.setProperty("delta_t", new Short((short)d));
    }

    @Override
    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Short((short)d));
    }

    @Override
    void setMinWarning(double d, boolean writable) {
        this.setProperty("min_warning", new Short((short)d), writable);
    }

    @Override
    void setMaxWarning(double d, boolean writable) {
        this.setProperty("max_warning", new Short((short)d), writable);
    }

    @Override
    void setDeltaT(double d, boolean writable) {
        this.setProperty("delta_t", new Short((short)d), writable);
    }

    @Override
    void setDeltaVal(double d, boolean writable) {
        this.setProperty("delta_val", new Short((short)d), writable);
    }

    @Override
    void setMinAlarm(double d, boolean writable) {
        this.setProperty("min_alarm", new Integer((int)d), writable);
    }

    @Override
    void setMaxAlarm(double d, boolean writable) {
        this.setProperty("max_alarm", new Integer((int)d), writable);
    }

    @Override
    void setMinValue(double d, boolean writable) {
        this.setProperty("min_value", new Integer((int)d), writable);
    }

    @Override
    void setMaxValue(double d, boolean writable) {
        this.setProperty("max_value", new Integer((int)d), writable);
    }

    protected INumberScalarHistory[] getNumberScalarAttHistory(DeviceDataHistory[] attPollHist) {
        double dUnitFactor = 1.0;
        if (attPollHist.length <= 0) {
            return null;
        }
        dUnitFactor = this.attribute.getDisplayUnitFactor();
        if (dUnitFactor <= 0.0) {
            dUnitFactor = 1.0;
        }
        Vector<NumberScalarHistory> hist = new Vector<NumberScalarHistory>();
        for (int i = 0; i < attPollHist.length; ++i) {
            NumberScalarHistory histElem = new NumberScalarHistory();
            try {
                histElem.setTimestamp(attPollHist[i].getTime());
            }
            catch (Exception ex) {
                histElem.setTimestamp(0L);
            }
            try {
                AttrQuality attq = attPollHist[i].getAttrQuality();
                if (0 == attq.value()) {
                    histElem.setState("VALID");
                } else if (1 == attq.value()) {
                    histElem.setState("INVALID");
                } else if (2 == attq.value()) {
                    histElem.setState("ALARM");
                } else if (4 == attq.value()) {
                    histElem.setState("WARNING");
                } else if (3 == attq.value()) {
                    histElem.setState("CHANGING");
                } else {
                    histElem.setState("UNKNOWN");
                }
            }
            catch (Exception ex) {
                histElem.setState("UNKNOWN");
            }
            try {
                short ushortVal = attPollHist[i].extractUShort();
                double doubleVal = (double)ushortVal * dUnitFactor;
                histElem.setValue(doubleVal);
            }
            catch (Exception ex) {
                histElem.setValue(Double.NaN);
            }
            hist.add(i, histElem);
        }
        INumberScalarHistory[] histArray = hist.toArray(new NumberScalarHistory[0]);
        return histArray;
    }

    protected INumberScalarHistory[] getNumberScalarDeviceAttHistory(DeviceDataHistory[] attPollHist) {
        if (attPollHist.length <= 0) {
            return null;
        }
        Vector<NumberScalarHistory> hist = new Vector<NumberScalarHistory>();
        for (int i = 0; i < attPollHist.length; ++i) {
            NumberScalarHistory histElem = new NumberScalarHistory();
            try {
                histElem.setTimestamp(attPollHist[i].getTime());
            }
            catch (Exception ex) {
                histElem.setTimestamp(0L);
            }
            try {
                AttrQuality attq = attPollHist[i].getAttrQuality();
                if (0 == attq.value()) {
                    histElem.setState("VALID");
                } else if (1 == attq.value()) {
                    histElem.setState("INVALID");
                } else if (2 == attq.value()) {
                    histElem.setState("ALARM");
                } else if (4 == attq.value()) {
                    histElem.setState("WARNING");
                } else if (3 == attq.value()) {
                    histElem.setState("CHANGING");
                } else {
                    histElem.setState("UNKNOWN");
                }
            }
            catch (Exception ex) {
                histElem.setState("UNKNOWN");
            }
            try {
                short ushortVal = attPollHist[i].extractUShort();
                double doubleVal = ushortVal;
                histElem.setValue(doubleVal);
            }
            catch (Exception ex) {
                histElem.setValue(Double.NaN);
            }
            hist.add(i, histElem);
        }
        INumberScalarHistory[] histArray = hist.toArray(new NumberScalarHistory[0]);
        return histArray;
    }

    @Override
    protected IAttributeScalarHistory[] getScalarDeviceAttHistory(DeviceDataHistory[] attPollHist) {
        return this.getNumberScalarDeviceAttHistory(attPollHist);
    }

    @Override
    protected IAttributeScalarHistory[] getScalarAttHistory(DeviceDataHistory[] attPollHist) {
        return this.getNumberScalarAttHistory(attPollHist);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }
}

