/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberImageHelper;

class UShortImageHelper
extends ANumberImageHelper {
    public UShortImageHelper(AAttribute attribute) {
        this.init(attribute);
    }

    @Override
    protected void insert(DeviceAttribute da, double[][] d) {
        double dUnitFactor = 1.0;
        dUnitFactor = this.attribute.getDisplayUnitFactor();
        double[] flatd = UShortImageHelper.flatten(d);
        int[] tmp = new int[flatd.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = (int)(flatd[i] / dUnitFactor);
        }
        da.insert_us(tmp, d[0].length, d.length);
    }

    @Override
    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Short((short)d));
    }

    @Override
    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Short((short)d));
    }

    @Override
    void setMinValue(double d) {
        this.setProperty("min_value", new Short((short)d));
    }

    @Override
    void setMaxValue(double d) {
        this.setProperty("max_value", new Short((short)d));
    }

    @Override
    void setMinWarning(double d) {
        this.setProperty("min_warning", new Short((short)d));
    }

    @Override
    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Short((short)d));
    }

    @Override
    void setDeltaT(double d) {
        this.setProperty("delta_t", new Short((short)d));
    }

    @Override
    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Short((short)d));
    }

    @Override
    void setMinWarning(double d, boolean writable) {
        this.setProperty("min_warning", new Short((short)d), writable);
    }

    @Override
    void setMaxWarning(double d, boolean writable) {
        this.setProperty("max_warning", new Short((short)d), writable);
    }

    @Override
    void setDeltaT(double d, boolean writable) {
        this.setProperty("delta_t", new Short((short)d), writable);
    }

    @Override
    void setDeltaVal(double d, boolean writable) {
        this.setProperty("delta_val", new Short((short)d), writable);
    }

    @Override
    void setMinAlarm(double d, boolean writable) {
        this.setProperty("min_alarm", new Short((short)d), writable);
    }

    @Override
    void setMaxAlarm(double d, boolean writable) {
        this.setProperty("max_alarm", new Short((short)d), writable);
    }

    @Override
    void setMinValue(double d, boolean writable) {
        this.setProperty("min_value", new Short((short)d), writable);
    }

    @Override
    void setMaxValue(double d, boolean writable) {
        this.setProperty("max_value", new Short((short)d), writable);
    }

    @Override
    double[][] getNumberImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int ydim = deviceAttribute.getDimY();
        int xdim = deviceAttribute.getDimX();
        if (ydim != this.retval.length || xdim != this.retval[0].length) {
            this.retval = new double[ydim][xdim];
        }
        int[] tmp = deviceAttribute.extractUShortArray();
        int k = 0;
        for (int i = 0; i < ydim; ++i) {
            for (int j = 0; j < xdim; ++j) {
                this.retval[i][j] = tmp[k++];
            }
        }
        return this.retval;
    }

    @Override
    double[][] getNumberImageDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] tmp = deviceAttribute.extractUShortArray();
        double dUnitFactor = this.attribute.getDisplayUnitFactor();
        int ydim = deviceAttribute.getDimY();
        int xdim = deviceAttribute.getDimX();
        if (ydim != this.retval.length || xdim != this.retval[0].length) {
            this.retval = new double[ydim][xdim];
        }
        int k = 0;
        for (int i = 0; i < ydim; ++i) {
            for (int j = 0; j < xdim; ++j) {
                this.retval[i][j] = (double)tmp[k++] * dUnitFactor;
            }
        }
        return this.retval;
    }

    @Override
    String[][] getImageValueAsString(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] tmp = deviceAttribute.extractUShortArray();
        int ydim = deviceAttribute.getDimY();
        int xdim = deviceAttribute.getDimX();
        String[][] retval_str = new String[ydim][xdim];
        int k = 0;
        for (int i = 0; i < ydim; ++i) {
            for (int j = 0; j < xdim; ++j) {
                retval_str[i][j] = Integer.toString(tmp[k++]);
            }
        }
        return retval_str;
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }
}

