/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.IAttributeScalarHistory;
import fr.esrf.tangoatk.core.INumberScalarHistory;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberScalarHelper;
import fr.esrf.tangoatk.core.attribute.NumberScalarHistory;
import java.util.Vector;

public class ULongScalarHelper
extends ANumberScalarHelper {
    public ULongScalarHelper(AAttribute attribute) {
        this.init(attribute);
    }

    @Override
    void insert(DeviceAttribute da, double d) {
        double dUnitFactor = 1.0;
        dUnitFactor = this.attribute.getDisplayUnitFactor();
        if (dUnitFactor == 1.0) {
            da.insert_ul((long)d);
        } else {
            long li = (long)(d / dUnitFactor);
            da.insert_ul(li);
        }
    }

    @Override
    double getNumberScalarValue(DeviceAttribute devAtt) {
        long[] ulong_arr = null;
        try {
            ulong_arr = devAtt.extractULongArray();
        }
        catch (DevFailed e) {
            return Double.NaN;
        }
        if (ulong_arr == null) {
            return Double.NaN;
        }
        if (ulong_arr.length < 1) {
            return Double.NaN;
        }
        return ulong_arr[0];
    }

    @Override
    double getNumberScalarSetPoint(DeviceAttribute devAtt) {
        long[] ulong_arr = null;
        try {
            ulong_arr = devAtt.extractULongArray();
        }
        catch (DevFailed e) {
            return Double.NaN;
        }
        if (ulong_arr == null) {
            return Double.NaN;
        }
        if (ulong_arr.length < 1) {
            return Double.NaN;
        }
        if (ulong_arr.length > 1) {
            return ulong_arr[1];
        }
        return ulong_arr[0];
    }

    @Override
    double getNumberScalarDisplayValue(DeviceAttribute devAtt) {
        long[] ulong_arr = null;
        double dUnitFactor = this.attribute.getDisplayUnitFactor();
        try {
            ulong_arr = devAtt.extractULongArray();
        }
        catch (DevFailed e) {
            return Double.NaN;
        }
        if (ulong_arr == null) {
            return Double.NaN;
        }
        if (ulong_arr.length < 1) {
            return Double.NaN;
        }
        return (double)ulong_arr[0] * dUnitFactor;
    }

    @Override
    double getNumberScalarDisplaySetPoint(DeviceAttribute devAtt) {
        long[] ulong_arr = null;
        double dUnitFactor = this.attribute.getDisplayUnitFactor();
        try {
            ulong_arr = devAtt.extractULongArray();
        }
        catch (DevFailed e) {
            return Double.NaN;
        }
        if (ulong_arr == null) {
            return Double.NaN;
        }
        if (ulong_arr.length < 1) {
            return Double.NaN;
        }
        if (ulong_arr.length > 1) {
            return (double)ulong_arr[1] * dUnitFactor;
        }
        return (double)ulong_arr[0] * dUnitFactor;
    }

    @Override
    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Long((long)d));
    }

    @Override
    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Long((long)d));
    }

    @Override
    void setMinValue(double d) {
        this.setProperty("min_value", new Long((long)d));
    }

    @Override
    void setMaxValue(double d) {
        this.setProperty("max_value", new Long((long)d));
    }

    @Override
    void setMinWarning(double d) {
        this.setProperty("min_warning", new Long((long)d));
    }

    @Override
    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Long((long)d));
    }

    @Override
    void setDeltaT(double d) {
        this.setProperty("delta_t", new Long((long)d));
    }

    @Override
    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Long((long)d));
    }

    @Override
    void setMinWarning(double d, boolean writable) {
        this.setProperty("min_warning", new Long((long)d), writable);
    }

    @Override
    void setMaxWarning(double d, boolean writable) {
        this.setProperty("max_warning", new Long((long)d), writable);
    }

    @Override
    void setDeltaT(double d, boolean writable) {
        this.setProperty("delta_t", new Long((long)d), writable);
    }

    @Override
    void setDeltaVal(double d, boolean writable) {
        this.setProperty("delta_val", new Long((long)d), writable);
    }

    @Override
    void setMinAlarm(double d, boolean writable) {
        this.setProperty("min_alarm", new Long((long)d), writable);
    }

    @Override
    void setMaxAlarm(double d, boolean writable) {
        this.setProperty("max_alarm", new Long((long)d), writable);
    }

    @Override
    void setMinValue(double d, boolean writable) {
        this.setProperty("min_value", new Long((long)d), writable);
    }

    @Override
    void setMaxValue(double d, boolean writable) {
        this.setProperty("max_value", new Long((long)d), writable);
    }

    protected INumberScalarHistory[] getNumberScalarAttHistory(DeviceDataHistory[] attPollHist) {
        double dUnitFactor = 1.0;
        if (attPollHist.length <= 0) {
            return null;
        }
        dUnitFactor = this.attribute.getDisplayUnitFactor();
        if (dUnitFactor <= 0.0) {
            dUnitFactor = 1.0;
        }
        Vector<NumberScalarHistory> hist = new Vector<NumberScalarHistory>();
        for (int i = 0; i < attPollHist.length; ++i) {
            NumberScalarHistory histElem = new NumberScalarHistory();
            try {
                histElem.setTimestamp(attPollHist[i].getTime());
            }
            catch (Exception ex) {
                histElem.setTimestamp(0L);
            }
            try {
                AttrQuality attq = attPollHist[i].getAttrQuality();
                switch (attq.value()) {
                    case 0: {
                        histElem.setState("VALID");
                        break;
                    }
                    case 1: {
                        histElem.setState("INVALID");
                        break;
                    }
                    case 2: {
                        histElem.setState("ALARM");
                        break;
                    }
                    case 4: {
                        histElem.setState("WARNING");
                        break;
                    }
                    case 3: {
                        histElem.setState("CHANGING");
                        break;
                    }
                    default: {
                        histElem.setState("UNKNOWN");
                        break;
                    }
                }
            }
            catch (Exception ex) {
                histElem.setState("UNKNOWN");
            }
            try {
                int ulongVal = attPollHist[i].extractULong();
                double doubleVal = (double)ulongVal * dUnitFactor;
                histElem.setValue(doubleVal);
            }
            catch (Exception ex) {
                histElem.setValue(Double.NaN);
            }
            hist.add(i, histElem);
        }
        INumberScalarHistory[] histArray = hist.toArray(new NumberScalarHistory[0]);
        return histArray;
    }

    protected INumberScalarHistory[] getNumberScalarDeviceAttHistory(DeviceDataHistory[] attPollHist) {
        double dUnitFactor = 1.0;
        if (attPollHist.length <= 0) {
            return null;
        }
        dUnitFactor = this.attribute.getDisplayUnitFactor();
        if (dUnitFactor <= 0.0) {
            dUnitFactor = 1.0;
        }
        Vector<NumberScalarHistory> hist = new Vector<NumberScalarHistory>();
        for (int i = 0; i < attPollHist.length; ++i) {
            NumberScalarHistory histElem = new NumberScalarHistory();
            try {
                histElem.setTimestamp(attPollHist[i].getTime());
            }
            catch (Exception ex) {
                histElem.setTimestamp(0L);
            }
            try {
                AttrQuality attq = attPollHist[i].getAttrQuality();
                switch (attq.value()) {
                    case 0: {
                        histElem.setState("VALID");
                        break;
                    }
                    case 1: {
                        histElem.setState("INVALID");
                        break;
                    }
                    case 2: {
                        histElem.setState("ALARM");
                        break;
                    }
                    case 4: {
                        histElem.setState("WARNING");
                        break;
                    }
                    case 3: {
                        histElem.setState("CHANGING");
                        break;
                    }
                    default: {
                        histElem.setState("UNKNOWN");
                        break;
                    }
                }
            }
            catch (Exception ex) {
                histElem.setState("UNKNOWN");
            }
            try {
                int ulongVal = attPollHist[i].extractULong();
                double doubleVal = ulongVal;
                histElem.setValue(doubleVal);
            }
            catch (Exception ex) {
                histElem.setValue(Double.NaN);
            }
            hist.add(i, histElem);
        }
        INumberScalarHistory[] histArray = hist.toArray(new NumberScalarHistory[0]);
        return histArray;
    }

    @Override
    protected IAttributeScalarHistory[] getScalarDeviceAttHistory(DeviceDataHistory[] attPollHist) {
        return this.getNumberScalarDeviceAttHistory(attPollHist);
    }

    @Override
    protected IAttributeScalarHistory[] getScalarAttHistory(DeviceDataHistory[] attPollHist) {
        return this.getNumberScalarAttHistory(attPollHist);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }
}

