/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IStringSpectrum;
import fr.esrf.tangoatk.core.IStringSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.StringSpectrumHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class StringSpectrum
extends AAttribute
implements IStringSpectrum {
    StringSpectrumHelper stringSpectHelper = new StringSpectrumHelper(this);
    String[] spectrumValue = null;
    String[] spectrumSetPointValue = null;

    @Override
    public void setStringSpectrumValue(String[] s) {
        try {
            DeviceAttribute da = new DeviceAttribute(this.getNameSansDevice());
            da.insert(s);
            this.writeAtt(da);
            this.refresh();
        }
        catch (DevFailed df) {
            this.setAttError("Couldn't set value", new AttributeSetException(df));
        }
    }

    @Override
    public String[] getStringSpectrumValue() {
        return this.spectrumValue;
    }

    @Override
    public String[] getStringSpectrumSetPoint() {
        return this.spectrumSetPointValue;
    }

    @Override
    public void addListener(IStringSpectrumListener l) {
        this.stringSpectHelper.addStringSpectrumListener(l);
        this.addStateListener(l);
    }

    @Override
    public void removeListener(IStringSpectrumListener l) {
        this.stringSpectHelper.removeStringSpectrumListener(l);
        this.removeStateListener(l);
    }

    @Override
    public void refresh() {
        DeviceAttribute da = null;
        ++this.refreshCount;
        try {
            try {
                da = this.readValueFromNetwork();
                this.spectrumValue = this.stringSpectHelper.getStringSpectrumValue(da);
                this.spectrumSetPointValue = this.stringSpectHelper.getStringSpectrumSetPoint(da);
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed e) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(e.getMessage(), new AttributeReadException(e));
            }
            catch (Error err) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(err.getMessage(), new AttributeReadException(err));
            }
        }
        catch (Throwable th) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("StringSpectrum.refresh() Throwable caught ------------------------------");
            th.printStackTrace();
            System.out.println("StringSpectrum.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute attValue) {
        ++this.refreshCount;
        try {
            try {
                if (attValue == null) {
                    return;
                }
                this.attribute = attValue;
                this.setState(attValue);
                this.timeStamp = attValue.getTimeValMillisSec();
                this.spectrumValue = this.stringSpectHelper.getStringSpectrumValue(attValue);
                this.spectrumSetPointValue = this.stringSpectHelper.getStringSpectrumSetPoint(attValue);
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed e) {
                this.dispatchError(e);
            }
        }
        catch (Exception e) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("StringSpectrum.dispatch() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("StringSpectrum.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed e) {
        this.spectrumValue = null;
        this.spectrumSetPointValue = null;
        this.readAttError(e.getMessage(), new AttributeReadException(e));
    }

    public void periodic(TangoPeriodicEvent evt) {
        ++this.periodicCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(128, "StringSpectrum.periodic method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(128, "StringSpectrum.periodicEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(128, "StringSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "StringSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(128, "StringSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(128, "StringSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("StringSpectrum.periodic.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("StringSpectrum.periodic.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.spectrumValue = this.stringSpectHelper.getStringSpectrumValue(da);
                this.spectrumSetPointValue = this.stringSpectHelper.getStringSpectrumSetPoint(da);
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed dfe) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                System.out.println("StringSpectrum.periodic.extractStringArray() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("StringSpectrum.periodic.extractStringArray()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent evt) {
        ++this.changeCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(32, "StringSpectrum.change method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(32, "StringSpectrum.changeEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(32, "StringSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "StringSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(32, "StringSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(32, "StringSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("StringSpectrum.change.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("StringSpectrum.change.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.spectrumValue = this.stringSpectHelper.getStringSpectrumValue(da);
                this.spectrumSetPointValue = this.stringSpectHelper.getStringSpectrumSetPoint(da);
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed dfe) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                System.out.println("StringSpectrum.change.extractStringArray() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("StringSpectrum.change.extractStringArray()------------------------------------------------");
            }
        }
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(String[] newValue) {
        this.propChanges.fireStringSpectrumEvent(this, newValue, this.timeStamp);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        in.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isSpectrum() {
        return true;
    }

    @Override
    public boolean isImage() {
        return false;
    }
}

