/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeScalarHistory;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.StringScalarHistory;
import java.io.Serializable;
import java.util.Vector;

public class StringAttributeHelper
implements Serializable {
    IAttribute attribute;
    EventSupport propChanges;

    public StringAttributeHelper(IAttribute attribute) {
        this.init(attribute);
    }

    void init(IAttribute attribute) {
        this.setAttribute(attribute);
        this.propChanges = ((AAttribute)attribute).getPropChanges();
    }

    public void setAttribute(IAttribute attribute) {
        this.attribute = attribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String name, Number value) {
        this.attribute.setProperty(name, value);
        this.attribute.storeConfig();
    }

    protected void setProperty(String name, Number value, boolean writable) {
        this.attribute.setProperty(name, value, writable);
    }

    protected StringScalarHistory[] getStringScalarAttHistory(DeviceDataHistory[] attPollHist) {
        if (attPollHist.length <= 0) {
            return null;
        }
        Vector<StringScalarHistory> hist = new Vector<StringScalarHistory>();
        for (int i = 0; i < attPollHist.length; ++i) {
            StringScalarHistory histElem = new StringScalarHistory();
            try {
                histElem.setTimestamp(attPollHist[i].getTime());
            }
            catch (Exception ex) {
                histElem.setTimestamp(0L);
            }
            try {
                AttrQuality attq = attPollHist[i].getAttrQuality();
                if (0 == attq.value()) {
                    histElem.setState("VALID");
                } else if (1 == attq.value()) {
                    histElem.setState("INVALID");
                } else if (2 == attq.value()) {
                    histElem.setState("ALARM");
                } else if (4 == attq.value()) {
                    histElem.setState("WARNING");
                } else if (3 == attq.value()) {
                    histElem.setState("CHANGING");
                } else {
                    histElem.setState("UNKNOWN");
                }
            }
            catch (Exception ex) {
                histElem.setState("UNKNOWN");
            }
            try {
                histElem.setValue(attPollHist[i].extractString());
            }
            catch (Exception ex) {
                histElem.setValue(null);
            }
            hist.add(i, histElem);
        }
        StringScalarHistory[] histArray = hist.toArray(new StringScalarHistory[0]);
        return histArray;
    }

    protected IAttributeScalarHistory[] getScalarAttHistory(DeviceDataHistory[] attPollHist) {
        return this.getStringScalarAttHistory(attPollHist);
    }

    public String getStringScalarSetPoint(DeviceAttribute attribute) {
        String[] str_arr = null;
        try {
            str_arr = attribute.extractStringArray();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        if (str_arr == null) {
            return "???";
        }
        if (str_arr.length < 1) {
            return "???";
        }
        if (str_arr.length > 1) {
            return str_arr[1];
        }
        return str_arr[0];
    }

    public String getVersion() {
        return "$Id$";
    }
}

