/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarHistory;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.IScalarAttribute;
import fr.esrf.tangoatk.core.attribute.ANumber;
import fr.esrf.tangoatk.core.attribute.ANumberScalarHelper;
import fr.esrf.tangoatk.core.attribute.NumberScalarHistory;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JOptionPane;

public class NumberScalar
extends ANumber
implements INumberScalar {
    double scalarValue;
    double setPointValue;
    double devScalarValue;
    double devSetPointValue;
    double[] possibleValues = null;
    double minimumIncrement = Double.NaN;
    String confirmationMessage = null;

    public ANumberScalarHelper getNumberScalarHelper() {
        return (ANumberScalarHelper)this.getNumberHelper();
    }

    @Override
    public IScalarAttribute getWritableAttribute() {
        return null;
    }

    @Override
    public IScalarAttribute getReadableAttribute() {
        return null;
    }

    public double getMinimumIncrement() {
        return this.minimumIncrement;
    }

    public void setMinimumIncrement(double inc) {
        this.minimumIncrement = inc;
    }

    @Override
    public int getXDimension() {
        return 1;
    }

    @Override
    public int getMaxXDimension() {
        return 1;
    }

    @Override
    public void addNumberScalarListener(INumberScalarListener l) {
        this.getNumberScalarHelper().addNumberScalarListener(l);
        this.addStateListener(l);
    }

    @Override
    public void removeNumberScalarListener(INumberScalarListener l) {
        this.getNumberScalarHelper().removeNumberScalarListener(l);
        this.removeStateListener(l);
    }

    public double[][] getNumberValue() {
        double[][] retval = new double[1][1];
        retval[0][0] = this.getNumberScalarValue();
        return retval;
    }

    public double[] getSpectrumValue() {
        double[] retval = new double[]{this.getNumberScalarValue()};
        return retval;
    }

    @Override
    public Number getNumber() {
        try {
            return new Double(this.getNumberScalarValue());
        }
        catch (Exception d) {
            this.readAttError("Couldn't read from network", new ConnectionException(d));
            return new Double(Double.NaN);
        }
    }

    @Override
    public void setNumber(Number n) throws IllegalArgumentException {
        double d = n.doubleValue();
        this.setValue(d);
    }

    public void setValue(double[] d) {
        this.setValue(d[0]);
    }

    public void setValue(double[][] d) {
        this.setValue(d[0][0]);
    }

    @Override
    public void refresh() {
        DeviceAttribute att = null;
        long t0 = System.currentTimeMillis();
        ++this.refreshCount;
        this.trace(4, "NumberScalar.refresh() method called for " + this.getName(), t0);
        try {
            try {
                att = this.readValueFromNetwork();
                if (att == null) {
                    return;
                }
                this.trace(4, "NumberScalar.refresh(" + this.getName() + ") readValueFromNetwork success", t0);
                this.scalarValue = this.getNumberScalarHelper().getNumberScalarDisplayValue(att);
                this.setPointValue = this.getNumberScalarHelper().getNumberScalarDisplaySetPoint(att);
                this.trace(4, "NumberScalar.refresh(" + this.getName() + ") fireValueChanged(scalarValue) success", t0);
                this.getNumberScalarHelper().fireScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (DevFailed e) {
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                this.trace(4, "NumberScalar.refresh(" + this.getName() + ") failed, caught DevFailed; will call readAttError", t0);
                this.readAttError(e.getMessage(), new AttributeReadException(e));
            }
            catch (Error err) {
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                this.trace(4, "NumberScalar.refresh(" + this.getName() + ") failed, caught java.lang.Error; will call readAttError", t0);
                this.readAttError(err.getMessage(), new AttributeReadException(err));
            }
        }
        catch (Throwable th) {
            this.scalarValue = Double.NaN;
            this.setPointValue = Double.NaN;
            this.trace(4, "NumberScalar.refresh(" + this.getName() + ") Code failure, caught other Throwable", t0);
            System.out.println("NumberScalar.refresh() Throwable caught ------------------------------");
            th.printStackTrace();
            System.out.println("NumberScalar.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute attValue) {
        ++this.refreshCount;
        try {
            try {
                if (attValue == null) {
                    return;
                }
                this.attribute = attValue;
                this.setState(attValue);
                this.timeStamp = attValue.getTimeValMillisSec();
                this.scalarValue = this.getNumberScalarHelper().getNumberScalarDisplayValue(attValue);
                this.setPointValue = this.getNumberScalarHelper().getNumberScalarDisplaySetPoint(attValue);
                this.getNumberScalarHelper().fireScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (DevFailed e) {
                this.dispatchError(e);
            }
        }
        catch (Exception e) {
            this.scalarValue = Double.NaN;
            this.setPointValue = Double.NaN;
            System.out.println("NumberScalar.dispatch() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("NumberScalar.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed e) {
        this.scalarValue = Double.NaN;
        this.setPointValue = Double.NaN;
        this.readAttError(e.getMessage(), new AttributeReadException(e));
    }

    @Override
    public void setValue(double d) {
        if (this.confirmationMessage != null && JOptionPane.showConfirmDialog(null, this.confirmationMessage, "Confirmation", 0) != 0) {
            return;
        }
        try {
            DeviceAttribute da = new DeviceAttribute(this.getNameSansDevice());
            this.insert(da, d);
            this.writeAtt(da);
        }
        catch (DevFailed e) {
            this.setAttError("Couldn't set value", new AttributeSetException(e));
        }
        catch (Exception e) {
            System.out.println("Received un exception other than DevFailed while setting a numberScalar");
            this.setAttError("Couldn't set value", new AttributeSetException("Set Exception other than DevFailed."));
        }
    }

    protected void insert(DeviceAttribute da, double[] d) {
        this.insert(da, d[0]);
    }

    protected void insert(DeviceAttribute da, double d) {
        this.getNumberScalarHelper().insert(da, d);
    }

    protected void insert(DeviceAttribute da, String s) {
        this.insert(da, Double.parseDouble(s));
    }

    @Override
    public double getNumberScalarValue() {
        return this.scalarValue;
    }

    @Override
    public double getNumberScalarDeviceValue() {
        double dispUnitFactor = 1.0;
        dispUnitFactor = this.getDisplayUnitFactor();
        if (dispUnitFactor <= 0.0) {
            dispUnitFactor = 1.0;
        }
        this.devScalarValue = this.scalarValue / dispUnitFactor;
        return this.devScalarValue;
    }

    @Override
    public double getNumberScalarStandardValue() {
        double stdUnitFactor = 1.0;
        double devVal = this.getNumberScalarDeviceValue();
        stdUnitFactor = this.getStandardUnitFactor();
        if (stdUnitFactor <= 0.0) {
            stdUnitFactor = 1.0;
        }
        if (stdUnitFactor == 1.0) {
            return devVal;
        }
        double stdVal = devVal * stdUnitFactor;
        return stdVal;
    }

    @Override
    public double getNumberScalarSetPoint() {
        return this.setPointValue;
    }

    @Override
    public double getNumberScalarDeviceSetPoint() {
        double dispUnitFactor = 1.0;
        dispUnitFactor = this.getDisplayUnitFactor();
        if (dispUnitFactor <= 0.0) {
            dispUnitFactor = 1.0;
        }
        this.devSetPointValue = this.setPointValue / dispUnitFactor;
        return this.devSetPointValue;
    }

    @Override
    public double getNumberScalarStandardSetPoint() {
        double stdUnitFactor = 1.0;
        double devVal = this.getNumberScalarDeviceSetPoint();
        stdUnitFactor = this.getStandardUnitFactor();
        if (stdUnitFactor <= 0.0) {
            stdUnitFactor = 1.0;
        }
        if (stdUnitFactor == 1.0) {
            return devVal;
        }
        double stdVal = devVal * stdUnitFactor;
        return stdVal;
    }

    @Override
    public double getNumberScalarSetPointFromDevice() {
        double setPoint;
        try {
            this.setPointValue = setPoint = this.getNumberScalarHelper().getNumberScalarDisplaySetPoint(this.readDeviceValueFromNetwork());
        }
        catch (DevFailed e) {
            this.readAttError(e.getMessage(), new AttributeReadException(e));
            setPoint = Double.NaN;
            this.setPointValue = Double.NaN;
        }
        catch (Exception e) {
            this.readAttError(e.getMessage(), e);
            setPoint = Double.NaN;
            this.setPointValue = Double.NaN;
        }
        return setPoint;
    }

    @Override
    public INumberScalarHistory[] getNumberScalarHistory() {
        INumberScalarHistory[] attHist = null;
        try {
            attHist = (NumberScalarHistory[])this.getNumberScalarHelper().getScalarAttHistory(this.readAttHistoryFromNetwork());
        }
        catch (DevFailed e) {
            this.readAttError(e.getMessage(), new AttributeReadException(e));
            attHist = null;
        }
        catch (Exception e) {
            this.readAttError(e.getMessage(), e);
            attHist = null;
        }
        return attHist;
    }

    @Override
    public INumberScalarHistory[] getNumberScalarDeviceHistory() {
        INumberScalarHistory[] attHist = null;
        try {
            attHist = (NumberScalarHistory[])this.getNumberScalarHelper().getScalarDeviceAttHistory(this.readAttHistoryFromNetwork());
        }
        catch (DevFailed e) {
            this.readAttError(e.getMessage(), new AttributeReadException(e));
            attHist = null;
        }
        catch (Exception e) {
            this.readAttError(e.getMessage(), e);
            attHist = null;
        }
        return attHist;
    }

    @Override
    public void setPossibleValues(double[] vals) {
        if (vals == null) {
            return;
        }
        if (this.possibleValues == null && vals.length > 0) {
            this.possibleValues = vals;
        }
    }

    @Override
    public double[] getPossibleValues() {
        return this.possibleValues;
    }

    public void periodic(TangoPeriodicEvent evt) {
        ++this.periodicCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(128, "NumberScalar.periodic method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(128, "NumberScalar.periodicEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(128, "NumberScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(128, "NumberScalar.periodicEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(128, "NumberScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            this.scalarValue = Double.NaN;
            this.setPointValue = Double.NaN;
            System.out.println("NumberScalar.periodic.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("NumberScalar.periodic.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.scalarValue = this.getNumberScalarHelper().getNumberScalarDisplayValue(da);
                this.setPointValue = this.getNumberScalarHelper().getNumberScalarDisplaySetPoint(da);
                this.getNumberScalarHelper().fireScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (DevFailed dfe) {
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                System.out.println("NumberScalar.periodic.getNumberScalarDisplayValue() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("NumberScalar.periodic.getNumberScalarDisplayValue()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent evt) {
        ++this.changeCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(32, "NumberScalar.change method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(32, "NumberScalar.changeEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(32, "NumberScalar.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "NumberScalar.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(32, "NumberScalar.changeEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(32, "NumberScalar.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            this.scalarValue = Double.NaN;
            this.setPointValue = Double.NaN;
            System.out.println("NumberScalar.change.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("NumberScalar.change.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.scalarValue = this.getNumberScalarHelper().getNumberScalarDisplayValue(da);
                this.setPointValue = this.getNumberScalarHelper().getNumberScalarDisplaySetPoint(da);
                this.getNumberScalarHelper().fireScalarValueChanged(this.scalarValue, this.timeStamp);
            }
            catch (DevFailed dfe) {
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                this.scalarValue = Double.NaN;
                this.setPointValue = Double.NaN;
                System.out.println("NumberScalar.change.getNumberScalarDisplayValue() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("NumberScalar.change.getNumberScalarDisplayValue()------------------------------------------------");
            }
        }
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        in.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isSpectrum() {
        return false;
    }

    @Override
    public boolean isImage() {
        return false;
    }
}

