/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.IAttributeSpectrumHistory;
import fr.esrf.tangoatk.core.INumberSpectrumHistory;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.NumberSpectrumHistory;

public class LongSpectrumHelper
extends ANumberSpectrumHelper {
    public LongSpectrumHelper(AAttribute attribute) {
        this.init(attribute);
    }

    @Override
    void init(AAttribute attribute) {
        super.init(attribute);
    }

    @Override
    void insert(DeviceAttribute da, double[] d) {
        double dUnitFactor = 1.0;
        int[] tmp = new int[d.length];
        dUnitFactor = this.attribute.getDisplayUnitFactor();
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = (int)(d[i] / dUnitFactor);
        }
        da.insert(tmp);
    }

    protected INumberSpectrumHistory[] getNumberSpectrumAttHistory(DeviceDataHistory[] attPollHist) {
        INumberSpectrumHistory[] hist = new NumberSpectrumHistory[attPollHist.length];
        double dUnitFactor = 1.0;
        if (attPollHist.length <= 0) {
            return null;
        }
        dUnitFactor = this.attribute.getDisplayUnitFactor();
        if (dUnitFactor <= 0.0) {
            dUnitFactor = 1.0;
        }
        for (int i = 0; i < attPollHist.length; ++i) {
            NumberSpectrumHistory histElem = new NumberSpectrumHistory();
            try {
                histElem.setTimestamp(attPollHist[i].getTime());
            }
            catch (Exception ex) {
                histElem.setTimestamp(0L);
            }
            try {
                AttrQuality attq = attPollHist[i].getAttrQuality();
                if (0 == attq.value()) {
                    histElem.setState("VALID");
                } else if (1 == attq.value()) {
                    histElem.setState("INVALID");
                } else if (2 == attq.value()) {
                    histElem.setState("ALARM");
                } else if (4 == attq.value()) {
                    histElem.setState("WARNING");
                } else if (3 == attq.value()) {
                    histElem.setState("CHANGING");
                } else {
                    histElem.setState("UNKNOWN");
                }
            }
            catch (Exception ex) {
                histElem.setState("UNKNOWN");
            }
            try {
                int[] vals = attPollHist[i].extractLongArray();
                double[] newVals = new double[vals.length];
                for (int j = 0; j < vals.length; ++j) {
                    newVals[j] = (double)vals[j] * dUnitFactor;
                }
                histElem.setValue(newVals);
            }
            catch (Exception ex) {
                histElem.setValue(new double[0]);
            }
            hist[i] = histElem;
        }
        return hist;
    }

    protected INumberSpectrumHistory[] getNumberSpectrumDeviceAttHistory(DeviceDataHistory[] attPollHist) {
        INumberSpectrumHistory[] hist = new NumberSpectrumHistory[attPollHist.length];
        if (attPollHist.length <= 0) {
            return null;
        }
        for (int i = 0; i < attPollHist.length; ++i) {
            NumberSpectrumHistory histElem = new NumberSpectrumHistory();
            try {
                histElem.setTimestamp(attPollHist[i].getTime());
            }
            catch (Exception ex) {
                histElem.setTimestamp(0L);
            }
            try {
                AttrQuality attq = attPollHist[i].getAttrQuality();
                if (0 == attq.value()) {
                    histElem.setState("VALID");
                } else if (1 == attq.value()) {
                    histElem.setState("INVALID");
                } else if (2 == attq.value()) {
                    histElem.setState("ALARM");
                } else if (4 == attq.value()) {
                    histElem.setState("WARNING");
                } else if (3 == attq.value()) {
                    histElem.setState("CHANGING");
                } else {
                    histElem.setState("UNKNOWN");
                }
            }
            catch (Exception ex) {
                histElem.setState("UNKNOWN");
            }
            try {
                int[] vals = attPollHist[i].extractLongArray();
                double[] newVals = new double[vals.length];
                for (int j = 0; j < vals.length; ++j) {
                    newVals[j] = vals[j];
                }
                histElem.setValue(newVals);
            }
            catch (Exception ex) {
                histElem.setValue(new double[0]);
            }
            hist[i] = histElem;
        }
        return hist;
    }

    @Override
    protected IAttributeSpectrumHistory[] getSpectrumDeviceAttHistory(DeviceDataHistory[] attPollHist) {
        return this.getNumberSpectrumDeviceAttHistory(attPollHist);
    }

    @Override
    protected IAttributeSpectrumHistory[] getSpectrumAttHistory(DeviceDataHistory[] attPollHist) {
        return this.getNumberSpectrumAttHistory(attPollHist);
    }

    @Override
    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Long((long)d));
    }

    @Override
    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Long((long)d));
    }

    @Override
    void setMinValue(double d) {
        this.setProperty("min_value", new Long((long)d));
    }

    @Override
    void setMaxValue(double d) {
        this.setProperty("max_value", new Long((long)d));
    }

    @Override
    void setMinWarning(double d) {
        this.setProperty("min_warning", new Long((long)d));
    }

    @Override
    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Long((long)d));
    }

    @Override
    void setDeltaT(double d) {
        this.setProperty("delta_t", new Long((long)d));
    }

    @Override
    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Long((long)d));
    }

    @Override
    void setMinWarning(double d, boolean writable) {
        this.setProperty("min_warning", new Long((long)d), writable);
    }

    @Override
    void setMaxWarning(double d, boolean writable) {
        this.setProperty("max_warning", new Long((long)d), writable);
    }

    @Override
    void setDeltaT(double d, boolean writable) {
        this.setProperty("delta_t", new Long((long)d), writable);
    }

    @Override
    void setDeltaVal(double d, boolean writable) {
        this.setProperty("delta_val", new Long((long)d), writable);
    }

    @Override
    void setMinAlarm(double d, boolean writable) {
        this.setProperty("min_alarm", new Long((long)d), writable);
    }

    @Override
    void setMaxAlarm(double d, boolean writable) {
        this.setProperty("max_alarm", new Long((long)d), writable);
    }

    @Override
    void setMinValue(double d, boolean writable) {
        this.setProperty("min_value", new Long((long)d), writable);
    }

    @Override
    void setMaxValue(double d, boolean writable) {
        this.setProperty("max_value", new Long((long)d), writable);
    }

    @Override
    double[] getNumberSpectrumValue(DeviceAttribute da) throws DevFailed {
        int[] tmp = da.extractLongArray();
        int nbReadElements = da.getNbRead();
        double[] retval = new double[nbReadElements];
        for (int i = 0; i < nbReadElements; ++i) {
            retval[i] = tmp[i];
        }
        return retval;
    }

    @Override
    double[] getNumberSpectrumSetPoint(DeviceAttribute da) throws DevFailed {
        int nbReadElements;
        int[] tmp = da.extractLongArray();
        int nbSetElements = tmp.length - (nbReadElements = da.getNbRead());
        if (nbSetElements <= 0) {
            return this.getNumberSpectrumValue(da);
        }
        double[] retval = new double[nbSetElements];
        int j = 0;
        for (int i = nbReadElements; i < tmp.length; ++i) {
            retval[j] = tmp[i];
            ++j;
        }
        return retval;
    }

    @Override
    double[] getNumberSpectrumDisplayValue(DeviceAttribute da) throws DevFailed {
        int[] tmp = da.extractLongArray();
        double dUnitFactor = this.attribute.getDisplayUnitFactor();
        int nbReadElements = da.getNbRead();
        double[] retSpectVal = new double[nbReadElements];
        for (int i = 0; i < nbReadElements; ++i) {
            retSpectVal[i] = (double)tmp[i] * dUnitFactor;
        }
        return retSpectVal;
    }

    @Override
    double[] getNumberSpectrumDisplaySetPoint(DeviceAttribute da) throws DevFailed {
        int[] tmp = da.extractLongArray();
        double dUnitFactor = this.attribute.getDisplayUnitFactor();
        int nbReadElements = da.getNbRead();
        int nbSetElements = tmp.length - nbReadElements;
        if (nbSetElements <= 0) {
            return this.getNumberSpectrumDisplayValue(da);
        }
        double[] retval = new double[nbSetElements];
        int j = 0;
        for (int i = nbReadElements; i < tmp.length; ++i) {
            retval[j] = (double)tmp[i] * dUnitFactor;
            ++j;
        }
        return retval;
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }
}

