/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberImageHelper;
import fr.esrf.tangoatk.core.attribute.NumberAttributeHelper;

class Long64ImageHelper
extends ANumberImageHelper {
    public Long64ImageHelper(AAttribute attribute) {
        this.init(attribute);
    }

    @Override
    protected void insert(DeviceAttribute da, double[][] d) {
        double dUnitFactor = 1.0;
        dUnitFactor = this.attribute.getDisplayUnitFactor();
        double[] flatd = NumberAttributeHelper.flatten(d);
        long[] tmp = new long[flatd.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = (long)(flatd[i] / dUnitFactor);
        }
        da.insert(tmp, d[0].length, d.length);
    }

    @Override
    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Long((long)d));
    }

    @Override
    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Long((long)d));
    }

    @Override
    void setMinValue(double d) {
        this.setProperty("min_value", new Long((long)d));
    }

    @Override
    void setMaxValue(double d) {
        this.setProperty("max_value", new Long((long)d));
    }

    @Override
    void setMinWarning(double d) {
        this.setProperty("min_warning", new Long((long)d));
    }

    @Override
    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Long((long)d));
    }

    @Override
    void setDeltaT(double d) {
        this.setProperty("delta_t", new Long((long)d));
    }

    @Override
    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Long((long)d));
    }

    @Override
    void setMinWarning(double d, boolean writable) {
        this.setProperty("min_warning", new Long((long)d), writable);
    }

    @Override
    void setMaxWarning(double d, boolean writable) {
        this.setProperty("max_warning", new Long((long)d), writable);
    }

    @Override
    void setDeltaT(double d, boolean writable) {
        this.setProperty("delta_t", new Long((long)d), writable);
    }

    @Override
    void setDeltaVal(double d, boolean writable) {
        this.setProperty("delta_val", new Long((long)d), writable);
    }

    @Override
    void setMinAlarm(double d, boolean writable) {
        this.setProperty("min_alarm", new Long((long)d), writable);
    }

    @Override
    void setMaxAlarm(double d, boolean writable) {
        this.setProperty("max_alarm", new Long((long)d), writable);
    }

    @Override
    void setMinValue(double d, boolean writable) {
        this.setProperty("min_value", new Long((long)d), writable);
    }

    @Override
    void setMaxValue(double d, boolean writable) {
        this.setProperty("max_value", new Long((long)d), writable);
    }

    @Override
    double[][] getNumberImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int ydim = deviceAttribute.getDimY();
        int xdim = deviceAttribute.getDimX();
        if (ydim != this.retval.length || xdim != this.retval[0].length) {
            this.retval = new double[ydim][xdim];
        }
        long[] tmp = deviceAttribute.extractLong64Array();
        int k = 0;
        for (int i = 0; i < ydim; ++i) {
            for (int j = 0; j < xdim; ++j) {
                this.retval[i][j] = tmp[k++];
            }
        }
        return this.retval;
    }

    @Override
    double[][] getNumberImageDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        long[] tmp = deviceAttribute.extractLong64Array();
        double dUnitFactor = this.attribute.getDisplayUnitFactor();
        int ydim = deviceAttribute.getDimY();
        int xdim = deviceAttribute.getDimX();
        if (ydim != this.retval.length || xdim != this.retval[0].length) {
            this.retval = new double[ydim][xdim];
        }
        int k = 0;
        for (int i = 0; i < ydim; ++i) {
            for (int j = 0; j < xdim; ++j) {
                this.retval[i][j] = (double)tmp[k++] * dUnitFactor;
            }
        }
        return this.retval;
    }

    @Override
    String[][] getImageValueAsString(DeviceAttribute deviceAttribute) throws DevFailed {
        long[] tmp = deviceAttribute.extractLong64Array();
        int ydim = deviceAttribute.getDimY();
        int xdim = deviceAttribute.getDimX();
        String[][] retval_str = new String[ydim][xdim];
        int k = 0;
        for (int i = 0; i < ydim; ++i) {
            for (int j = 0; j < xdim; ++j) {
                retval_str[i][j] = Long.toString(tmp[k++]);
            }
        }
        return retval_str;
    }

    @Override
    public String getVersion() {
        return "$Id: Long64ImageHelper.java 15105 2010-09-24 13:11:54Z poncet $";
    }
}

