/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IEnumSpectrum;
import fr.esrf.tangoatk.core.IEnumSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.EnumSpectrum;
import java.io.Serializable;

public class EnumSpectrumHelper
implements Serializable {
    AAttribute enumSpectAtt;
    EventSupport propChanges;

    public EnumSpectrumHelper(AAttribute attribute) {
        this.init(attribute);
    }

    void init(AAttribute attribute) {
        this.setAttribute(attribute);
        this.propChanges = attribute.getPropChanges();
    }

    public void setAttribute(AAttribute attribute) {
        this.enumSpectAtt = attribute;
    }

    public AAttribute getAttribute() {
        return this.enumSpectAtt;
    }

    private short getOneShortValueFromEnum(String enumVal) throws IllegalArgumentException {
        if (enumVal == null) {
            throw new IllegalArgumentException();
        }
        String[] enumLabels = ((EnumSpectrum)this.enumSpectAtt).getEnumValues();
        if (enumLabels == null) {
            throw new IllegalArgumentException();
        }
        short indEnum = -1;
        for (int i = 0; i < enumLabels.length; ++i) {
            if (!enumVal.equals(enumLabels[i])) continue;
            indEnum = (short)i;
            break;
        }
        if (indEnum >= enumLabels.length) {
            indEnum = -1;
        }
        return indEnum;
    }

    private String getOneEnumValueFromShort(short shortVal) throws IllegalArgumentException {
        String[] enumLabels = ((EnumSpectrum)this.enumSpectAtt).getEnumValues();
        if (enumLabels == null) {
            throw new IllegalArgumentException();
        }
        if (shortVal < 0 || shortVal >= enumLabels.length) {
            throw new IllegalArgumentException();
        }
        return enumLabels[shortVal];
    }

    public short[] getShortValuesFromEnumValues(String[] enumStr) {
        short[] shortValues = new short[enumStr.length];
        for (int i = 0; i < enumStr.length; ++i) {
            try {
                shortValues[i] = this.getOneShortValueFromEnum(enumStr[i]);
                continue;
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        return shortValues;
    }

    public String[] getEnumValuesFromShort(short[] shVals) {
        String[] retVal = new String[shVals.length];
        for (int i = 0; i < shVals.length; ++i) {
            try {
                retVal[i] = this.getOneEnumValueFromShort(shVals[i]);
                continue;
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        return retVal;
    }

    void insert(DeviceAttribute da, String[] enumValues) throws DevFailed, AttributeSetException {
        try {
            short[] shortValues = this.getShortValuesFromEnumValues(enumValues);
            da.insert(shortValues);
        }
        catch (IllegalArgumentException ex) {
            throw new AttributeSetException("Invalid enumeration value");
        }
    }

    String[] getEnumSpectrumValue(DeviceAttribute devAtt) throws DevFailed, AttributeReadException {
        short[] val_rw = devAtt.extractShortArray();
        int nbReadElements = devAtt.getNbRead();
        short[] short_read = new short[nbReadElements];
        if (nbReadElements < 1) {
            throw new AttributeReadException("Invalid shortArray");
        }
        System.arraycopy(val_rw, 0, short_read, 0, nbReadElements);
        return this.getEnumValuesFromShort(short_read);
    }

    String[] getEnumSpectrumSetPoint(DeviceAttribute devAtt) throws DevFailed, AttributeReadException {
        int nbReadElements;
        short[] val_rw = devAtt.extractShortArray();
        int nbSet = val_rw.length - (nbReadElements = devAtt.getNbRead());
        if (nbSet < 1) {
            return this.getEnumSpectrumValue(devAtt);
        }
        short[] short_setPoints = new short[nbSet];
        System.arraycopy(val_rw, nbReadElements, short_setPoints, 0, nbSet);
        return this.getEnumValuesFromShort(short_setPoints);
    }

    public void addEnumSpectrumListener(IEnumSpectrumListener l) {
        this.propChanges.addEnumSpectrumListener(l);
    }

    public void removeEnumSpectrumListener(IEnumSpectrumListener l) {
        this.propChanges.removeEnumSpectrumListener(l);
    }

    void fireEnumSpectrumValueChanged(String[] newEnum, long timeStamp) {
        this.propChanges.fireEnumSpectrumEvent((IEnumSpectrum)((Object)this.enumSpectAtt), newEnum, timeStamp);
    }

    public String getVersion() {
        return "$Id$";
    }
}

