/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.EnumScalar;
import java.io.Serializable;

public class EnumScalarHelper
implements Serializable,
TangoConst {
    AAttribute enumAtt;
    EventSupport propChanges;

    public EnumScalarHelper(AAttribute attribute) {
        this.init(attribute);
    }

    void init(AAttribute attribute) {
        this.setAttribute(attribute);
        this.propChanges = attribute.getPropChanges();
    }

    public void setAttribute(AAttribute attribute) {
        this.enumAtt = attribute;
    }

    public AAttribute getAttribute() {
        return this.enumAtt;
    }

    void insert(DeviceAttribute da, String enumStr) throws DevFailed, AttributeSetException {
        try {
            short shortValue = this.getValueForEnum(enumStr);
            switch (this.enumAtt.config.data_type) {
                case 2: 
                case 29: {
                    da.insert(shortValue);
                    break;
                }
                case 6: {
                    da.insert_us(shortValue);
                    break;
                }
                case 3: {
                    da.insert((int)shortValue);
                    break;
                }
                case 7: {
                    da.insert_ul((int)shortValue);
                    break;
                }
                case 23: {
                    da.insert((long)shortValue);
                    break;
                }
                case 24: {
                    da.insert_u64((long)shortValue);
                    break;
                }
                default: {
                    throw new AttributeSetException("Invalid attribute type for enumeration");
                }
            }
        }
        catch (IllegalArgumentException ex) {
            throw new AttributeSetException("Invalid enumeration value");
        }
    }

    String getEnumScalarValue(DeviceAttribute devAtt) throws DevFailed, AttributeReadException {
        return this.getEnumScalarValue(devAtt, 0);
    }

    String getEnumScalarSetPoint(DeviceAttribute devAtt) throws DevFailed, AttributeReadException {
        if (this.enumAtt.isWritable()) {
            return this.getEnumScalarValue(devAtt, 1);
        }
        return this.getEnumScalarValue(devAtt, 0);
    }

    String getEnumScalarValue(DeviceAttribute devAtt, int idx) throws DevFailed, AttributeReadException {
        try {
            switch (devAtt.getType()) {
                case 2: 
                case 29: {
                    short[] short_arr = devAtt.extractShortArray();
                    if (short_arr.length <= idx) {
                        throw new AttributeReadException("Invalid ShortArray");
                    }
                    return this.getEnumValue(short_arr[idx]);
                }
                case 6: {
                    int[] ushort_arr = devAtt.extractUShortArray();
                    if (ushort_arr.length <= idx) {
                        throw new AttributeReadException("Invalid UShortArray");
                    }
                    return this.getEnumValue((short)ushort_arr[idx]);
                }
                case 3: {
                    int[] long_arr = devAtt.extractLongArray();
                    if (long_arr.length <= idx) {
                        throw new AttributeReadException("Invalid LongArray");
                    }
                    return this.getEnumValue((short)long_arr[idx]);
                }
                case 7: {
                    long[] ulong_arr = devAtt.extractULongArray();
                    if (ulong_arr.length <= idx) {
                        throw new AttributeReadException("Invalid ULongArray");
                    }
                    return this.getEnumValue((short)ulong_arr[idx]);
                }
                case 23: {
                    long[] long64_arr = devAtt.extractLong64Array();
                    if (long64_arr.length <= idx) {
                        throw new AttributeReadException("Invalid Long64Array");
                    }
                    return this.getEnumValue((short)long64_arr[idx]);
                }
                case 24: {
                    long[] ulong64_arr = devAtt.extractULong64Array();
                    if (ulong64_arr.length <= idx) {
                        throw new AttributeReadException("Invalid ULong64Array");
                    }
                    return this.getEnumValue((short)ulong64_arr[idx]);
                }
            }
            throw new AttributeReadException("Invalid attribute type for enumeration");
        }
        catch (IllegalArgumentException ex) {
            throw new AttributeReadException("Invalid enumeration value");
        }
    }

    short getValueForEnum(String enumVal) throws IllegalArgumentException {
        String[] enums = null;
        if (enumVal == null) {
            throw new IllegalArgumentException();
        }
        EnumScalar ens = (EnumScalar)this.enumAtt;
        enums = ens.getEnumValues();
        short indEnum = -1;
        for (int i = 0; i < enums.length; ++i) {
            if (!enumVal.equals(enums[i])) continue;
            indEnum = (short)i;
            break;
        }
        if (indEnum >= enums.length) {
            indEnum = -1;
        }
        return indEnum;
    }

    String getEnumValue(short shortVal) throws IllegalArgumentException {
        String[] enums = null;
        if (shortVal < 0) {
            throw new IllegalArgumentException();
        }
        EnumScalar ens = (EnumScalar)this.enumAtt;
        enums = ens.getEnumValues();
        if (shortVal >= enums.length) {
            throw new IllegalArgumentException();
        }
        String val = enums[shortVal];
        return val;
    }

    public void addEnumScalarListener(IEnumScalarListener l) {
        this.propChanges.addEnumScalarListener(l);
    }

    public void removeEnumScalarListener(IEnumScalarListener l) {
        this.propChanges.removeEnumScalarListener(l);
    }

    void fireEnumScalarValueChanged(String newEnum, long timeStamp) {
        this.propChanges.fireEnumScalarEvent((IEnumScalar)((Object)this.enumAtt), newEnum, timeStamp);
    }

    public String getVersion() {
        return "$Id$";
    }
}

