/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberImageHelper;

class DoubleImageHelper
extends ANumberImageHelper {
    public DoubleImageHelper(AAttribute attribute) {
        this.init(attribute);
    }

    @Override
    protected void insert(DeviceAttribute da, double[][] d) {
        double dUnitFactor = 1.0;
        dUnitFactor = this.attribute.getDisplayUnitFactor();
        double[] flatd = DoubleImageHelper.flatten(d);
        if (dUnitFactor == 1.0) {
            da.insert(flatd, d[0].length, d.length);
            return;
        }
        double[] tmp = new double[flatd.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = flatd[i] / dUnitFactor;
        }
        da.insert(tmp, d[0].length, d.length);
    }

    @Override
    void setMinAlarm(double d, boolean writable) {
        this.setProperty("min_alarm", new Double(d), writable);
    }

    @Override
    void setMaxAlarm(double d, boolean writable) {
        this.setProperty("max_alarm", new Double(d), writable);
    }

    @Override
    void setMinValue(double d, boolean writable) {
        this.setProperty("min_value", new Double(d), writable);
    }

    @Override
    void setMaxValue(double d, boolean writable) {
        this.setProperty("max_value", new Double(d), writable);
    }

    @Override
    void setMinWarning(double d, boolean writable) {
        this.setProperty("min_warning", new Double(d), writable);
    }

    @Override
    void setMaxWarning(double d, boolean writable) {
        this.setProperty("max_warning", new Double(d), writable);
    }

    @Override
    void setDeltaT(double d, boolean writable) {
        this.setProperty("delta_t", new Double(d), writable);
    }

    @Override
    void setDeltaVal(double d, boolean writable) {
        this.setProperty("delta_val", new Double(d), writable);
    }

    @Override
    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Double(d));
    }

    @Override
    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Double(d));
    }

    @Override
    void setMinValue(double d) {
        this.setProperty("min_value", new Double(d));
    }

    @Override
    void setMaxValue(double d) {
        this.setProperty("max_value", new Double(d));
    }

    @Override
    void setMinWarning(double d) {
        this.setProperty("min_warning", new Double(d));
    }

    @Override
    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Double(d));
    }

    @Override
    void setDeltaT(double d) {
        this.setProperty("delta_t", new Double(d));
    }

    @Override
    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Double(d));
    }

    @Override
    double[][] getNumberImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        double[] tmp = deviceAttribute.extractDoubleArray();
        int ydim = deviceAttribute.getDimY();
        int xdim = deviceAttribute.getDimX();
        if (ydim != this.retval.length || this.retval.length == 0 || xdim != this.retval[0].length) {
            this.retval = new double[ydim][xdim];
        }
        int k = 0;
        for (int y = 0; y < ydim; ++y) {
            for (int x = 0; x < xdim; ++x) {
                this.retval[y][x] = tmp[k++];
            }
        }
        return this.retval;
    }

    @Override
    double[][] getNumberImageDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        double[] tmp = deviceAttribute.extractDoubleArray();
        double dUnitFactor = this.attribute.getDisplayUnitFactor();
        int ydim = deviceAttribute.getDimY();
        int xdim = deviceAttribute.getDimX();
        if (ydim != this.retval.length || this.retval.length == 0 || xdim != this.retval[0].length) {
            this.retval = new double[ydim][xdim];
        }
        int k = 0;
        for (int y = 0; y < ydim; ++y) {
            for (int x = 0; x < xdim; ++x) {
                this.retval[y][x] = tmp[k++] * dUnitFactor;
            }
        }
        return this.retval;
    }

    @Override
    String[][] getImageValueAsString(DeviceAttribute deviceAttribute) throws DevFailed {
        double[] tmp = deviceAttribute.extractDoubleArray();
        int ydim = deviceAttribute.getDimY();
        int xdim = deviceAttribute.getDimX();
        String[][] retval_str = new String[ydim][xdim];
        int k = 0;
        for (int i = 0; i < ydim; ++i) {
            for (int j = 0; j < xdim; ++j) {
                retval_str[i][j] = Double.toString(tmp[k++]);
            }
        }
        return retval_str;
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }
}

