/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.BooleanScalarHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BooleanScalar
extends AAttribute
implements IBooleanScalar {
    BooleanScalarHelper booleanHelper = new BooleanScalarHelper(this);
    boolean booleanValue = false;
    boolean setPointValue = false;

    @Override
    public boolean getValue() {
        return this.booleanValue;
    }

    @Override
    public void setValue(boolean b) {
        try {
            DeviceAttribute da = new DeviceAttribute(this.getNameSansDevice());
            da.insert(b);
            this.writeAtt(da);
        }
        catch (DevFailed df) {
            this.setAttError("Couldn't set value", new AttributeSetException(df));
        }
        catch (Exception e) {
            System.out.println("Received un exception other than DevFailed while setting a booleanScalar");
            this.setAttError("Couldn't set value", new AttributeSetException("Set Exception other than DevFailed."));
        }
    }

    @Override
    public int getXDimension() {
        return 1;
    }

    @Override
    public int getMaxXDimension() {
        return 1;
    }

    @Override
    public void refresh() {
        DeviceAttribute att = null;
        ++this.refreshCount;
        try {
            try {
                att = this.readValueFromNetwork();
                if (att == null) {
                    return;
                }
                this.booleanValue = att.extractBoolean();
                this.setPointValue = this.booleanHelper.getBooleanScalarSetPoint(att);
                this.fireValueChanged(this.booleanValue);
            }
            catch (DevFailed e) {
                this.readAttError(e.getMessage(), new AttributeReadException(e));
            }
            catch (Error err) {
                this.readAttError(err.getMessage(), new AttributeReadException(err));
            }
        }
        catch (Throwable th) {
            System.out.println("BooleanScalar.refresh() Throwable caught ------------------------------");
            th.printStackTrace();
            System.out.println("BooleanScalar.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute attValue) {
        ++this.refreshCount;
        try {
            try {
                if (attValue == null) {
                    return;
                }
                this.attribute = attValue;
                this.setState(attValue);
                this.timeStamp = attValue.getTimeValMillisSec();
                this.booleanValue = attValue.extractBoolean();
                this.setPointValue = this.booleanHelper.getBooleanScalarSetPoint(attValue);
                this.fireValueChanged(this.booleanValue);
            }
            catch (DevFailed e) {
                this.dispatchError(e);
            }
        }
        catch (Exception e) {
            System.out.println("BooleanScalar.dispatch() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("BooleanScalar.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed e) {
        this.readAttError(e.getMessage(), new AttributeReadException(e));
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(boolean newValue) {
        this.booleanHelper.fireValueChanged(newValue, this.timeStamp);
    }

    @Override
    public void addBooleanScalarListener(IBooleanScalarListener l) {
        this.booleanHelper.addBooleanScalarListener(l);
        this.addStateListener(l);
    }

    @Override
    public void removeBooleanScalarListener(IBooleanScalarListener l) {
        this.booleanHelper.removeBooleanScalarListener(l);
        this.removeStateListener(l);
    }

    @Override
    public boolean getDeviceValue() {
        try {
            boolean readVal;
            this.booleanValue = readVal = this.readValueFromNetwork().extractBoolean();
        }
        catch (DevFailed e) {
            this.readAttError(e.getMessage(), new AttributeReadException(e));
        }
        catch (Exception e) {
            System.out.println("BooleanScalar.getBooleanDeviceValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("BooleanScalar.getBooleanDeviceValue()------------------------------------------------");
        }
        return this.booleanValue;
    }

    @Override
    public boolean getSetPoint() {
        return this.setPointValue;
    }

    @Override
    public boolean getDeviceSetPoint() {
        boolean setPoint = false;
        try {
            this.setPointValue = setPoint = this.booleanHelper.getBooleanScalarSetPoint(this.readDeviceValueFromNetwork());
        }
        catch (DevFailed e) {
            this.readAttError(e.getMessage(), new AttributeReadException(e));
        }
        catch (Exception e) {
            this.readAttError(e.getMessage(), e);
        }
        return setPoint;
    }

    public void periodic(TangoPeriodicEvent evt) {
        ++this.periodicCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(128, "BooleanScalar.periodic method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(128, "BooleanScalar.periodicEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(128, "BooleanScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "BooleanScalar.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(128, "BooleanScalar.periodicEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(128, "BooleanScalar.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            System.out.println("BooleanScalar.periodic.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("BooleanScalar.periodic.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.booleanValue = da.extractBoolean();
                this.setPointValue = this.booleanHelper.getBooleanScalarSetPoint(da);
                this.fireValueChanged(this.booleanValue);
            }
            catch (DevFailed dfe) {
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                System.out.println("BooleanScalar.periodic.extractBoolean() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("BooleanScalar.periodic.extractBoolean()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent evt) {
        ++this.changeCount;
        this.eventType = evt.isZmqEvent() ? 2 : 1;
        DeviceAttribute da = null;
        long t0 = System.currentTimeMillis();
        this.trace(32, "BooleanScalar.change method called for " + this.getName(), t0);
        try {
            da = evt.getValue();
            this.trace(32, "BooleanScalar.changeEvt.getValue(" + this.getName() + ") success", t0);
        }
        catch (DevFailed dfe) {
            this.trace(32, "BooleanScalar.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", t0);
            if (dfe.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "BooleanScalar.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            } else {
                this.trace(32, "BooleanScalar.changeEvt.getValue(" + this.getName() + ") failed, got other error", t0);
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            return;
        }
        catch (Exception e) {
            this.trace(32, "BooleanScalar.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", t0);
            System.out.println("BooleanScalar.change.getValue() Exception caught ------------------------------");
            e.printStackTrace();
            System.out.println("BooleanScalar.change.getValue()------------------------------------------------");
            return;
        }
        if (da != null) {
            try {
                this.setState(da);
                this.attribute = da;
                this.timeStamp = da.getTimeValMillisSec();
                this.booleanValue = da.extractBoolean();
                this.setPointValue = this.booleanHelper.getBooleanScalarSetPoint(da);
                this.fireValueChanged(this.booleanValue);
            }
            catch (DevFailed dfe) {
                this.readAttError(dfe.getMessage(), new AttributeReadException(dfe));
            }
            catch (Exception e) {
                System.out.println("BooleanScalar.change.extractBoolean() Exception caught ------------------------------");
                e.printStackTrace();
                System.out.println("BooleanScalar.change.extractBoolean()------------------------------------------------");
            }
        }
    }

    private void trace(int level, String msg, long time) {
        DeviceFactory.getInstance().trace(level, msg, time);
    }

    @Override
    public String getVersion() {
        return "$Id$";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        in.defaultReadObject();
        this.serializeInit();
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isSpectrum() {
        return false;
    }

    @Override
    public boolean isImage() {
        return false;
    }
}

